/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.common.item;

import com.dolthhaven.dolt_mod_how.core.registry.DMHItems;
import com.dolthhaven.dolt_mod_how.core.util.DMHUtils;
import com.teamabnormals.caverns_and_chasms.common.item.GoldenBucketItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;

public class DMHGoldenBucketItem
extends GoldenBucketItem {
    public static Map<ResourceLocation, Item> FLUID_TO_BUCKET_MAP = null;

    public DMHGoldenBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        int bucketLevel = tag.m_128451_("FluidLevel");
        BlockHitResult result = DMHGoldenBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid() != Fluids.f_76191_ && bucketLevel >= 2 || player.m_6047_() && this.getFluid() != Fluids.f_76191_ ? ClipContext.Fluid.NONE : ClipContext.Fluid.SOURCE_ONLY));
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)stack, (HitResult)result);
        if (ret != null) {
            return ret;
        }
        if (result.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = result.m_82425_();
        Direction direction = result.m_82434_();
        BlockPos sourcePos = pos.m_121945_(direction);
        if (level.m_7966_(player, pos) && player.m_36204_(sourcePos, direction, stack)) {
            BlockState sourceState = level.m_8055_(pos);
            if (this.getFluid() != Fluids.f_76191_ && (bucketLevel >= 2 || sourceState.m_60819_().m_76152_() != this.getFluid())) {
                BlockPos newPos;
                result = DMHGoldenBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if (result.m_6662_() == HitResult.Type.MISS) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                if (result.m_6662_() != HitResult.Type.BLOCK) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                pos = result.m_82425_();
                direction = result.m_82434_();
                sourcePos = pos.m_121945_(direction);
                BlockState state = level.m_8055_(pos);
                BlockPos blockPos = newPos = !this.canBlockContainFluid(level, pos, state) && (this.getFluid() == Fluids.f_76191_ || bucketLevel >= 2) ? sourcePos : pos;
                if (this.m_142073_(player, level, newPos, result)) {
                    this.checkExtraContent(level, stack, newPos);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, newPos, stack);
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    return InteractionResultHolder.m_19092_((Object)DMHGoldenBucketItem.getEmptySuccessItem((ItemStack)stack, (Player)player), (boolean)level.m_5776_());
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            Block newPos = sourceState.m_60734_();
            if (newPos instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)newPos;
                bucketPickup.m_142598_((LevelAccessor)level, pos, sourceState);
                Fluid fluid = sourceState.m_60819_().m_76152_();
                ItemStack newBucket = ItemStack.f_41583_;
                if (fluid != Fluids.f_76191_ && DMHGoldenBucketItem.getFilledRealBucket(sourceState) != null) {
                    newBucket = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)DMHGoldenBucketItem.getFilledRealBucket(sourceState));
                    if (this.getFluid() != Fluids.f_76191_) {
                        DMHGoldenBucketItem.setFluidLevel((ItemStack)newBucket, (int)(bucketLevel + 1));
                    }
                }
                if (!newBucket.m_41619_()) {
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    bucketPickup.getPickupSound(sourceState).ifPresent(soundEvent -> player.m_5496_(soundEvent, 1.0f, 1.0f));
                    level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
                    if (!level.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, newBucket);
                    }
                    return InteractionResultHolder.m_19092_((Object)newBucket, (boolean)level.m_5776_());
                }
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean m_142073_(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result) {
        LiquidBlockContainer liquidContainer;
        if (!(this.getFluid() instanceof FlowingFluid)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        boolean replaceable = state.m_60722_(this.getFluid());
        if (state.m_60795_() || replaceable || block instanceof LiquidBlockContainer && (liquidContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.getFluid())) {
            LiquidBlockContainer cont;
            if (this.getFluid().getFluidType().isVaporizedOnPlacement(level, pos, new FluidStack(this.getFluid(), 0))) {
                this.getFluid().getFluidType().onVaporize(player, level, pos, new FluidStack(this.getFluid(), 0));
                return true;
            }
            if (block instanceof LiquidBlockContainer && (cont = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.getFluid())) {
                cont.m_7361_((LevelAccessor)level, pos, state, ((FlowingFluid)this.getFluid()).m_76068_(false));
                this.playEmptySound(player, (LevelAccessor)level, pos);
                return true;
            }
            if (!level.f_46443_ && replaceable && !state.m_278721_()) {
                level.m_46961_(pos, true);
            }
            if (!level.m_7731_(pos, this.getFluid().m_76145_().m_76188_(), 11) && !state.m_60819_().m_76170_()) {
                return false;
            }
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        return result != null && this.m_142073_(player, level, result.m_82425_().m_121945_(result.m_82434_()), null);
    }

    private static void initBucketMap() {
        if (FLUID_TO_BUCKET_MAP == null) {
            FLUID_TO_BUCKET_MAP = (Map)Util.m_137469_(new HashMap(), map -> {
                map.put(DMHUtils.Constants.ACID, (Item)DMHItems.GOLDEN_ACID_BUCKET.get());
                map.put(DMHUtils.Constants.PURPLE_SODA, (Item)DMHItems.GOLDEN_PURPLE_SODA_BUCKET.get());
                map.put(DMHUtils.Constants.MOLTEN_LEAD, (Item)DMHItems.GOLDEN_MOLTEN_LEAD_BUCKET.get());
            });
        }
    }

    public static ItemStack getFilledRealBucket(BlockState state) {
        DMHGoldenBucketItem.initBucketMap();
        ResourceLocation loc = DMHUtils.getFluidID(state.m_60819_().m_76152_());
        Item item = FLUID_TO_BUCKET_MAP.get(loc);
        if (item != null) {
            return new ItemStack((ItemLike)item);
        }
        return null;
    }

    private boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, this.getFluid());
    }
}

