/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.common.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class RecoveryCompassItem {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_LOCKED_POS = "LockedPos";
    public static final String TAG_LOCKED_DIMENSION = "LockedDimension";
    public static final String TAG_LOCKED = "IsLocked";

    public static boolean isLocked(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && (tag.m_128441_(TAG_LOCKED_DIMENSION) || tag.m_128441_(TAG_LOCKED_POS));
    }

    public static Optional<ResourceKey<Level>> getLockedDimension(CompoundTag tag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(TAG_LOCKED_DIMENSION)).result();
    }

    @Nullable
    public static GlobalPos getLockedPosition(CompoundTag tag) {
        Optional<ResourceKey<Level>> optional;
        boolean hasLockedPos = tag.m_128441_(TAG_LOCKED_POS);
        boolean hasLockedDimension = tag.m_128441_(TAG_LOCKED_DIMENSION);
        if (hasLockedPos && hasLockedDimension && (optional = RecoveryCompassItem.getLockedDimension(tag)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(TAG_LOCKED_POS));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }

    private static void lock(GlobalPos pos, CompoundTag tag) {
        tag.m_128365_(TAG_LOCKED_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos.m_122646_()));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos.m_122640_()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(dimTag -> tag.m_128365_(TAG_LOCKED_DIMENSION, dimTag));
        tag.m_128379_(TAG_LOCKED, true);
    }

    private static void unlock(CompoundTag tag) {
        tag.m_128473_(TAG_LOCKED_POS);
        tag.m_128473_(TAG_LOCKED_DIMENSION);
        tag.m_128473_(TAG_LOCKED);
    }

    public static InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder originalUse = Items.f_220211_.m_7203_(level, player, hand);
        if (originalUse.m_19089_() != InteractionResult.PASS) {
            return originalUse;
        }
        ItemStack stack = player.m_21120_(hand);
        if (RecoveryCompassItem.isLocked(stack)) {
            RecoveryCompassItem.unlock(stack.m_41783_());
            player.m_5496_(SoundEvents.f_11998_, 0.5f, 0.5f);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        if (player.m_219759_().isPresent()) {
            boolean replaceItem;
            player.m_216990_(SoundEvents.f_12107_);
            boolean bl = replaceItem = !player.m_150110_().f_35937_ && stack.m_41613_() == 1;
            if (replaceItem) {
                RecoveryCompassItem.lock((GlobalPos)player.m_219759_().get(), stack.m_41784_());
            } else {
                ItemStack newStack = new ItemStack((ItemLike)Items.f_220211_);
                CompoundTag newTag = stack.m_41782_() ? stack.m_41783_().m_6426_() : new CompoundTag();
                newStack.m_41751_(newTag);
                RecoveryCompassItem.lock((GlobalPos)player.m_219759_().get(), newTag);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (!player.m_150109_().m_36054_(newStack)) {
                    player.m_36176_(newStack, false);
                }
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

