/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.common.loot.modifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DropSelfLootModifier
extends LootModifier {
    public static final Supplier<Codec<DropSelfLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DropSelfLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DropSelfLootModifier::new)));

    protected DropSelfLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (state != null) {
            generatedLoot.clear();
            DropSelfLootModifier.simulateNormalBreaking(state, generatedLoot);
        }
        return generatedLoot;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void simulateNormalBreaking(BlockState state, ObjectArrayList<ItemStack> loot) {
        DoubleBlockHalf half;
        Comparable comparable;
        Property property;
        Object object = state.m_60734_();
        if (object instanceof SlabBlock) {
            SlabBlock slab = (SlabBlock)object;
            if (state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
                loot.add((Object)new ItemStack((ItemLike)slab.m_5456_(), 2));
                return;
            }
        }
        object = state.m_61147_().iterator();
        do {
            if (object.hasNext()) continue;
            loot.add((Object)new ItemStack((ItemLike)state.m_60734_().m_5456_(), 1));
            return;
        } while (!(property = (Property)object.next()).m_61708_().equals("half") || !((comparable = state.m_61143_(property)) instanceof DoubleBlockHalf) || (half = (DoubleBlockHalf)comparable) != DoubleBlockHalf.UPPER);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

