/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.common.loot.modifiers;

import com.dolthhaven.dolt_mod_how.core.registry.DMHLoot;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public record TrichotomyLootCondition(List<Block> blocks, List<TagKey<Block>> blockTags, List<Block> exclude) implements LootItemCondition
{
    public static final MapCodec<TrichotomyLootCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ForgeRegistries.BLOCKS.getCodec().listOf().fieldOf("blocks").forGetter(TrichotomyLootCondition::blocks), (App)TagKey.m_203877_((ResourceKey)Registries.f_256747_).listOf().fieldOf("blockTags").forGetter(TrichotomyLootCondition::blockTags), (App)ForgeRegistries.BLOCKS.getCodec().listOf().fieldOf("exclude").forGetter(TrichotomyLootCondition::exclude)).apply((Applicative)inst, TrichotomyLootCondition::new));

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)DMHLoot.TRICHOTOMY.get();
    }

    public boolean test(LootContext lootContext) {
        BlockState state = (BlockState)lootContext.m_78953_(LootContextParams.f_81461_);
        if (state != null) {
            Block block = state.m_60734_();
            if (this.exclude().contains(block)) {
                return false;
            }
            for (TagKey<Block> blockTag : this.blockTags()) {
                if (!state.m_204336_(blockTag)) continue;
                return true;
            }
            if (this.blocks().contains(state.m_60734_())) {
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<TrichotomyLootCondition> {
        public void serialize(JsonObject object, TrichotomyLootCondition condition, JsonSerializationContext context) {
            Serializer.serializeArray(object, "blocks", condition.blocks, arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0));
            Serializer.serializeArray(object, "blockTags", condition.blockTags, TagKey::f_203868_);
            Serializer.serializeArray(object, "exclude", condition.exclude, arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0));
            object.add("blocks", context.serialize(condition.blocks));
        }

        private static <V> void serializeArray(JsonObject jsonObject, String name, Iterable<V> contents, Function<V, ResourceLocation> stringFunction) {
            JsonArray array = new JsonArray();
            for (V object : contents) {
                array.add(stringFunction.apply(object).toString());
            }
            jsonObject.add(name, (JsonElement)array);
        }

        private static <V> List<V> deserializeArray(JsonObject object, JsonDeserializationContext context, String name, Function<ResourceLocation, V> parser) {
            JsonArray array = GsonHelper.m_13832_((JsonObject)object, (String)name, null);
            ImmutableList.Builder list = ImmutableList.builder();
            if (array != null) {
                for (JsonElement element : array) {
                    ResourceLocation loc = new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)"element"));
                    list.add(parser.apply(loc));
                }
            }
            return list.build();
        }

        public TrichotomyLootCondition deserialize(JsonObject object, JsonDeserializationContext context) {
            List<Block> blocks = Serializer.deserializeArray(object, context, "blocks", a -> (Block)BuiltInRegistries.f_256975_.m_6612_(a).orElseThrow(() -> new JsonSyntaxException("Unknown block id '" + a + "'")));
            List<TagKey<Block>> blockTags = Serializer.deserializeArray(object, context, "blockTags", a -> TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)a));
            List<Block> exclude = Serializer.deserializeArray(object, context, "exclude", a -> (Block)BuiltInRegistries.f_256975_.m_6612_(a).orElseThrow(() -> new JsonSyntaxException("Unknown block id '" + a + "'")));
            return new TrichotomyLootCondition(blocks, blockTags, exclude);
        }
    }
}

