/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.integration;

import com.bobmowzie.mowziesmobs.server.block.RakedSandBlock;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.dolthhaven.dolt_mod_how.core.util.DMHUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DMHMowziesMobsCompat {
    public static final Supplier<Block> RAKED_ARID_SAND = DMHMowziesMobsCompat.rakedSand(14406560, DMHUtils.Constants.ARID_SAND);
    public static final Supplier<Block> RAKED_RED_ARID_SAND = DMHMowziesMobsCompat.rakedSand(16241568, DMHUtils.Constants.RED_ARID_SAND);
    public static final Supplier<Block> RAKED_ASHEN_SAND = DMHMowziesMobsCompat.rakedSand(5660253, DMHUtils.Constants.ASHEN_SAND);

    private static Supplier<Block> rakedSand(int color, ResourceLocation sandLoc) {
        Block sand = DMHMowziesMobsCompat.getModdedSand(sandLoc);
        return () -> new RakedSandBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)sand), sand.m_49966_());
    }

    private static Block getModdedSand(ResourceLocation location) {
        Block block = DMHUtils.getPotentialBlock(location);
        return block == null ? Blocks.f_49992_ : block;
    }

    public static void playSandRakeSound(Level level, Player player, BlockPos pos) {
        level.m_5594_(player, pos, (SoundEvent)MMSounds.BLOCK_RAKE_SAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void updateRakedSand(Block rakedSand, BlockState rakedState, Level level, BlockPos pos, boolean b) {
        if (rakedSand instanceof RakedSandBlock) {
            RakedSandBlock rakedSandBlock = (RakedSandBlock)rakedSand;
            rakedSandBlock.updateState(rakedState, level, pos, b);
        }
    }

    public static boolean isRakedSand(Block block) {
        return block instanceof RakedSandBlock;
    }

    public static boolean sameRakedState(BlockState state1, BlockState state2) {
        if (!DMHMowziesMobsCompat.isRakedSand(state1.m_60734_()) || !DMHMowziesMobsCompat.isRakedSand(state2.m_60734_())) {
            return false;
        }
        return state1.m_61143_((Property)RakedSandBlock.SHAPE) == state2.m_61143_((Property)RakedSandBlock.SHAPE) && state1.m_60734_() == state2.m_60734_();
    }
}

