/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.client.other;

import com.dolthhaven.dolt_mod_how.core.DoltModHow;
import com.dolthhaven.dolt_mod_how.core.registry.DMHItems;
import com.dolthhaven.dolt_mod_how.core.util.DMHUtils;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.violetmoon.quark.content.tools.module.TorchArrowModule;

@Mod.EventBusSubscriber(modid="dolt_mod_how", value={Dist.CLIENT})
public class DMHClientCompat {
    public static void doCompat() {
        DMHClientCompat.registerItemProperties();
    }

    private static void registerItemProperties() {
        DMHClientCompat.registerCrossbowIfModLoaded("large_arrow", () -> DMHUtils.getPotentialItem("caverns_and_chasms", "large_arrow"), "caverns_and_chasms");
        DMHClientCompat.registerCrossbowIfModLoaded("seeking_arrow", () -> DMHUtils.getPotentialItem("alexscaves", "seeking_arrow"), "alexscaves");
        DMHClientCompat.registerCrossbowIfModLoaded("burrowing_arrow", () -> DMHUtils.getPotentialItem("alexscaves", "burrowing_arrow"), "alexscaves");
        DMHClientCompat.registerCrossbowIfModLoaded("phasmo_arrow", () -> DMHUtils.getPotentialItem("netherexp", "phasmo_arrow"), "netherexp");
        DMHClientCompat.registerCrossbowPredicate("torch_arrow", () -> TorchArrowModule.torch_arrow);
        DMHClientCompat.registerGoldenBucketIfModLoaded(DMHItems.GOLDEN_ACID_BUCKET, new String[]{"caverns_and_chasms", "alexscaves"});
        DMHClientCompat.registerGoldenBucketIfModLoaded(DMHItems.GOLDEN_PURPLE_SODA_BUCKET, new String[]{"caverns_and_chasms", "alexscaves"});
        DMHClientCompat.registerGoldenBucketIfModLoaded(DMHItems.GOLDEN_MOLTEN_LEAD_BUCKET, new String[]{"caverns_and_chasms", "oreganized"});
    }

    private static void registerGoldenBucketIfModLoaded(Supplier<Item> item, String ... modids) {
        if (item.get() == null) {
            DoltModHow.LOGGER.info("Failed to register item " + item + " this is bad report to Dolt Mod How");
            return;
        }
        if (Arrays.stream(modids).allMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0))) {
            DMHClientCompat.registerGoldenBucket(item);
        }
    }

    private static void registerCrossbowIfModLoaded(String name, Supplier<Item> projectile, String ... modids) {
        if (projectile.get() == null) {
            DoltModHow.LOGGER.info("Failed to register crossbow item property " + name + " with item " + projectile.get() + " this is bad please report to dolt mod how");
        }
        if (Arrays.stream(modids).allMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0))) {
            DMHClientCompat.registerCrossbowPredicate(name, projectile);
        }
    }

    private static void registerCrossbowPredicate(String name, Supplier<Item> projectile) {
        ItemProperties.register((Item)Items.f_42717_, (ResourceLocation)DoltModHow.rl(name), (ItemPropertyFunction)DMHClientCompat.createCrossbowProjectilePredicate(projectile));
    }

    private static void registerGoldenBucket(Supplier<Item> bucket) {
        ItemProperties.register((Item)bucket.get(), (ResourceLocation)DoltModHow.rl("level"), (stack, level, entity, hash) -> stack.m_41784_().m_128451_("FluidLevel"));
    }

    private static ItemPropertyFunction createCrossbowProjectilePredicate(Supplier<Item> projectile) {
        return (stack, world, entity, i) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)projectile.get())) ? 1.0f : 0.0f;
    }
}

