/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DMHConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> doMetalOresDropXP;
        public final ForgeConfigSpec.ConfigValue<Boolean> doCropBlocksDropXP;
        public final ForgeConfigSpec.ConfigValue<Integer> minCropXpDrops;
        public final ForgeConfigSpec.ConfigValue<Integer> maxCropXpDrops;
        public final ForgeConfigSpec.ConfigValue<Boolean> xpUponBlockPlace;
        public final ForgeConfigSpec.ConfigValue<Integer> blockPlaceXpChance;
        public final ForgeConfigSpec.ConfigValue<Boolean> lessAnnoyingItemReclaim;
        public final ForgeConfigSpec.ConfigValue<Boolean> hoesRakeSand;
        public final ForgeConfigSpec.ConfigValue<Boolean> doRichSoilGrowFungusColony;
        public final ForgeConfigSpec.ConfigValue<Boolean> doHackyQuiverRecipe;
        public final ForgeConfigSpec.ConfigValue<Boolean> doUnbloatKnifeEnchants;
        public final ForgeConfigSpec.ConfigValue<Boolean> doDispenserCauldrons;
        public final ForgeConfigSpec.ConfigValue<Boolean> doUntillableFarmland;
        public final ForgeConfigSpec.ConfigValue<Boolean> removeOrangeVapor;
        public final ForgeConfigSpec.ConfigValue<Boolean> killBulletPepperPlacement;
        public final ForgeConfigSpec.ConfigValue<Boolean> frogsAreNotStupid;
        public final ForgeConfigSpec.ConfigValue<Boolean> acidCorrodesCopper;
        public final ForgeConfigSpec.ConfigValue<Boolean> sackOfSatingNoRestoreSat;
        public final ForgeConfigSpec.ConfigValue<Boolean> actuallyGoodBiomeTreats;
        public final ForgeConfigSpec.ConfigValue<Boolean> pathfinderQuillMakesCaveMaps;
        public final ForgeConfigSpec.ConfigValue<Boolean> damageReductions;
        public final ForgeConfigSpec.ConfigValue<String> discToSpawnAfterJukeboxStruckWithLightning;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("misc");
            this.lessAnnoyingItemReclaim = builder.comment("If interacting with blocks like Flower Pots and Amendment Placeable Books should put the item they contain into your inventory, thus merging with existing stacks, instead of adding it to your hand, which is EXTREMELY ANNOYING").define("Less Annoying Item Reclaim", true);
            builder.pop();
            builder.push("Vanilla");
            builder.push("metal_ores");
            this.doMetalOresDropXP = builder.comment("If mining ores that normally drop raw ores should grant XP").define("Experienced metal", true);
            builder.pop();
            builder.push("farmland");
            this.doUntillableFarmland = builder.comment("Whether farmland can be untilled by sneak-right clicking them with a hoe").define("Untillable Farmland", true);
            builder.pop();
            builder.push("disc");
            this.discToSpawnAfterJukeboxStruckWithLightning = builder.comment("The disc that should be spawned when a jukebox is struck with lightning. Disables if string is \"no\"").define("Lightning Disc", (Object)"minecraft:music_disc_ward");
            builder.pop();
            builder.push("xp");
            this.xpUponBlockPlace = builder.comment("If placing a block should have a chance to yield experience.").define("Experienced Building", true);
            this.blockPlaceXpChance = builder.comment("Specify n here, where the chance of a block dropping xp is 1/n. Integers only!").define("Building XP chance", (Object)64);
            this.doCropBlocksDropXP = builder.comment("If all blocks that are crops should drop experience.").define("Experienced Crops", true);
            this.minCropXpDrops = builder.comment("Minimum XP a crop block will drop when broken.").define("Minimum Crop XP", (Object)0);
            this.maxCropXpDrops = builder.comment("Maximum XP a crop block will drop when broken.").define("Maximum Crop XP", (Object)1);
            builder.pop();
            builder.push("dispensers");
            this.doDispenserCauldrons = builder.comment("If dispensers should be able to dispense into cauldrons").define("Dispenser Cauldrons", true);
            builder.pop();
            builder.push("enchantments");
            this.damageReductions = builder.comment("If enchantments other than protection should be buffed. Experimental!").define("Erm what the sigma", false);
            builder.pop();
            builder.pop();
            builder.push("atmospheric");
            builder.push("Oranges");
            this.removeOrangeVapor = builder.comment("If oranges can no longer be jumped on to be broken and to create a vapor cloud").define("Normal Oranges", true);
            builder.pop();
            builder.pop();
            builder.push("farmersdelight");
            builder.push("Knife Enchantments");
            this.doUnbloatKnifeEnchants = builder.comment("If knives should no longer receive the silk touch and efficiency from the enchanting table").define("Unbloated Knife Enchantments", true);
            builder.pop();
            builder.pop();
            builder.push("Mowzies Mobs");
            builder.push("Rakes");
            this.hoesRakeSand = builder.comment("If hoes should also be able to rake sand. Disabled by default option for my modpack").define("Hoes Rake Sand", false);
            builder.pop();
            builder.pop();
            builder.push("nethersdelight");
            builder.push("fungus_colonies");
            this.doRichSoilGrowFungusColony = builder.comment("If fungus colonies should grow on normal rich soil instead of soul rich soil").define("Rich Fungus", true);
            builder.pop();
            builder.push("bullet_peppers");
            this.killBulletPepperPlacement = builder.comment("If bullet peppers should become unplaceable, thus killing letios plants forever").define("Kill letios plants", true);
            builder.pop();
            builder.push("magma_cakes");
            this.frogsAreNotStupid = builder.comment("If frogs should become unable to consume magma cakes").define("Magma Cakes Good", false);
            builder.pop();
            builder.pop();
            builder.push("supplementaries");
            builder.push("quivers");
            this.doHackyQuiverRecipe = builder.comment("If processing a quiver in a cutting board will eject all the arrows in that quiver").define("Realistic Quivers", true);
            builder.pop();
            builder.pop();
            builder.push("Alexander Caverns");
            builder.push("Acid");
            this.acidCorrodesCopper = builder.comment("If acid should not corrode copper").define("Good Acid", true);
            builder.pop();
            builder.push("Cave Maps");
            this.pathfinderQuillMakesCaveMaps = builder.comment("If pathfinder quills should make a based sigma cave map instead of a cringe beta vanilla map").define("I'm sorry I said all that", false);
            builder.push("Biome Treats");
            this.actuallyGoodBiomeTreats = builder.comment("If biome treats should work regardless of hunger").define("Okay Treats", true);
            builder.pop();
            builder.push("Sack of Sating");
            this.sackOfSatingNoRestoreSat = builder.comment("If sacks of sating no longer restore saturation").define("Mid sack of sating", false);
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        Client(ForgeConfigSpec.Builder builder) {
        }
    }
}

