/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core.other;

import com.dolthhaven.dolt_mod_how.core.registry.DMHBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;

public class DoubleTypedList<A, B>
extends ArrayList<Object> {
    private final Class<A> aClass;
    private final Class<B> bClass;

    public DoubleTypedList(Class<A> aClass, Class<B> bClass) {
        this.aClass = aClass;
        this.bClass = bClass;
    }

    public static void main(String[] args) {
        DoubleTypedList<RegistryObject, Block> list = DoubleTypedList.of(new Object[]{Blocks.f_50260_, Blocks.f_50487_, DMHBlocks.GLOWSHROOM_COLONY});
        List<Block> block = list.mapB(RegistryObject::get);
    }

    public List<B> mapB(Function<? super A, B> mapper) {
        ArrayList bList = new ArrayList();
        for (Object object : this) {
            Object b = object.getClass() == this.aClass ? object : mapper.apply(object);
            bList.add(b);
        }
        return bList;
    }

    public List<A> mapA(Function<? super B, A> mapper) {
        ArrayList aList = new ArrayList();
        for (Object object : this) {
            Object a = object.getClass() == this.aClass ? object : mapper.apply(object);
            aList.add(a);
        }
        return aList;
    }

    public void forEach(Consumer<A> aAction, Consumer<B> bAction) {
        for (Object object : this) {
            if (object.getClass() == this.aClass) {
                aAction.accept(object);
                continue;
            }
            if (object.getClass() != this.bClass) continue;
            bAction.accept(object);
        }
    }

    public static <A, B> DoubleTypedList<A, B> of(Object ... objects) {
        Class<?> aClass = null;
        Class<?> bClass = null;
        for (Object object : objects) {
            if (aClass == null) {
                aClass = object.getClass();
                continue;
            }
            if (bClass == null) {
                bClass = object.getClass();
                continue;
            }
            throw new IllegalArgumentException("Attempted to place objects of more than 2 types in DoubleTypedList");
        }
        DoubleTypedList<A, B> list = new DoubleTypedList<A, B>(aClass, bClass);
        list.addAll(Arrays.asList(objects));
        return list;
    }
}

