/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core.other.events;

import com.dolthhaven.dolt_mod_how.core.DMHConfig;
import com.dolthhaven.dolt_mod_how.core.registry.DMHParticles;
import com.dolthhaven.dolt_mod_how.data.tag.DMHTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dolt_mod_how")
public class DMHEvent {
    private static final UniformInt COMMON_ORE = UniformInt.m_146622_((int)0, (int)2);
    private static final UniformInt RARE_ORE = UniformInt.m_146622_((int)1, (int)3);

    @SubscribeEvent
    public static void projectileImpact(ProjectileImpactEvent event) {
        HitResult hitResult;
        ThrownTrident trident;
        Projectile projectile = event.getProjectile();
        if (projectile instanceof ThrownTrident && (trident = (ThrownTrident)projectile).m_150194_() && (hitResult = event.getRayTraceResult()) instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)hitResult;
            Level level = trident.m_9236_();
            BlockPos pos = result.m_82425_();
            if (!level.m_46470_() || !level.m_45527_(pos.m_7494_())) {
                return;
            }
            if (level.m_8055_(pos).m_204336_(DMHTags.CHANNELS_LIGHTNING)) {
                ServerPlayer player;
                LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                if (bolt == null) {
                    return;
                }
                bolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_7494_()));
                Entity entity = event.getProjectile().m_19749_();
                bolt.m_20879_(entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null);
                level.m_7967_((Entity)bolt);
                level.m_5594_(null, pos, SoundEvents.f_12521_, SoundSource.WEATHER, 5.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void removePoisonIfPlayerKillsArthropodWithBOA(LivingDeathEvent event) {
        LivingEntity enty = event.getEntity();
        Level level = enty.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel SL = (ServerLevel)level;
            level = event.getSource().m_7639_();
            if (level instanceof LivingEntity) {
                boolean shouldRemovePoison;
                LivingEntity attacker = (LivingEntity)level;
                boolean bl = shouldRemovePoison = attacker.m_21023_(MobEffects.f_19614_) && attacker.m_21120_(InteractionHand.MAIN_HAND).getAllEnchantments().containsKey(Enchantments.f_44979_) && event.getEntity().m_6336_() == MobType.f_21642_;
                if (shouldRemovePoison) {
                    attacker.m_21195_(MobEffects.f_19614_);
                    for (int i = 0; i < 7; ++i) {
                        SL.m_8767_((ParticleOptions)((SimpleParticleType)DMHParticles.POISON_HEART.get()), attacker.m_20208_(0.5), attacker.m_20187_(), attacker.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    SL.m_245803_((Entity)attacker, attacker.m_20097_(), SoundEvents.f_215677_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakOreEvent(BlockEvent.BreakEvent event) {
        if (!((Boolean)DMHConfig.COMMON.doMetalOresDropXP.get()).booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockState state = event.getState();
            if (!event.getPlayer().m_36298_(state) || EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)event.getPlayer()) > 0) {
                return;
            }
            if (event.getExpToDrop() == 0) {
                if (state.m_204336_(DMHTags.COMMON_ORES)) {
                    int exp = COMMON_ORE.m_214085_(level.m_213780_());
                    event.setExpToDrop(exp);
                } else if (state.m_204336_(DMHTags.RARE_ORES)) {
                    event.setExpToDrop(RARE_ORE.m_214085_(level.m_213780_()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakCropsEvent(BlockEvent.BreakEvent event) {
        if (!((Boolean)DMHConfig.COMMON.doCropBlocksDropXP.get()).booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockState state = event.getState();
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                if (!state.m_204336_(DMHTags.NO_XP_CROPS) && cropBlock.m_52307_(state)) {
                    UniformInt crop_sampler = UniformInt.m_146622_((int)((Integer)DMHConfig.COMMON.minCropXpDrops.get()), (int)((Integer)DMHConfig.COMMON.maxCropXpDrops.get()));
                    event.setExpToDrop(crop_sampler.m_214085_(level.m_213780_()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void blockPlacedEvent(BlockEvent.EntityPlaceEvent event) {
        ServerPlayer player;
        Level level;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (level = (player = (ServerPlayer)entity).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.getPlacedBlock().m_204336_(DMHTags.NO_XP_REWARD_ON_PLACE) || !((Boolean)DMHConfig.COMMON.xpUponBlockPlace.get()).booleanValue()) {
                return;
            }
            if (player.m_217043_().m_188503_(((Integer)DMHConfig.COMMON.blockPlaceXpChance.get()).intValue()) == 0) {
                ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)player.m_20182_(), (int)1);
            }
        }
    }
}

