/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core.other.events;

import com.dolthhaven.dolt_mod_how.core.DMHConfig;
import com.dolthhaven.dolt_mod_how.core.network.DMHPacketHandler;
import com.dolthhaven.dolt_mod_how.core.network.S2CRustScrapePacket;
import com.dolthhaven.dolt_mod_how.core.registry.DMHBlocks;
import com.dolthhaven.dolt_mod_how.core.util.DMHUtils;
import com.dolthhaven.dolt_mod_how.integration.DMHACCompat;
import com.dolthhaven.dolt_mod_how.integration.DMHMowziesMobsCompat;
import com.dolthhaven.dolt_mod_how.integration.DMHNeapolitanCompat;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.registry.ModBlocks;

@Mod.EventBusSubscriber(modid="dolt_mod_how")
public class DMHRightClickEvent {
    public static final Map<Block, Block> RAKE_MAP = new HashMap<Block, Block>();
    public static final Map<Block, Block> TILL_MAP = new HashMap<Block, Block>();
    public static final Map<Block, Block> UNRUST_MAP = new HashMap<Block, Block>();

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        DMHRightClickEvent.handleBulletPepper(event);
        DMHRightClickEvent.handleAlphacenePath(event);
        DMHRightClickEvent.handleUntillFarmland(event);
        DMHRightClickEvent.tryUnrustRustyStuff(event);
        DMHRightClickEvent.potStrawberry(event);
        DMHRightClickEvent.rakeSand(event);
    }

    public static void rakeSand(PlayerInteractEvent.RightClickBlock event) {
        BlockState rakedState;
        boolean isHoe;
        if (!ModList.get().isLoaded("mowziesmobs")) {
            return;
        }
        InteractionHand hand = event.getHand();
        Player player = event.getEntity();
        ItemStack stack = player.m_21120_(hand);
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Item rake = DMHUtils.getPotentialItem(DMHUtils.Constants.SAND_RAKE);
        Block rakedSand = DMHMowziesMobsCompat.isRakedSand(state.m_60734_()) ? state.m_60734_() : RAKE_MAP.get(state.m_60734_());
        if (rakedSand == null) {
            return;
        }
        boolean isRake = stack.m_150930_(rake);
        boolean bl = isHoe = stack.canPerformAction(ToolActions.HOE_TILL) && (Boolean)DMHConfig.COMMON.hoesRakeSand.get() != false;
        if (isRake && rakedSand.m_204297_().m_205785_().m_135782_().m_135827_().equals("mowziesmobs")) {
            return;
        }
        BlockPlaceContext context = new BlockPlaceContext(player, hand, stack, event.getHitVec());
        if ((isRake || isHoe) && (rakedState = rakedSand.m_5573_(context)) != null && !DMHMowziesMobsCompat.sameRakedState(state, rakedState)) {
            DMHMowziesMobsCompat.playSandRakeSound(level, player, pos);
            if (!level.f_46443_) {
                level.m_7731_(pos, rakedState, 11);
                rakedSand.m_6807_(rakedState, level, pos, rakedState, false);
                DMHMowziesMobsCompat.updateRakedSand(rakedSand, rakedState, level, pos, false);
                context.m_43722_().m_41622_(1, (LivingEntity)player, p_43122_ -> p_43122_.m_21190_(context.m_43724_()));
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            event.setCanceled(true);
        }
    }

    public static void registerHoeTills() {
        TILL_MAP.put(Blocks.f_50093_, Blocks.f_50493_);
        TILL_MAP.put((Block)ModBlocks.RICH_SOIL_FARMLAND.get(), (Block)ModBlocks.RICH_SOIL.get());
        TILL_MAP.put((Block)ModRegistry.RAKED_GRAVEL.get(), Blocks.f_49994_);
        DMHRightClickEvent.putIfNotNull(TILL_MAP, DMHUtils.getPotentialBlock(DMHUtils.Constants.RAKED_SAND), Blocks.f_49992_);
        DMHRightClickEvent.putIfNotNull(TILL_MAP, DMHUtils.getPotentialBlock(DMHUtils.Constants.RED_RAKED_SAND), Blocks.f_49993_);
        DMHRightClickEvent.putIfNotNull(TILL_MAP, (Block)DMHBlocks.ARID_RAKED_SAND.get(), DMHUtils.getPotentialBlock(DMHUtils.Constants.ARID_SAND));
        DMHRightClickEvent.putIfNotNull(TILL_MAP, (Block)DMHBlocks.RED_ARID_RAKED_SAND.get(), DMHUtils.getPotentialBlock(DMHUtils.Constants.RED_ARID_SAND));
        DMHRightClickEvent.putIfNotNull(TILL_MAP, (Block)DMHBlocks.ASHEN_RAKED_SAND.get(), DMHUtils.getPotentialBlock(DMHUtils.Constants.ASHEN_SAND));
    }

    public static void registerUnRust() {
        if (DMHUtils.alexCavesLoaded()) {
            DMHACCompat.registerUnRust();
        }
    }

    public static void registerRakeables() {
        if (ModList.get().isLoaded("mowziesmobs")) {
            Block arid_sand = DMHUtils.getPotentialBlock(DMHUtils.Constants.ARID_SAND);
            Block red_arid_sand = DMHUtils.getPotentialBlock(DMHUtils.Constants.RED_ARID_SAND);
            Block ashen_sand = DMHUtils.getPotentialBlock(DMHUtils.Constants.ASHEN_SAND);
            Block raked_sand = DMHUtils.getPotentialBlock(DMHUtils.Constants.RAKED_SAND);
            Block raked_red_sand = DMHUtils.getPotentialBlock(DMHUtils.Constants.RED_RAKED_SAND);
            DMHRightClickEvent.putIfNotNull(RAKE_MAP, arid_sand, (Block)DMHBlocks.ARID_RAKED_SAND.get());
            DMHRightClickEvent.putIfNotNull(RAKE_MAP, red_arid_sand, (Block)DMHBlocks.RED_ARID_RAKED_SAND.get());
            DMHRightClickEvent.putIfNotNull(RAKE_MAP, ashen_sand, (Block)DMHBlocks.ASHEN_RAKED_SAND.get());
            DMHRightClickEvent.putIfNotNull(RAKE_MAP, Blocks.f_49992_, raked_sand);
            DMHRightClickEvent.putIfNotNull(RAKE_MAP, Blocks.f_49993_, raked_red_sand);
        }
    }

    private static <A, B> void putIfNotNull(Map<A, B> map, A key, B val) {
        if (key != null && val != null) {
            map.put(key, val);
        }
    }

    private static <V extends Comparable<V>> BlockState setGenericProperty(BlockState state, Property<?> propName, V propertyValue) {
        try {
            Property<?> newProp = propName;
            return (BlockState)state.m_61124_(newProp, propertyValue);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            return state;
        }
    }

    private static void handleAlphacenePath(PlayerInteractEvent.RightClickBlock event) {
        Block alphaceneGrass = (Block)ForgeRegistries.BLOCKS.getValue(DMHUtils.Constants.ALPHACENE_GRASS_BLOCK);
        if (alphaceneGrass == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        if (event.getFace() != Direction.DOWN && stack.canPerformAction(ToolActions.SHOVEL_FLATTEN) && !player.m_5833_() && level.m_46859_(pos.m_7494_()) && state.m_60713_(alphaceneGrass)) {
            level.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                stack.m_41622_(1, (LivingEntity)player, damage -> damage.m_21190_(event.getHand()));
                level.m_7731_(pos, ((Block)DMHBlocks.ALPHACENE_PATH.get()).m_49966_(), 11);
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            event.setCanceled(true);
        }
    }

    public static void handleUntillFarmland(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)DMHConfig.COMMON.doUntillableFarmland.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        if (stack.canPerformAction(ToolActions.HOE_TILL) && player.m_6047_() && event.getFace() != Direction.DOWN && !player.m_5833_()) {
            Block block = TILL_MAP.get(level.m_8055_(pos).m_60734_());
            if (block == null || level.m_45976_(Player.class, new AABB(pos)).contains(player) || !level.m_46859_(pos.m_7494_())) {
                return;
            }
            if (!level.m_5776_()) {
                stack.m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21166_(LivingEntity.m_147233_((ItemStack)stack)));
                level.m_7731_(pos, block.m_49966_(), 3);
            }
            level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            event.setCanceled(true);
        }
    }

    private static void tryUnrustRustyStuff(PlayerInteractEvent.RightClickBlock event) {
        if (!DMHUtils.alexCavesLoaded()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        if (stack.canPerformAction(ToolActions.AXE_SCRAPE) && UNRUST_MAP.containsKey(state.m_60734_())) {
            for (Object dir : Direction.Plane.HORIZONTAL) {
                if (!DMHACCompat.isAcid(level.m_8055_(pos.m_121945_((Direction)dir)))) continue;
                return;
            }
            level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState newState = UNRUST_MAP.get(state.m_60734_()).m_49966_();
            for (Property anyProp : state.m_61147_()) {
                newState = DMHRightClickEvent.setGenericProperty(newState, anyProp, state.m_61143_(anyProp));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            level.m_7731_(pos, newState, 11);
            level.m_247517_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS);
            DMHPacketHandler.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> level.m_46472_()), (Object)new S2CRustScrapePacket(pos));
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
            if (player != null) {
                stack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(event.getHand()));
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            event.setCanceled(true);
        }
    }

    private static void handleBulletPepper(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)DMHConfig.COMMON.killBulletPepperPlacement.get()).booleanValue() || !ModList.get().isLoaded("mynethersdelight")) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item bulletPepper = DMHUtils.getPotentialItem(DMHUtils.Constants.BULLET_PEPPER);
        if (bulletPepper != null && stack.m_150930_(bulletPepper)) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    private static void potStrawberry(PlayerInteractEvent.RightClickBlock event) {
        if (ModList.get().isLoaded("neapolitan")) {
            ItemStack stack = event.getItemStack();
            Player player = event.getEntity();
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            BlockState state = level.m_8055_(pos);
            Item strawberryPip = DMHUtils.getPotentialItem(DMHUtils.Constants.STRAWBERRY_PIPS);
            if (state.m_60713_(Blocks.f_50276_) && stack.m_150930_(strawberryPip)) {
                BlockState newState = ((Block)(DMHNeapolitanCompat.isWhiteStrawberry(level, pos) ? DMHBlocks.POTTED_WHITE_STRAWBERRIES : DMHBlocks.POTTED_STRAWBERRIES).get()).m_49966_();
                level.m_7731_(pos, newState, 3);
                player.m_36220_(Stats.f_12961_);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                level.m_247517_(player, pos, SoundEvents.f_144190_, SoundSource.BLOCKS);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
                event.setCanceled(true);
            }
        }
    }
}

