/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core.registry;

import com.dolthhaven.dolt_mod_how.common.item.ChorusSodaItem;
import com.dolthhaven.dolt_mod_how.core.DoltModHow;
import com.dolthhaven.dolt_mod_how.core.registry.DMHBlocks;
import com.dolthhaven.dolt_mod_how.core.util.DMHUtils;
import com.dolthhaven.dolt_mod_how.integration.DMHCCCompat;
import com.teamabnormals.blueprint.core.util.item.CreativeModeTabContentsPopulator;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.item.MushroomColonyItem;
import vectorwing.farmersdelight.common.registry.ModCreativeTabs;
import vectorwing.farmersdelight.common.registry.ModItems;

@Mod.EventBusSubscriber(modid="dolt_mod_how", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DMHItems {
    public static final ItemSubRegistryHelper HELPER = (ItemSubRegistryHelper)DoltModHow.REGISTRY_HELPER.getItemSubHelper();
    public static final RegistryObject<Item> GLOWSHROOM_COLONY = HELPER.createItem("glowshroom_colony", () -> new MushroomColonyItem((Block)DMHBlocks.GLOWSHROOM_COLONY.get(), new Item.Properties()));
    public static final RegistryObject<Item> CHORUS_SODA = HELPER.createItem("chorus_soda", () -> new ChorusSodaItem(new Item.Properties().m_41489_(Food.CHORUS_SODA).m_41495_(Items.f_42590_)));
    public static final RegistryObject<Item> LEATHER_SCRAPS = HELPER.createItem("leather_scraps", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> ALPHACENE_SALAD = HELPER.createItem("alphacene_salad", () -> new ConsumableItem(new Item.Properties().m_41489_(Food.ALPHACENE_SALAD).m_41495_(Items.f_42399_).m_41487_(16), true));
    public static final RegistryObject<Item> GOLDEN_ACID_BUCKET = HELPER.createItem("golden_acid_bucket", BlockSubRegistryHelper.areModsLoaded((String[])new String[]{"caverns_and_chasms", "alexscaves"}) ? DMHCCCompat.GOLDEN_ACID_BUCKET : () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> GOLDEN_PURPLE_SODA_BUCKET = HELPER.createItem("golden_purple_soda_bucket", BlockSubRegistryHelper.areModsLoaded((String[])new String[]{"caverns_and_chasms", "alexscaves"}) ? DMHCCCompat.GOLDEN_PURPLE_SODA_BUCKET : () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> GOLDEN_MOLTEN_LEAD_BUCKET = HELPER.createItem("golden_molten_lead_bucket", BlockSubRegistryHelper.areModsLoaded((String[])new String[]{"caverns_and_chasms", "oreganized"}) ? DMHCCCompat.GOLDEN_MOLTEN_LEAD_BUCKET : () -> new Item(new Item.Properties()));

    public static void setUpTabEditors() {
        CreativeModeTabContentsPopulator.mod((String)"dolt_mod_how").tab(CreativeModeTabs.f_256788_).addItemsAfter(DMHItems.ofID(DMHUtils.Constants.STURDY_STONE, new String[0]), new Supplier[]{DMHBlocks.STURDY_DEEPSLATE}).addItemsBefore(DMHItems.modLoaded((ItemLike)Blocks.f_256831_, "woodworks"), new Supplier[]{DMHBlocks.PEWEN_BOARDS}).tab(CreativeModeTabs.f_256839_).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42787_}), new Supplier[]{CHORUS_SODA}).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42400_}), new Supplier[]{ALPHACENE_SALAD}).tab(CreativeModeTabs.f_256791_).addItemsAfter(DMHItems.modLoaded((ItemLike)Blocks.f_50155_, "alexscaves"), new Supplier[]{DMHBlocks.PEWEN_LADDER}).addItemsAfter(DMHItems.modLoaded((ItemLike)Blocks.f_50718_, "alexscaves"), new Supplier[]{DMHBlocks.PEWEN_BEEHIVE}).addItemsAfter(DMHItems.modLoaded((ItemLike)Blocks.f_244299_, "alexscaves"), new Supplier[]{DMHBlocks.PEWEN_BOOKSHELF, DMHBlocks.CHISELED_PEWEN_BOOKSHELF}).addItemsAfter(DMHItems.modLoaded((ItemLike)Blocks.f_50087_, "alexscaves"), new Supplier[]{DMHBlocks.PEWEN_CHEST}).tab(CreativeModeTabs.f_256968_).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_}), new Supplier[]{LEATHER_SCRAPS}).tab(CreativeModeTabs.f_256776_).addItemsAfter(DMHItems.modLoaded((ItemLike)Blocks.f_50335_, "alexscaves"), new Supplier[]{DMHBlocks.PINE_NUTS_CRATE}).addItemsBefore(DMHItems.modLoaded((ItemLike)Blocks.f_152470_, "woodworks"), new Supplier[]{DMHBlocks.ANCIENT_LEAF_PILE}).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151032_}), new Supplier[]{DMHBlocks.ALPHACENE_PATH}).tab(CreativeModeTabs.f_257028_).addItemsAfter(DMHItems.modLoaded((ItemLike)Blocks.f_50325_, "alexscaves"), new Supplier[]{DMHBlocks.TRAPPED_PEWEN_CHEST}).tab(CreativeModeTabs.f_256869_).addItemsAfter(DMHItems.ofID(DMHUtils.Constants.GOLDEN_LAVA_BUCKET, "caverns_and_chasms", "alexscaves"), new Supplier[]{GOLDEN_ACID_BUCKET, GOLDEN_PURPLE_SODA_BUCKET}).addItemsAfter(DMHItems.ofID(DMHUtils.Constants.GOLDEN_LAVA_BUCKET, "caverns_and_chasms", "oreganized"), new Supplier[]{GOLDEN_MOLTEN_LEAD_BUCKET}).predicate(DMHItems::fdPredicate).addItemsAfter(DMHItems.ofID(ModItems.RED_MUSHROOM_COLONY.getId(), new String[0]), new Supplier[]{GLOWSHROOM_COLONY}).addItemsBefore(DMHItems.ofID(ModItems.BAMBOO_CABINET.getId(), new String[0]), new Supplier[]{DMHBlocks.PEWEN_CABINET}).predicate(DMHItems::mowziesPredicate).addItemsAfter(DMHItems.ofID(DMHUtils.Constants.RED_RAKED_SAND, "atmospheric"), new Supplier[]{DMHBlocks.ARID_RAKED_SAND, DMHBlocks.RED_ARID_RAKED_SAND}).addItemsAfter(DMHItems.ofID(DMHUtils.Constants.RED_RAKED_SAND, "blasted_barrens"), new Supplier[]{DMHBlocks.ASHEN_RAKED_SAND});
    }

    public static Predicate<ItemStack> modLoaded(ItemLike item, String ... modids) {
        return stack -> BlockSubRegistryHelper.areModsLoaded((String[])modids) && Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}).test(stack);
    }

    public static Predicate<ItemStack> ofID(ResourceLocation location, String ... modids) {
        return stack -> BlockSubRegistryHelper.areModsLoaded((String[])modids) && Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(location)}).test(stack);
    }

    public static boolean fdPredicate(BuildCreativeModeTabContentsEvent event) {
        return event.getTabKey() == ModCreativeTabs.TAB_FARMERS_DELIGHT.getKey();
    }

    public static boolean mowziesPredicate(BuildCreativeModeTabContentsEvent event) {
        return event.getTabKey().m_135782_().equals((Object)DMHUtils.Constants.MOWZIES_MOBS_TAB);
    }

    public static class Food {
        public static final FoodProperties CHORUS_SODA = new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19620_, 50, 0), 1.0f).m_38767_();
        public static final FoodProperties ALPHACENE_SALAD = new FoodProperties.Builder().m_38765_().m_38760_(6).m_38758_(0.6f).effect(() -> new MobEffectInstance(MobEffects.f_19605_, 100, 0), 1.0f).m_38767_();
    }
}

