/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.data.client;

import com.bobmowzie.mowziesmobs.server.block.RakedSandBlock;
import com.davigj.blasted_barrens.core.registry.BBBlocks;
import com.dolthhaven.dolt_mod_how.core.DoltModHow;
import com.dolthhaven.dolt_mod_how.core.registry.DMHBlocks;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class DMHBlockStatesGen
extends BlueprintBlockStateProvider {
    public DMHBlockStatesGen(GatherDataEvent e) {
        super(e.getGenerator().getPackOutput(), "dolt_mod_how", e.getExistingFileHelper());
    }

    protected void registerStatesAndModels() {
        this.customPot(DMHBlocks.POTTED_ARID_SPROUTS, DMHBlocks.POTTED_MYCELIUM_SPROUTS, DMHBlocks.POTTED_BEACHGRASS, DMHBlocks.POTTED_TALL_BEACHGRASS, DMHBlocks.POTTED_STRAWBERRIES, DMHBlocks.POTTED_WHITE_STRAWBERRIES, DMHBlocks.POTTED_ONION, DMHBlocks.POTTED_TOMATOES, DMHBlocks.POTTED_CABBAGE);
        this.rakedSand(DMHBlocks.ASHEN_RAKED_SAND, (RegistryObject<? extends Block>)BBBlocks.ASHEN_SAND);
        this.rakedSand(DMHBlocks.ARID_RAKED_SAND, (RegistryObject<? extends Block>)AtmosphericBlocks.ARID_SAND);
        this.rakedSand(DMHBlocks.RED_ARID_RAKED_SAND, (RegistryObject<? extends Block>)AtmosphericBlocks.RED_ARID_SAND);
        this.leafPileBlock(ACBlockRegistry.ANCIENT_LEAVES, DMHBlocks.ANCIENT_LEAF_PILE);
        this.chiseledBookshelfBlock(DMHBlocks.CHISELED_PEWEN_BOOKSHELF);
        this.cabinetBlock((Block)DMHBlocks.PEWEN_CABINET.get());
        this.stupidWoodworksBlocks("pewen", (RegistryObject<Block>)ACBlockRegistry.PEWEN_PLANKS, DMHBlocks.PEWEN_BOARDS, DMHBlocks.PEWEN_LADDER, DMHBlocks.PEWEN_BOOKSHELF, DMHBlocks.PEWEN_BEEHIVE, DMHBlocks.PEWEN_CHEST, DMHBlocks.TRAPPED_PEWEN_CHEST);
    }

    @SafeVarargs
    private void customPot(RegistryObject<? extends Block> ... pots) {
        for (RegistryObject<? extends Block> pot : pots) {
            ResourceLocation potTexture = DoltModHow.rl("block/" + DMHBlockStatesGen.name((Block)((Block)pot.get())));
            this.simpleBlock((Block)pot.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(DMHBlockStatesGen.name((Block)((Block)pot.get())), new ResourceLocation("block/flower_pot_cross"), "plant", potTexture)).renderType("cutout"));
        }
    }

    public void cabinetBlock(Block block) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(DMHBlockStatesGen.name((Block)block) + suffix, this.after(block, "_side"), this.after(block, "_front" + suffix), this.after(block, "_top"));
        });
        this.blockItem(block);
    }

    private void rakedSand(RegistryObject<? extends Block> sand, RegistryObject<? extends Block> nonRaked) {
        String cubeTop = "block/cube_top";
        this.getVariantBuilder((Block)sand.get()).forAllStates(state -> {
            Function<String, ConfiguredModel.Builder> sandModelFunction = sandType -> {
                String name = DMHBlockStatesGen.name((Block)((Block)sand.get())) + (String)(sandType.isEmpty() ? "" : "_" + sandType.replace("_", ""));
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name, cubeTop)).texture("side", this.blockTexture((Block)nonRaked.get()))).texture("top", this.loc((Supplier<? extends Block>)sand).m_247266_(str -> "block/%s%s".formatted(DMHBlockStatesGen.name((Block)((Block)sand.get())), sandType.isEmpty() ? "" : "_" + sandType.replace("_", "")))));
            };
            Function<String, Integer> getFacingValue = str -> switch (str) {
                case "north_east" -> 270;
                case "north_west" -> 180;
                case "south_east" -> 0;
                case "south_west" -> 90;
                default -> throw new IllegalStateException("Unexpected value: " + str);
            };
            String shape = ((RakedSandBlock.RakedSandShape)state.m_61143_((Property)RakedSandBlock.SHAPE)).getName();
            String[] shapeName = shape.split("_");
            if (Objects.equals(shapeName[0], "north") && Objects.equals(shapeName[1], "south")) {
                return sandModelFunction.apply("").build();
            }
            if (Objects.equals(shapeName[0], "east") && Objects.equals(shapeName[1], "west")) {
                return sandModelFunction.apply("").rotationY(90).build();
            }
            int rotationAmount = getFacingValue.apply(shape);
            return sandModelFunction.apply(shape).rotationY(rotationAmount).build();
        });
        this.blockItem((Block)sand.get());
    }

    private ResourceLocation loc(Block block) {
        return block.m_204297_().m_205785_().m_135782_();
    }

    private ResourceLocation blockTexture(Block block, UnaryOperator<String> mapper) {
        return this.loc(block).m_247266_(str -> "block/" + (String)mapper.apply((String)str));
    }

    private ResourceLocation blockTexture(RegistryObject<? extends Block> block, UnaryOperator<String> mapper) {
        return this.blockTexture((Block)block.get(), mapper);
    }

    private ResourceLocation after(Block block, String string) {
        return this.blockTexture(block, str -> str + string);
    }

    private ResourceLocation loc(Supplier<? extends Block> block) {
        return this.loc(block.get());
    }

    public void stupidWoodworksBlocks(String type, RegistryObject<Block> planks, RegistryObject<Block> boards, RegistryObject<Block> ladder, RegistryObject<Block> bookshelf, RegistryObject<Block> beehive, RegistryObject<? extends Block> chest, RegistryObject<? extends Block> trappedChest) {
        this.boardsBlock(boards);
        this.ladderBlock(ladder);
        this.beehiveBlock(beehive);
        this.stupidBookshelf((Block)planks.get(), type, bookshelf);
        this.stupidChestBlocks("pewen", planks, chest, trappedChest);
    }

    public void stupidChestBlocks(String type, RegistryObject<Block> planks, RegistryObject<? extends Block> chest, RegistryObject<? extends Block> trappedChest) {
        this.stupidChestBlocks(type, (Block)planks.get(), chest, trappedChest);
    }

    public void stupidChestBlocks(String type, Block planks, RegistryObject<? extends Block> chest, RegistryObject<? extends Block> trappedChest) {
        ModelFile model = this.particle(chest, this.loc(planks).m_247266_(str -> "block/%s/%s".formatted(type, str)));
        this.simpleBlock((Block)chest.get(), model);
        this.simpleBlock((Block)trappedChest.get(), model);
        this.simpleBlockItem((Block)chest.get(), (ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "item/template_chest")));
        this.simpleBlockItem((Block)trappedChest.get(), (ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "item/template_chest")));
    }

    public void stupidBookshelf(Block planks, String type, RegistryObject<Block> bookshelf) {
        this.simpleBlock((Block)bookshelf.get(), (ModelFile)this.models().cubeColumn(DMHBlockStatesGen.name((Block)((Block)bookshelf.get())), this.blockTexture((Block)bookshelf.get()), this.loc(planks).m_247266_(str -> "block/%s/%s".formatted(type, str))));
        this.blockItem(bookshelf);
    }
}

