/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.integration;

import com.dolthhaven.dolt_mod_how.core.util.DMHUtils;
import java.util.EnumMap;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.core.set.BlocksColorInternal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;

public class DMHSupplementariesCompat {
    private static void block(EnumMap<DyeColor, Block> map, DyeColor color, String string) {
        map.put(color, DMHUtils.getPotentialBlock(new ResourceLocation(string)));
    }

    private static void item(EnumMap<DyeColor, Item> map, DyeColor color, String string) {
        map.put(color, DMHUtils.getPotentialItem(new ResourceLocation(string)));
    }

    public static void registerClayworksStuff() {
        if (!ModList.get().isLoaded("clayworks")) {
            return;
        }
        List<String> dyeDepot = List.of("rose", "maroon", "ginger", "tan", "beige", "coral", "olive", "forest", "verdant", "amber", "teal", "mint", "aqua", "slate", "navy", "indigo");
        EnumMap<DyeColor, Block> concretes = new EnumMap<DyeColor, Block>(DyeColor.class);
        EnumMap<DyeColor, Block> concretePowders = new EnumMap<DyeColor, Block>(DyeColor.class);
        EnumMap<DyeColor, Item> concretesItems = new EnumMap<DyeColor, Item>(DyeColor.class);
        EnumMap<DyeColor, Item> concretesPowderItems = new EnumMap<DyeColor, Item>(DyeColor.class);
        for (DyeColor val : BlocksColorInternal.VANILLA_COLORS) {
            DMHSupplementariesCompat.block(concretes, val, val + "_concrete");
            DMHSupplementariesCompat.block(concretePowders, val, val + "_concrete_powder");
            DMHSupplementariesCompat.item(concretesItems, val, val + "_concrete");
            DMHSupplementariesCompat.item(concretesPowderItems, val, val + "_concrete_powder");
        }
        if (ModList.get().isLoaded("dye_depot")) {
            for (DyeColor color : BlocksColorInternal.MODDED_COLORS) {
                if (!dyeDepot.contains(color.toString())) continue;
                DMHSupplementariesCompat.block(concretes, color, "dye_depot:" + color + "_concrete");
                DMHSupplementariesCompat.block(concretePowders, color, "dye_depot:" + color + "_concrete_powder");
                DMHSupplementariesCompat.item(concretesItems, color, "dye_depot:" + color + "_concrete");
                DMHSupplementariesCompat.item(concretesPowderItems, color, "dye_depot:" + color + "_concrete_powder");
            }
        }
        BlocksColorAPI.registerBlockColorSet((ResourceLocation)new ResourceLocation("minecraft", "concrete"), concretes, (Block)DMHUtils.getPotentialBlock(DMHUtils.Constants.CONCRETE));
        BlocksColorAPI.registerBlockColorSet((ResourceLocation)new ResourceLocation("minecraft", "concrete_powder"), concretePowders, (Block)DMHUtils.getPotentialBlock(DMHUtils.Constants.CONCRETE_POWDER));
        BlocksColorAPI.registerItemColorSet((ResourceLocation)new ResourceLocation("minecraft", "concrete"), concretesItems, (Item)DMHUtils.getPotentialItem(DMHUtils.Constants.CONCRETE));
        BlocksColorAPI.registerItemColorSet((ResourceLocation)new ResourceLocation("minecraft", "concrete_powder"), concretesPowderItems, (Item)DMHUtils.getPotentialItem(DMHUtils.Constants.CONCRETE_POWDER));
    }
}

