/*
 * Decompiled with CFR 0.152.
 */
package ivangeevo.sturdy_trees.datagen;

import ivangeevo.sturdy_trees.block.blocks.LogStrippedBlock;
import ivangeevo.sturdy_trees.item.SturdyTreesItems;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_212;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7923;
import net.minecraft.class_85;

public class SturdyTreesLootTableProvider
extends FabricBlockLootTableProvider {
    private static final String[] overworldToughWoodTypes = new String[]{"oak", "birch", "spruce", "jungle", "acacia", "dark_oak", "mangrove", "cherry"};

    public SturdyTreesLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    public void method_10379() {
        this.generateCustomLogsTables();
    }

    private void generateCustomLogsTables() {
        class_2248 block;
        for (class_2960 logBlock : SturdyTreesLootTableProvider.getStrippedLogsIDs()) {
            block = (class_2248)class_7923.field_41175.method_10223(logBlock);
            class_1792 planksItem = this.getPlanksForLog(logBlock);
            this.method_45988(block, this.dropsForStrippedLog(block, planksItem));
        }
        for (class_2960 logBlock : SturdyTreesLootTableProvider.getChewedLogsIDs()) {
            block = (class_2248)class_7923.field_41175.method_10223(logBlock);
            this.method_45988(block, this.dropsForChewedLog(block));
        }
        for (class_2960 logBlock : SturdyTreesLootTableProvider.getSpikeLogsIDs()) {
            block = (class_2248)class_7923.field_41175.method_10223(logBlock);
            this.method_45988(block, this.dropsForSpikeLog(block));
        }
    }

    public class_52.class_53 dropsForStrippedLog(class_2248 logBlock, class_1792 planksItem) {
        class_85.class_86<?> planksEntry = this.conditionalEntry((class_1935)planksItem, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 0));
        class_85.class_86<?> sawDustEntry1 = this.conditionalEntry((class_1935)SturdyTreesItems.DUST_SAW, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 1));
        class_85.class_86<?> stickEntry = this.conditionalEntry((class_1935)class_1802.field_8600, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 2));
        class_85.class_86<?> sawDustEntry2 = this.conditionalEntry((class_1935)SturdyTreesItems.DUST_SAW, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 3));
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351(planksEntry).method_351(sawDustEntry1).method_351(stickEntry).method_351(sawDustEntry2));
    }

    public class_52.class_53 dropsForChewedLog(class_2248 logBlock) {
        class_85.class_86<?> sawDustEntry1 = this.conditionalEntry((class_1935)SturdyTreesItems.DUST_SAW, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 0));
        class_85.class_86<?> stickEntry = this.conditionalEntry((class_1935)class_1802.field_8600, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 1));
        class_85.class_86<?> sawDustEntry2 = this.conditionalEntry((class_1935)SturdyTreesItems.DUST_SAW, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 2));
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351(sawDustEntry1).method_351(stickEntry).method_351(sawDustEntry2));
    }

    public class_52.class_53 dropsForSpikeLog(class_2248 logBlock) {
        class_85.class_86<?> sawDustEntry1 = this.conditionalEntry((class_1935)SturdyTreesItems.DUST_SAW, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 0));
        class_85.class_86<?> stickEntry = this.conditionalEntry((class_1935)class_1802.field_8600, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 1));
        class_85.class_86<?> sawDustEntry2 = this.conditionalEntry((class_1935)SturdyTreesItems.DUST_SAW, (class_5341.class_210)this.doIntStateCheck((class_1935)logBlock, (class_2769<Integer>)LogStrippedBlock.VARIATION, 2));
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351(sawDustEntry1).method_351(stickEntry).method_351(sawDustEntry2));
    }

    private class_1792 getPlanksForLog(class_2960 logBlockId) {
        String woodType;
        return switch (woodType = this.extractWoodType(logBlockId.method_12832())) {
            case "oak" -> class_1802.field_8118;
            case "birch" -> class_1802.field_8191;
            case "spruce" -> class_1802.field_8113;
            case "jungle" -> class_1802.field_8842;
            case "acacia" -> class_1802.field_8651;
            case "dark_oak" -> class_1802.field_8404;
            case "mangrove" -> class_1802.field_37507;
            case "cherry" -> class_1802.field_42687;
            default -> throw new IllegalArgumentException("Unknown wood type: " + woodType);
        };
    }

    private String extractWoodType(String logBlockPath) {
        int suffixIndex;
        if (logBlockPath.startsWith("log_")) {
            logBlockPath = logBlockPath.substring(4);
        }
        if ((suffixIndex = logBlockPath.lastIndexOf(95)) != -1) {
            logBlockPath = logBlockPath.substring(0, suffixIndex);
        }
        return logBlockPath;
    }

    private class_85.class_86<?> conditionalEntry(class_1935 drop, class_5341.class_210 condition) {
        return (class_85.class_86)this.simpleEntry(drop).method_421(condition);
    }

    private class_85.class_86<?> simpleEntry(class_1935 drop) {
        return class_77.method_411((class_1935)drop);
    }

    private class_212.class_213 doIntStateCheck(class_1935 block, class_2769<Integer> property, int value) {
        return class_212.method_900((class_2248)((class_2248)block)).method_22584(class_4559.class_4560.method_22523().method_22524(property, value));
    }

    private class_212.class_213 doBooleanStateCheck(class_2248 block, class_2769<Boolean> property, boolean value) {
        return class_212.method_900((class_2248)block).method_22584(class_4559.class_4560.method_22523().method_22527(property, value));
    }

    public static List<class_85.class_86> createItemEntryBuilders(List<class_2960> identifiers) {
        ArrayList<class_85.class_86> builders = new ArrayList<class_85.class_86>();
        for (class_2960 id : identifiers) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            builders.add(class_77.method_411((class_1935)item));
        }
        return builders;
    }

    private static List<class_2960> getStrippedLogsIDs() {
        ArrayList<class_2960> strippedLogs = new ArrayList<class_2960>();
        for (String woodType : overworldToughWoodTypes) {
            strippedLogs.add(class_2960.method_60655((String)"sturdy_trees", (String)("log_" + woodType + "_stripped")));
        }
        return strippedLogs;
    }

    private static List<class_2960> getSpikeLogsIDs() {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (String woodType : overworldToughWoodTypes) {
            list.add(class_2960.method_60655((String)"sturdy_trees", (String)("log_" + woodType + "_spike")));
        }
        return list;
    }

    private static List<class_2960> getChewedLogsIDs() {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (String woodType : overworldToughWoodTypes) {
            list.add(class_2960.method_60655((String)"sturdy_trees", (String)("log_" + woodType + "_chewed")));
        }
        return list;
    }
}

