/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.mixin;

import com.google.common.collect.ImmutableList;
import dev.hybridlabs.aquatic.access.CustomPlayerEntityData;
import dev.hybridlabs.aquatic.effect.HybridAquaticMobEffects;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import dev.hybridlabs.aquatic.item.HybridAquaticToolMaterials;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3486;
import net.minecraft.class_4051;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1297
implements CustomPlayerEntityData {
    @Unique
    private int haHurtTime = 0;
    @Unique
    private boolean isWearingDivingBoots;
    @Unique
    int coralRepairTick = 0;

    public PlayerEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean method_5681();

    @Override
    public void hybrid_aquatic$setHurtTime(int value) {
        this.haHurtTime = value;
    }

    @Override
    public int hybrid_aquatic$getHurtTime() {
        return this.haHurtTime;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        this.hybrid_aquatic$setHurtTime(nbt.method_10550("haHurtTime"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("haHurtTime", this.hybrid_aquatic$getHurtTime());
    }

    @Inject(method={"isAffectedByFluids"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideShouldSwimInFluids(CallbackInfoReturnable<Boolean> ci) {
        if (this.isWearingDivingBoots && !this.method_5681() && this.method_5869()) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;level()Lnet/minecraft/world/level/Level;", ordinal=0, shift=At.Shift.BEFORE)})
    private void setCustomHurtTimeOnDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 foundEntity;
        class_1657 object = (class_1657)this;
        if (object.method_5799() && (foundEntity = object.method_37908().method_21726(HybridAquaticSharkEntity.class, class_4051.method_36626().method_18418(32.0).method_18420(class_1297::method_5869), (class_1309)object, object.method_23317(), object.method_23320(), object.method_23321(), object.method_5829().method_1014(16.0))) != null) {
            this.hybrid_aquatic$setHurtTime(200);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickDownCustomHurtTime(CallbackInfo ci) {
        int cHurtTime = this.hybrid_aquatic$getHurtTime();
        if (cHurtTime > 0) {
            this.hybrid_aquatic$setHurtTime(cHurtTime - 1);
        }
        this.updateDivingHelmet();
        this.updateDivingBoots();
        this.updateTurtleChestplate();
        this.repairCoralTools();
    }

    @Unique
    private void updateDivingHelmet() {
        class_1657 player = (class_1657)this;
        class_1799 itemStack = player.method_6118(class_1304.field_6169);
        if (itemStack.method_31574(HybridAquaticItems.INSTANCE.getDIVING_HELMET().get())) {
            if (!player.method_5777(class_3486.field_15517)) {
                player.method_6092(new class_1293(class_1294.field_5923, 600, 0, false, false, false));
            } else {
                player.method_6092(new class_1293(HybridAquaticMobEffects.INSTANCE.getCLARITY().get(), 600, 0, false, false, false));
            }
        }
    }

    @Unique
    private void updateDivingBoots() {
        class_1657 player = (class_1657)this;
        class_1799 itemStack = player.method_6118(class_1304.field_6166);
        this.isWearingDivingBoots = itemStack.method_31574(HybridAquaticItems.INSTANCE.getDIVING_BOOTS().get());
    }

    @Unique
    private void updateTurtleChestplate() {
        class_1657 player = (class_1657)this;
        class_1799 itemStack = player.method_6118(class_1304.field_6174);
        if (itemStack.method_31574(HybridAquaticItems.INSTANCE.getTURTLE_CHESTPLATE().get())) {
            player.method_6092(new class_1293(class_1294.field_5907, 200, 0, false, false, true));
            player.method_6092(new class_1293(class_1294.field_5909, 200, 0, false, false, true));
        }
    }

    @Unique
    private void repairCoralTools() {
        class_1657 player = (class_1657)this;
        class_1661 inventory = player.method_31548();
        if (player.method_5777(class_3486.field_15517)) {
            if (this.coralRepairTick > 5) {
                ImmutableList combinedInventory = ImmutableList.of((Object)inventory.field_7547, (Object)inventory.field_7544);
                ArrayList<class_1799> coralItems = new ArrayList<class_1799>();
                for (List list : combinedInventory) {
                    for (class_1799 itemStack : list) {
                        class_1831 tool;
                        class_1792 class_17922 = itemStack.method_7909();
                        if (!(class_17922 instanceof class_1831) || (tool = (class_1831)class_17922).method_8022() != HybridAquaticToolMaterials.CORAL || !itemStack.method_7986()) continue;
                        coralItems.add(itemStack);
                    }
                }
                if (!coralItems.isEmpty()) {
                    class_1799 item = (class_1799)coralItems.get(player.method_6051().method_43048(coralItems.size()));
                    item.method_7974(item.method_7919() - 1);
                    inventory.method_5431();
                }
                this.coralRepairTick = 0;
            }
            ++this.coralRepairTick;
        }
    }
}

