/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.world.gen.feature;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.block.ThermalVentBlock;
import dev.hybridlabs.aquatic.block.TubeWormBlock;
import dev.hybridlabs.aquatic.entity.HybridAquaticEntityTypes;
import dev.hybridlabs.aquatic.entity.crustacean.YetiCrabEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticBiomeTags;
import dev.hybridlabs.aquatic.world.gen.feature.VentPatchFeatureConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6017;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00013B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ?\u0010\u0017\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J7\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ7\u0010%\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010(\u001a\u00020'2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010*\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b*\u0010+JG\u0010/\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b/\u00100J'\u00101\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b1\u00102\u00a8\u00064"}, d2={"Ldev/hybridlabs/aquatic/world/gen/feature/VentPatchFeature;", "Lnet/minecraft/class_3031;", "Ldev/hybridlabs/aquatic/world/gen/feature/VentPatchFeatureConfig;", "Lcom/mojang/serialization/Codec;", "codec", "<init>", "(Lcom/mojang/serialization/Codec;)V", "Lnet/minecraft/class_5821;", "context", "", "place", "(Lnet/minecraft/class_5821;)Z", "Lnet/minecraft/class_1936;", "world", "Lnet/minecraft/class_2338;", "rootPos", "Lnet/minecraft/class_5819;", "random", "", "heightMultiplier", "Lnet/minecraft/class_4651;", "baseProvider", "ventProvider", "generateSingleVent", "(Lnet/minecraft/class_1936;Lnet/minecraft/class_2338;Lnet/minecraft/class_5819;DLnet/minecraft/class_4651;Lnet/minecraft/class_4651;)Z", "Lnet/minecraft/class_5425;", "", "count", "radius", "", "spawnYetiCrabsAroundVent", "(Lnet/minecraft/class_5425;Lnet/minecraft/class_2338;Lnet/minecraft/class_5819;II)V", "pos", "cycle", "height", "Lnet/minecraft/class_2680;", "state", "generateHydrothermalVent", "(Lnet/minecraft/class_1936;Lnet/minecraft/class_2338;IILnet/minecraft/class_2680;)V", "Lnet/minecraft/class_5691;", "getHydrothermalVentThickness", "(II)Lnet/minecraft/class_5691;", "calculateVentHeight", "(D)I", "Lnet/minecraft/class_6017;", "wormCountProvider", "stateProvider", "generateTubeWormPatch", "(Lnet/minecraft/class_1936;Lnet/minecraft/class_2338;Lnet/minecraft/class_5819;ILnet/minecraft/class_6017;ILnet/minecraft/class_4651;)V", "isValidPosition", "(Lnet/minecraft/class_1936;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;)Z", "Companion", "hybrid-aquatic-fabric-1.20.1"})
public final class VentPatchFeature
extends class_3031<VentPatchFeatureConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_VENT_HEIGHT = 5;
    public static final int MIN_VENT_HEIGHT = 2;
    public static final int MIN_VENT_CLEARANCE = 2;

    public VentPatchFeature(@NotNull Codec<VentPatchFeatureConfig> codec) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        super(codec);
    }

    public boolean method_13151(@NotNull class_5821<VentPatchFeatureConfig> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        boolean generated = false;
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        VentPatchFeatureConfig ventPatchFeatureConfig = (VentPatchFeatureConfig)context.method_33656();
        class_4651 baseProvider = ventPatchFeatureConfig.component1();
        class_4651 ventProvider = ventPatchFeatureConfig.component2();
        class_4651 wormProvider = ventPatchFeatureConfig.component3();
        class_6017 countProvider = ventPatchFeatureConfig.component4();
        class_6017 radiusProvider = ventPatchFeatureConfig.component5();
        class_6017 wormCountProvider = ventPatchFeatureConfig.component6();
        class_6017 wormRadiusProvider = ventPatchFeatureConfig.component7();
        class_6017 wormCountPerBlockProvider = ventPatchFeatureConfig.component8();
        int count = countProvider.method_35008(random);
        for (int i = 0; i < count; ++i) {
            int it = i;
            boolean bl = false;
            int radius = radiusProvider.method_35008(random);
            int offsetX = random.method_43048(radius * 2 + 1) - radius;
            int offsetZ = random.method_43048(radius * 2 + 1) - radius;
            class_2338 candidatePos = origin.method_10069(offsetX, 0, offsetZ);
            double distanceFromCenter = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
            double heightMultiplier = 1.0 - RangesKt.coerceIn((double)(distanceFromCenter / (double)radius), (double)0.0, (double)1.0);
            Intrinsics.checkNotNull((Object)world);
            class_1936 class_19362 = (class_1936)world;
            Intrinsics.checkNotNull((Object)candidatePos);
            Intrinsics.checkNotNull((Object)random);
            if (!this.generateSingleVent(class_19362, candidatePos, random, heightMultiplier, baseProvider, ventProvider)) continue;
            int wormCount = wormCountProvider.method_35008(random);
            int wormRadius = wormRadiusProvider.method_35008(random);
            this.generateTubeWormPatch((class_1936)world, candidatePos, random, wormCount, wormCountPerBlockProvider, wormRadius, wormProvider);
            class_6880 biome = world.method_23753(candidatePos);
            if (biome.method_40220(HybridAquaticBiomeTags.INSTANCE.getARCTIC_OCEANS())) {
                this.spawnYetiCrabsAroundVent((class_5425)world, candidatePos, random, 1, 3);
            }
            generated = true;
        }
        return generated;
    }

    private final boolean generateSingleVent(class_1936 world, class_2338 rootPos, class_5819 random, double heightMultiplier, class_4651 baseProvider, class_4651 ventProvider) {
        if (!world.method_22351(rootPos)) {
            return false;
        }
        class_2338.class_2339 mutablePos = rootPos.method_25503();
        class_2680 state = ventProvider.method_23455(random, (class_2338)mutablePos);
        Intrinsics.checkNotNull((Object)mutablePos);
        class_2338 class_23382 = (class_2338)mutablePos;
        Intrinsics.checkNotNull((Object)state);
        if (!this.isValidPosition(world, class_23382, state)) {
            return false;
        }
        int baseThickness = 1 + random.method_43048(3);
        int minHeight = baseThickness + 5 + 2;
        mutablePos.method_30927(new class_2382(0, minHeight, 0));
        while (mutablePos.method_10264() > rootPos.method_10264()) {
            if (!world.method_22351((class_2338)mutablePos)) {
                return false;
            }
            mutablePos.method_10098(class_2350.field_11033);
        }
        int n = 0;
        while (n < baseThickness) {
            int it = n++;
            boolean bl = false;
            class_2680 state2 = baseProvider.method_23455(random, (class_2338)mutablePos);
            world.method_8652((class_2338)mutablePos, state2, 2);
            mutablePos.method_10098(class_2350.field_11036);
        }
        int ventHeight = this.calculateVentHeight(heightMultiplier);
        int n2 = 0;
        while (n2 < ventHeight) {
            int cycle = n2++;
            boolean bl = false;
            this.generateHydrothermalVent(world, (class_2338)mutablePos, cycle, ventHeight, state);
            mutablePos.method_10098(class_2350.field_11036);
        }
        return true;
    }

    private final void spawnYetiCrabsAroundVent(class_5425 world, class_2338 rootPos, class_5819 random, int count, int radius) {
        for (int i = 0; i < count; ++i) {
            YetiCrabEntity yetiCrabEntity;
            int offsetZ;
            int it = i;
            boolean bl = false;
            int offsetX = random.method_43048(radius * 2 + 1) - radius;
            class_2338 spawnPos = rootPos.method_10069(offsetX, 0, offsetZ = random.method_43048(radius * 2 + 1) - radius);
            if (!world.method_22351(spawnPos) || (YetiCrabEntity)HybridAquaticEntityTypes.INSTANCE.getYETI_CRAB().get().method_5883((class_1937)world.method_8410()) == null) continue;
            yetiCrabEntity.method_5725(spawnPos, random.method_43057() * 360.0f, 0.0f);
            yetiCrabEntity.method_5971();
            class_1266 class_12662 = world.method_8404(spawnPos);
            Intrinsics.checkNotNullExpressionValue((Object)class_12662, (String)"getCurrentDifficultyAt(...)");
            yetiCrabEntity.method_5943(world, class_12662, class_3730.field_16474, null, null);
            world.method_8649((class_1297)yetiCrabEntity);
        }
    }

    private final void generateHydrothermalVent(class_1936 world, class_2338 pos, int cycle, int height, class_2680 state) {
        class_5691 thickness = this.getHydrothermalVentThickness(cycle, height);
        world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(world.method_22351(pos)))).method_11657((class_2769)ThermalVentBlock.Companion.getTHICKNESS(), (Comparable)thickness), 2);
    }

    private final class_5691 getHydrothermalVentThickness(int cycle, int height) {
        if (cycle == 0) {
            return class_5691.field_28068;
        }
        if (cycle == height - 1) {
            return class_5691.field_28065;
        }
        return class_5691.field_28067;
    }

    private final int calculateVentHeight(double heightMultiplier) {
        return Math.max(2, (int)((double)2 + (double)3 * heightMultiplier));
    }

    private final void generateTubeWormPatch(class_1936 world, class_2338 pos, class_5819 random, int count, class_6017 wormCountProvider, int radius, class_4651 stateProvider) {
        for (int i = 0; i < count; ++i) {
            int it = i;
            boolean bl = false;
            class_2338 offset = new class_2338(random.method_43048(radius * 2) - radius, random.method_43048(radius * 2) - radius, random.method_43048(radius * 2) - radius);
            class_2338.class_2339 tubeWormPos = pos.method_10081((class_2382)offset).method_25503();
            int n = 3;
            for (int j = 0; j < n; ++j) {
                int it2 = j;
                boolean bl2 = false;
                class_2680 testState = world.method_8320((class_2338)tubeWormPos);
                if (!Intrinsics.areEqual((Object)testState.method_26204(), (Object)class_2246.field_10382)) {
                    tubeWormPos.method_10098(class_2350.field_11036);
                    continue;
                }
                if (testState.method_26206((class_1922)world, (class_2338)tubeWormPos, class_2350.field_11036)) continue;
                tubeWormPos.method_10098(class_2350.field_11033);
            }
            class_2680 state = stateProvider.method_23455(random, (class_2338)tubeWormPos);
            Intrinsics.checkNotNull((Object)tubeWormPos);
            class_2338 class_23382 = (class_2338)tubeWormPos;
            Intrinsics.checkNotNull((Object)state);
            if (!this.isValidPosition(world, class_23382, state)) continue;
            int wormCount = wormCountProvider.method_35008(random);
            world.method_8652((class_2338)tubeWormPos, (class_2680)state.method_11657((class_2769)TubeWormBlock.Companion.getWORMS(), (Comparable)Integer.valueOf(wormCount)), 2);
        }
    }

    private final boolean isValidPosition(class_1936 world, class_2338 pos, class_2680 state) {
        class_2680 existingState = world.method_8320(pos);
        if (!existingState.method_45474()) {
            return false;
        }
        return state.method_26184((class_4538)world, pos);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ldev/hybridlabs/aquatic/world/gen/feature/VentPatchFeature$Companion;", "", "<init>", "()V", "", "MAX_VENT_HEIGHT", "I", "MIN_VENT_HEIGHT", "MIN_VENT_CLEARANCE", "hybrid-aquatic-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

