/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block;

import dev.hybridlabs.aquatic.block.HybridAquaticBlocks;
import dev.hybridlabs.aquatic.block.SeaMessage;
import dev.hybridlabs.aquatic.block.entity.MessageInABottleBlockEntity;
import dev.hybridlabs.aquatic.item.SeaMessageBookItem;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u00012\u00020\u0002:\u000223B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J8\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0016J\u001c\u0010*\u001a\u00020\u00132\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u000e0,H\u0014J\u0010\u0010.\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u00100\u001a\u0002012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u00064"}, d2={"Ldev/hybridlabs/aquatic/block/MessageInABottleBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getCloneItemStack", "Lnet/minecraft/world/item/ItemStack;", "world", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "canSurvive", "", "Lnet/minecraft/world/level/LevelReader;", "setPlacedBy", "", "Lnet/minecraft/world/level/Level;", "placer", "Lnet/minecraft/world/entity/LivingEntity;", "stack", "getStateForPlacement", "ctx", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "isPathfindable", "type", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Variant", "Companion", "hybrid-aquatic-forge-1.20.1"})
public final class MessageInABottleBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape SHAPE;
    @NotNull
    private static final VoxelShape WATER_SHAPE;

    public MessageInABottleBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof MessageInABottleBlockEntity)) {
            ItemStack itemStack = super.m_7397_(world, pos, state);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getCloneItemStack(...)");
            return itemStack;
        }
        return Companion.createItemStack((MessageInABottleBlockEntity)blockEntity);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        FluidState fluidStateAbove = world.m_6425_(pos.m_7494_());
        if (!fluidStateAbove.m_192917_(Fluids.f_76191_)) {
            return false;
        }
        BlockState stateBelow = world.m_8055_(pos.m_7495_());
        if (Intrinsics.areEqual((Object)stateBelow.m_60734_(), (Object)((Object)this))) {
            return false;
        }
        FluidState fluidState = world.m_6425_(pos);
        return fluidState.m_192917_((Fluid)Fluids.f_76193_) || BaseEntityBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            CompoundTag compoundTag = stack.m_41737_("BlockEntityTag");
            if (compoundTag == null) break block4;
            CompoundTag nbt = compoundTag;
            boolean bl = false;
            if (!nbt.m_128441_("message")) {
                RegistryAccess registryManager = world.m_9598_();
                Registry registry = registryManager.m_175515_(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE());
                Optional optional = registry.m_213642_(world.f_46441_);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRandom(...)");
                Holder.Reference reference = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
                if (reference == null || (reference = reference.m_205785_()) == null) {
                    return;
                }
                Holder.Reference messageKey = reference;
                SeaMessage seaMessage = (SeaMessage)registry.m_6246_((ResourceKey)messageKey);
                if (seaMessage == null) {
                    return;
                }
                SeaMessage message = seaMessage;
                BlockEntity blockEntity = world.m_7702_(pos);
                MessageInABottleBlockEntity messageInABottleBlockEntity = blockEntity instanceof MessageInABottleBlockEntity ? (MessageInABottleBlockEntity)blockEntity : null;
                if (messageInABottleBlockEntity == null) {
                    return;
                }
                MessageInABottleBlockEntity blockEntity2 = messageInABottleBlockEntity;
                Intrinsics.checkNotNull((Object)registryManager);
                blockEntity2.setMessageItemStack(SeaMessageBookItem.Companion.createItemStack(message, registryManager));
            }
        }
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        boolean waterlogged = Intrinsics.areEqual((Object)ctx.m_43725_().m_6425_(ctx.m_8083_()), (Object)Fluids.f_76193_.m_76068_(false));
        Object object = this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlogged));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            BlockState blockState = Blocks.f_50016_.m_49966_();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            return blockState;
        }
        BlockState blockState = super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    @NotNull
    public FluidState m_5888_(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            FluidState fluidState2 = Fluids.f_76193_.m_76068_(false);
            fluidState = fluidState2;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState2, (String)"getSource(...)");
        } else {
            FluidState fluidState3 = super.m_5888_(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? WATER_SHAPE : SHAPE;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.f_61362_};
        builder.m_61104_(propertyArray);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new MessageInABottleBlockEntity(pos, state);
    }

    static {
        VoxelShape voxelShape = BaseEntityBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)13.0, (double)6.0, (double)14.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
        VoxelShape voxelShape2 = BaseEntityBlock.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        WATER_SHAPE = voxelShape2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Ldev/hybridlabs/aquatic/block/MessageInABottleBlock$Companion;", "", "<init>", "()V", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "WATER_SHAPE", "getWATER_SHAPE", "createItemStack", "Lnet/minecraft/world/item/ItemStack;", "blockEntity", "Ldev/hybridlabs/aquatic/block/entity/MessageInABottleBlockEntity;", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VoxelShape getSHAPE() {
            return SHAPE;
        }

        @NotNull
        public final VoxelShape getWATER_SHAPE() {
            return WATER_SHAPE;
        }

        @NotNull
        public final ItemStack createItemStack(@NotNull MessageInABottleBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            ItemStack stack = new ItemStack((ItemLike)HybridAquaticBlocks.INSTANCE.getMESSAGE_IN_A_BOTTLE().get());
            stack.m_41784_().m_128365_("BlockEntityTag", (Tag)blockEntity.m_187482_());
            return stack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \r2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\rB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u000e"}, d2={"Ldev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getId", "()Ljava/lang/String;", "BOTTLE", "JAR", "LONGNECK", "getSerializedName", "Companion", "hybrid-aquatic-forge-1.20.1"})
    @SourceDebugExtension(value={"SMAP\nMessageInABottleBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageInABottleBlock.kt\ndev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1208#2,2:175\n1236#2,4:177\n*S KotlinDebug\n*F\n+ 1 MessageInABottleBlock.kt\ndev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant\n*L\n155#1:175,2\n155#1:177,4\n*E\n"})
    public static final class Variant
    extends Enum<Variant>
    implements StringRepresentable {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String id;
        @NotNull
        private static final Map<String, Variant> BY_ID;
        public static final /* enum */ Variant BOTTLE;
        public static final /* enum */ Variant JAR;
        public static final /* enum */ Variant LONGNECK;
        private static final /* synthetic */ Variant[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Variant(String id) {
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public String m_7912_() {
            return this.id;
        }

        public static Variant[] values() {
            return (Variant[])$VALUES.clone();
        }

        public static Variant valueOf(String value) {
            return Enum.valueOf(Variant.class, value);
        }

        @NotNull
        public static EnumEntries<Variant> getEntries() {
            return $ENTRIES;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            BOTTLE = new Variant("bottle");
            JAR = new Variant("jar");
            LONGNECK = new Variant("longneck");
            $VALUES = variantArray = new Variant[]{Variant.BOTTLE, Variant.JAR, Variant.LONGNECK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Iterable $this$associateBy$iv = (Iterable)Variant.getEntries();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void p0;
                Variant variant = (Variant)((Object)element$iv$iv);
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.id, element$iv$iv);
            }
            BY_ID = destination$iv$iv;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant$Companion;", "", "<init>", "()V", "BY_ID", "", "", "Ldev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant;", "byId", "id", "hybrid-aquatic-forge-1.20.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Variant byId(@NotNull String id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Variant variant = (Variant)((Object)BY_ID.get(id));
                if (variant == null) {
                    variant = BOTTLE;
                }
                return variant;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

