/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.datagen;

import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.config.ConfigHelper;
import dev.hybridlabs.aquatic.config.EntitySpawnConfig;
import dev.hybridlabs.aquatic.config.HybridAquaticConfigHandler;
import dev.hybridlabs.aquatic.datagen.HAGlobalLootModifierProvider;
import dev.hybridlabs.aquatic.utils.NaughtyRegistrySetBuilder;
import dev.hybridlabs.aquatic.world.gen.feature.BiomeFeatureAddition;
import dev.hybridlabs.aquatic.world.gen.structure.BuiltinSpawnModifiersKt;
import dev.hybridlabs.aquatic.world.gen.structure.SpawnModifier;
import dev.hybridlabs.aquatic.world.gen.structure.StructureSpawnModifier;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="hybrid_aquatic", bus=Mod.EventBusSubscriber.Bus.MOD)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\f\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J\u0016\u0010\u000e\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002\u00a8\u0006\u000f"}, d2={"Ldev/hybridlabs/aquatic/datagen/DataGenerators;", "", "<init>", "()V", "gatherData", "", "event", "Lnet/minecraftforge/data/event/GatherDataEvent;", "registerStructureSpawnModifiers", "context", "Lnet/minecraft/data/worldgen/BootstapContext;", "Lnet/minecraftforge/common/world/StructureModifier;", "registerFeatures", "Lnet/minecraftforge/common/world/BiomeModifier;", "registerBiomeSpawns", "hybrid-aquatic-forge-1.20.1"})
public final class DataGenerators {
    @NotNull
    public static final DataGenerators INSTANCE = new DataGenerators();

    private DataGenerators() {
    }

    @SubscribeEvent
    public final void gatherData(@NotNull GatherDataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        NaughtyRegistrySetBuilder builder = new NaughtyRegistrySetBuilder();
        CompletableFuture lookupProvider = event.getLookupProvider();
        builder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, DataGenerators::gatherData$lambda$0);
        builder.m_254916_(ForgeRegistries.Keys.STRUCTURE_MODIFIERS, DataGenerators::gatherData$lambda$1);
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, (RegistrySetBuilder)builder, SetsKt.setOf((Object)"hybrid-aquatic")));
        boolean bl = event.includeServer();
        Intrinsics.checkNotNull((Object)packOutput);
        generator.addProvider(bl, (DataProvider)new HAGlobalLootModifierProvider(packOutput));
    }

    private final void registerStructureSpawnModifiers(BootstapContext<StructureModifier> context) {
        for (SpawnModifier structureModifier : BuiltinSpawnModifiersKt.getBuiltinSpawnModifiers()) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIERS, (ResourceLocation)CommonClass.locate(structureModifier.getId()));
            context.m_255272_(key, (Object)new StructureSpawnModifier(structureModifier));
        }
    }

    private final void registerFeatures(BootstapContext<BiomeModifier> context) {
        HolderGetter biomeRegistry = context.m_255420_(Registries.f_256952_);
        HolderGetter featureRegistry = context.m_255420_(Registries.f_256988_);
        for (BiomeFeatureAddition addition : BiomeFeatureAddition.Companion.getBuiltIn()) {
            String location = addition.getPlacedFeature().m_135782_().m_135815_() + "_" + addition.getBiomeTag().f_203868_().m_135815_();
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)CommonClass.locate(location));
            Holder[] holderArray = new Holder[]{featureRegistry.m_255043_(addition.getPlacedFeature())};
            context.m_255272_(key, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeRegistry.m_254956_(addition.getBiomeTag()), (HolderSet)HolderSet.m_205809_((Holder[])holderArray), addition.getStep()));
        }
    }

    private final void registerBiomeSpawns(BootstapContext<BiomeModifier> context) {
        Path path = CommonClass.CONFIG_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"CONFIG_FILE");
        HybridAquaticConfigHandler configHandler = ConfigHelper.INSTANCE.initializeConfig(path);
        HolderGetter biomeRegistry = context.m_255420_(Registries.f_256952_);
        for (EntitySpawnConfig spawnConfig : configHandler.getDefaultConfig().getEntitySpawnConfig()) {
            String location = spawnConfig.getType().m_147048_() + "_" + spawnConfig.getBiomes().f_203868_().m_135815_();
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)CommonClass.locate(location));
            context.m_255272_(key, (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomeRegistry.m_254901_(spawnConfig.getBiomes()).get(), CollectionsKt.listOf((Object)new MobSpawnSettings.SpawnerData(spawnConfig.getType(), spawnConfig.getWeight(), spawnConfig.getMinGroupSize(), spawnConfig.getMaxGroupSize()))));
        }
    }

    private static final void gatherData$lambda$0(BootstapContext context) {
        Intrinsics.checkNotNull((Object)context);
        INSTANCE.registerBiomeSpawns((BootstapContext<BiomeModifier>)context);
        INSTANCE.registerFeatures((BootstapContext<BiomeModifier>)context);
    }

    private static final void gatherData$lambda$1(BootstapContext context) {
        Intrinsics.checkNotNull((Object)context);
        INSTANCE.registerStructureSpawnModifiers((BootstapContext<StructureModifier>)context);
    }
}

