/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal;

import dev.hybridlabs.aquatic.effect.HybridAquaticMobEffects;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0014J\b\u0010$\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\"H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/SharkAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "shark", "Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;", "speedMultiplier", "", "followingTargetEvenIfNotSeen", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;DZ)V", "getShark", "()Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;", "path", "Lnet/minecraft/world/level/pathfinder/Path;", "pathedTargetX", "pathedTargetY", "pathedTargetZ", "ticksUntilNextPathRecalculation", "", "ticksUntilNextAttack", "lastCanUseCheck", "", "speedModifier", "getSpeedModifier", "()D", "canUse", "canContinueToUse", "start", "", "stop", "requiresUpdateEveryTick", "tick", "checkAndPerformAttack", "enemy", "Lnet/minecraft/world/entity/LivingEntity;", "distToEnemySqr", "resetAttackCooldown", "getAttackReachSqr", "attackTarget", "hybrid-aquatic-forge-1.20.1"})
public class SharkAttackGoal
extends Goal {
    @NotNull
    private final HybridAquaticSharkEntity shark;
    private final double speedMultiplier;
    private final boolean followingTargetEvenIfNotSeen;
    @Nullable
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;

    public SharkAttackGoal(@NotNull HybridAquaticSharkEntity shark, double speedMultiplier, boolean followingTargetEvenIfNotSeen) {
        Intrinsics.checkNotNullParameter((Object)((Object)shark), (String)"shark");
        this.shark = shark;
        this.speedMultiplier = speedMultiplier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.m_7021_(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
    }

    public /* synthetic */ SharkAttackGoal(HybridAquaticSharkEntity hybridAquaticSharkEntity, double d, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(hybridAquaticSharkEntity, d, bl);
    }

    @NotNull
    protected final HybridAquaticSharkEntity getShark() {
        return this.shark;
    }

    private final double getSpeedModifier() {
        return this.shark.m_21133_(Attributes.f_22279_) * this.speedMultiplier;
    }

    public boolean m_8036_() {
        if (this.shark.getFromFishingNet()) {
            return false;
        }
        long i = this.shark.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingEntity = this.shark.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        this.path = this.shark.m_21573_().m_6570_((Entity)livingEntity, 3);
        return this.path != null ? true : this.getAttackReachSqr(livingEntity) >= this.shark.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.shark.m_5448_();
        return livingEntity == null ? false : (!livingEntity.m_6084_() ? false : (!this.followingTargetEvenIfNotSeen ? !this.shark.m_21573_().m_26571_() : (!this.shark.m_21444_(livingEntity.m_20183_()) ? false : !(livingEntity instanceof Player) || !((Player)livingEntity).m_5833_() && !((Player)livingEntity).m_7500_())));
    }

    public void m_8056_() {
        this.shark.m_21573_().m_26536_(this.path, this.getSpeedModifier());
        this.shark.m_21561_(true);
        this.shark.m_6858_(true);
        this.shark.f_20911_ = false;
        this.shark.f_20913_ = 0;
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.shark.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.shark.m_6710_(null);
        }
        this.shark.m_6858_(false);
        this.shark.m_21561_(false);
        this.shark.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.shark.m_5448_();
        if (livingEntity != null) {
            this.shark.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            double d0 = this.shark.m_262793_(livingEntity);
            this.ticksUntilNextPathRecalculation = (int)Math.max((double)(this.ticksUntilNextPathRecalculation - 1), 0.0);
            if ((this.followingTargetEvenIfNotSeen || this.shark.m_21574_().m_148306_((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.shark.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingEntity.m_20185_();
                this.pathedTargetY = livingEntity.m_20186_();
                this.pathedTargetZ = livingEntity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.shark.m_217043_().m_188503_(7);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.shark.m_21573_().m_5624_((Entity)livingEntity, this.getSpeedModifier())) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = (int)Math.max((double)(this.ticksUntilNextAttack - 1), 0.0);
            this.checkAndPerformAttack(livingEntity, d0);
        }
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity enemy, double distToEnemySqr) {
        Intrinsics.checkNotNullParameter((Object)enemy, (String)"enemy");
        double d0 = this.getAttackReachSqr(enemy);
        if (distToEnemySqr <= d0 && this.ticksUntilNextAttack <= 0) {
            boolean hasShield;
            this.resetAttackCooldown();
            this.shark.m_6674_(InteractionHand.MAIN_HAND);
            this.shark.m_7327_((Entity)enemy);
            if (!enemy.m_21254_()) {
                enemy.m_147207_(new MobEffectInstance(HybridAquaticMobEffects.INSTANCE.getBLEEDING().get(), 200, 0), (Entity)this.shark);
            }
            if (enemy.m_21223_() <= 0.0f) {
                this.shark.setHunger(2400);
            }
            this.shark.m_21153_(this.shark.m_21233_());
            boolean bl = hasShield = enemy.m_21205_().m_150930_(Items.f_42740_) || enemy.m_21206_().m_150930_(Items.f_42740_);
            if (hasShield && enemy.m_21254_()) {
                this.shark.m_19998_((ItemLike)HybridAquaticItems.INSTANCE.getSHARK_TOOTH().get());
            }
        }
    }

    private final void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected double getAttackReachSqr(@NotNull LivingEntity attackTarget) {
        Intrinsics.checkNotNullParameter((Object)attackTarget, (String)"attackTarget");
        return this.shark.m_20205_() * 1.75f * this.shark.m_20205_() * 1.75f + attackTarget.m_20205_();
    }
}

