/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.critter;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.entity.critter.HybridAquaticCritterEntity;
import dev.hybridlabs.aquatic.entity.feature.OverlayTextureFeature;
import dev.hybridlabs.aquatic.tag.HybridAquaticBiomeTags;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 ;2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0001;B\u001f\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J6\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H\u0014J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\u001eH\u0016J\u0010\u00107\u001a\u0002042\u0006\u00106\u001a\u00020\u001eH\u0016J\b\u00108\u001a\u00020\u0003H\u0016J\u0010\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020\u0003H\u0016R$\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010)\u001a\u00020 2\u0006\u0010\"\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010.\u001a\u00020 2\u0006\u0010\"\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-\u00a8\u0006<"}, d2={"Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity;", "Ldev/hybridlabs/aquatic/entity/critter/HybridAquaticCritterEntity;", "Lnet/minecraft/world/entity/VariantHolder;", "Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$Type;", "Ldev/hybridlabs/aquatic/entity/feature/OverlayTextureFeature;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "getDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "hurt", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "entityNbt", "Lnet/minecraft/nbt/CompoundTag;", "getMaxSize", "", "getMinSize", "value", "Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$OverlayTextures;", "overlayTexture", "getOverlayTexture", "()Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$OverlayTextures;", "setOverlayTexture", "(Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$OverlayTextures;)V", "overlayColor", "getOverlayColor", "()I", "setOverlayColor", "(I)V", "starfishColor", "getStarfishColor", "setStarfishColor", "getOverlayTextureName", "", "defineSynchedData", "", "addAdditionalSaveData", "nbt", "readAdditionalSaveData", "getVariant", "setVariant", "type", "Companion", "hybrid-aquatic-forge-1.20.1"})
public final class StarfishEntity
extends HybridAquaticCritterEntity
implements VariantHolder<Companion.Type>,
OverlayTextureFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDataAccessor<Integer> TYPE;
    @NotNull
    private static final EntityDataAccessor<Integer> OverlayTexture;
    @NotNull
    private static final EntityDataAccessor<Integer> OverlayColor;
    @NotNull
    private static final EntityDataAccessor<Integer> StarfishColor;

    public StarfishEntity(@NotNull EntityType<? extends StarfishEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        float scale = WhenMappings.$EnumSwitchMapping$0[this.getVariant().ordinal()] == 1 ? 2.0f : 1.0f;
        EntityDimensions entityDimensions = super.m_6972_(pose).m_20388_(scale);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"scale(...)");
        return entityDimensions;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Entity attacker = source.m_7640_();
        if (this.getVariant() == Companion.Type.CROWN_OF_THORNS && attacker instanceof LivingEntity) {
            ((LivingEntity)attacker).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 1));
        }
        return super.m_6469_(source, amount);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        Holder biome = world.m_204166_(this.m_20183_());
        Intrinsics.checkNotNull((Object)biome);
        Companion.Type selectedType = Companion.Type.Companion.fromBiome((Holder<Biome>)biome, Random.Default);
        this.setVariant(selectedType);
        this.setOverlayColor(this.getOverlayColor());
        this.setStarfishColor(this.getStarfishColor());
        this.setOverlayTexture(switch (WhenMappings.$EnumSwitchMapping$0[selectedType.ordinal()]) {
            case 1, 2 -> Companion.OverlayTextures.NONE;
            case 3 -> {
                Object[] var8_8 = new Integer[]{0, 1, 2, 3};
                yield Companion.OverlayTextures.Companion.byId(((Number)CollectionsKt.random((Collection)CollectionsKt.listOf((Object[])var8_8), (Random)((Random)Random.Default))).intValue());
            }
            case 4 -> {
                Object[] var8_9 = new Integer[]{0, 4, 5, 6};
                yield Companion.OverlayTextures.Companion.byId(((Number)CollectionsKt.random((Collection)CollectionsKt.listOf((Object[])var8_9), (Random)((Random)Random.Default))).intValue());
            }
            default -> throw new NoWhenBranchMatchedException();
        });
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected int getMaxSize() {
        return 5;
    }

    @Override
    protected int getMinSize() {
        return -5;
    }

    private final Companion.OverlayTextures getOverlayTexture() {
        Object object = this.f_19804_.m_135370_(OverlayTexture);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return Companion.OverlayTextures.Companion.byId(((Number)object).intValue());
    }

    private final void setOverlayTexture(Companion.OverlayTextures value) {
        this.f_19804_.m_135381_(OverlayTexture, (Object)value.getId());
    }

    public final int getOverlayColor() {
        Integer color;
        Integer n = color = (Integer)this.f_19804_.m_135370_(OverlayColor);
        int n2 = -1;
        if (n != null && n == n2) {
            int r = this.f_19796_.m_188503_(256);
            int g = this.f_19796_.m_188503_(256);
            int b = this.f_19796_.m_188503_(256);
            color = 0xFF000000 | r << 16 | g << 8 | b;
            this.f_19804_.m_135381_(OverlayColor, (Object)color);
        }
        Integer n3 = color;
        Intrinsics.checkNotNull((Object)n3);
        return ((Number)n3).intValue();
    }

    public final void setOverlayColor(int value) {
        this.f_19804_.m_135381_(OverlayColor, (Object)value);
    }

    public final int getStarfishColor() {
        Integer color;
        Integer n = color = (Integer)this.f_19804_.m_135370_(StarfishColor);
        int n2 = -1;
        if (n != null && n == n2) {
            int r = this.f_19796_.m_188503_(256);
            int g = this.f_19796_.m_188503_(256);
            int b = this.f_19796_.m_188503_(256);
            color = 0xFF000000 | r << 16 | g << 8 | b;
            this.f_19804_.m_135381_(StarfishColor, (Object)color);
        }
        Integer n3 = color;
        Intrinsics.checkNotNull((Object)n3);
        return ((Number)n3).intValue();
    }

    public final void setStarfishColor(int value) {
        this.f_19804_.m_135381_(StarfishColor, (Object)value);
    }

    @Override
    @NotNull
    public String getOverlayTextureName() {
        Object object = this.f_19804_.m_135370_(OverlayTexture);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return Companion.OverlayTextures.Companion.byId(((Number)object).intValue()).m_7912_();
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(TYPE, (Object)0);
        this.f_19804_.m_135372_(OverlayTexture, (Object)0);
        this.f_19804_.m_135372_(StarfishColor, (Object)-1);
        this.f_19804_.m_135372_(OverlayColor, (Object)-1);
        super.m_8097_();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.m_128359_("Type", this.getVariant().m_7912_());
        nbt.m_128405_("Overlay", this.getOverlayTexture().getId());
        nbt.m_128405_("Starfish_Color", this.getStarfishColor());
        nbt.m_128405_("Overlay_Color", this.getOverlayColor());
        super.m_7380_(nbt);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.setVariant(Companion.Type.Companion.byName(nbt.m_128461_("Type")));
        if (nbt.m_128441_("Overlay")) {
            this.setOverlayTexture(Companion.OverlayTextures.Companion.byId(nbt.m_128451_("Overlay")));
        }
        if (nbt.m_128441_("Overlay_Color")) {
            this.setOverlayColor(nbt.m_128451_("Overlay_Color"));
        }
        if (nbt.m_128441_("Starfish_Color")) {
            this.setStarfishColor(nbt.m_128451_("Starfish_Color"));
        }
        super.m_7378_(nbt);
    }

    @NotNull
    public Companion.Type getVariant() {
        Object object = this.f_19804_.m_135370_(TYPE);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        return Companion.Type.Companion.fromId((Integer)object);
    }

    public void setVariant(@NotNull Companion.Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.f_19804_.m_135381_(TYPE, (Object)type.getId());
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(StarfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        TYPE = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.m_135353_(StarfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        OverlayTexture = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.m_135353_(StarfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        OverlayColor = entityDataAccessor3;
        EntityDataAccessor entityDataAccessor4 = SynchedEntityData.m_135353_(StarfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor4, (String)"defineId(...)");
        StarfishColor = entityDataAccessor4;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0013"}, d2={"Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "TYPE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getTYPE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "OverlayTexture", "getOverlayTexture", "OverlayColor", "getOverlayColor", "StarfishColor", "getStarfishColor", "OverlayTextures", "Type", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.m_21183_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22277_, 2.0).m_22268_(Attributes.f_22278_, 1.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getTYPE() {
            return TYPE;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getOverlayTexture() {
            return OverlayTexture;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getOverlayColor() {
            return OverlayColor;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getStarfishColor() {
            return StarfishColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0081\u0002\u0018\u0000 \u00152\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0015B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0016"}, d2={"Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$OverlayTextures;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "key", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getId", "()I", "getKey", "()Ljava/lang/String;", "NONE", "STRIPES_SMALL", "CIRCLE_SMALL", "STRIPES_CIRCLE_SMALL", "STRIPES", "CIRCLE", "STRIPES_CIRCLE", "getSerializedName", "Companion", "hybrid-aquatic-forge-1.20.1"})
        @SourceDebugExtension(value={"SMAP\nStarfishEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StarfishEntity.kt\ndev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$OverlayTextures\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,263:1\n37#2:264\n36#2,3:265\n37#2:268\n36#2,3:269\n*S KotlinDebug\n*F\n+ 1 StarfishEntity.kt\ndev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$OverlayTextures\n*L\n77#1:264\n77#1:265,3\n80#1:268\n80#1:269,3\n*E\n"})
        public static final class OverlayTextures
        extends Enum<OverlayTextures>
        implements StringRepresentable {
            @NotNull
            public static final Companion Companion;
            private final int id;
            @NotNull
            private final String key;
            @NotNull
            private static final Codec<OverlayTextures> CODEC;
            @NotNull
            private static final IntFunction<OverlayTextures> BY_ID;
            public static final /* enum */ OverlayTextures NONE;
            public static final /* enum */ OverlayTextures STRIPES_SMALL;
            public static final /* enum */ OverlayTextures CIRCLE_SMALL;
            public static final /* enum */ OverlayTextures STRIPES_CIRCLE_SMALL;
            public static final /* enum */ OverlayTextures STRIPES;
            public static final /* enum */ OverlayTextures CIRCLE;
            public static final /* enum */ OverlayTextures STRIPES_CIRCLE;
            private static final /* synthetic */ OverlayTextures[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private OverlayTextures(int id, String key) {
                this.id = id;
                this.key = key;
            }

            public final int getId() {
                return this.id;
            }

            @NotNull
            public final String getKey() {
                return this.key;
            }

            @NotNull
            public String m_7912_() {
                return this.key;
            }

            public static OverlayTextures[] values() {
                return (OverlayTextures[])$VALUES.clone();
            }

            public static OverlayTextures valueOf(String value) {
                return Enum.valueOf(OverlayTextures.class, value);
            }

            @NotNull
            public static EnumEntries<OverlayTextures> getEntries() {
                return $ENTRIES;
            }

            private static final OverlayTextures[] CODEC$lambda$0() {
                Collection $this$toTypedArray$iv = (Collection)OverlayTextures.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new OverlayTextures[0]);
            }

            private static final int BY_ID$lambda$1(OverlayTextures overlayTex) {
                Intrinsics.checkNotNullParameter((Object)((Object)overlayTex), (String)"overlayTex");
                return overlayTex.id;
            }

            static {
                NONE = new OverlayTextures(0, "");
                STRIPES_SMALL = new OverlayTextures(1, "stripes_small");
                CIRCLE_SMALL = new OverlayTextures(2, "circle_small");
                STRIPES_CIRCLE_SMALL = new OverlayTextures(3, "stripes_circle_small");
                STRIPES = new OverlayTextures(4, "stripes");
                CIRCLE = new OverlayTextures(5, "circle");
                STRIPES_CIRCLE = new OverlayTextures(6, "stripes_circle");
                $VALUES = overlayTexturesArray = new OverlayTextures[]{OverlayTextures.NONE, OverlayTextures.STRIPES_SMALL, OverlayTextures.CIRCLE_SMALL, OverlayTextures.STRIPES_CIRCLE_SMALL, OverlayTextures.STRIPES, OverlayTextures.CIRCLE, OverlayTextures.STRIPES_CIRCLE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                StringRepresentable.EnumCodec enumCodec = StringRepresentable.m_216439_(OverlayTextures::CODEC$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
                CODEC = (Codec)enumCodec;
                Collection $this$toTypedArray$iv = (Collection)OverlayTextures.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IntFunction intFunction = ByIdMap.m_262839_(OverlayTextures::BY_ID$lambda$1, (Object[])thisCollection$iv.toArray(new OverlayTextures[0]), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
                Intrinsics.checkNotNullExpressionValue((Object)intFunction, (String)"continuous(...)");
                BY_ID = intFunction;
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$OverlayTextures$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$OverlayTextures;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "BY_ID", "Ljava/util/function/IntFunction;", "getBY_ID", "()Ljava/util/function/IntFunction;", "byId", "id", "", "hybrid-aquatic-forge-1.20.1"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Codec<OverlayTextures> getCODEC() {
                    return CODEC;
                }

                @NotNull
                public final IntFunction<OverlayTextures> getBY_ID() {
                    return BY_ID;
                }

                @NotNull
                public final OverlayTextures byId(int id) {
                    OverlayTextures overlayTextures = this.getBY_ID().apply(id);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)overlayTextures), (String)"apply(...)");
                    return overlayTextures;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \u00102\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0011"}, d2={"Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$Type;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "key", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getId", "()I", "BRITTLESTAR", "CROWN_OF_THORNS", "SMALL", "MEDIUM", "getSerializedName", "Companion", "hybrid-aquatic-forge-1.20.1"})
        @SourceDebugExtension(value={"SMAP\nStarfishEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StarfishEntity.kt\ndev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$Type\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,263:1\n37#2:264\n36#2,3:265\n37#2:268\n36#2,3:269\n*S KotlinDebug\n*F\n+ 1 StarfishEntity.kt\ndev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$Type\n*L\n101#1:264\n101#1:265,3\n104#1:268\n104#1:269,3\n*E\n"})
        public static final class Type
        extends Enum<Type>
        implements StringRepresentable {
            @NotNull
            public static final Companion Companion;
            private final int id;
            @NotNull
            private final String key;
            @NotNull
            private static final StringRepresentable.EnumCodec<Type> CODEC;
            @NotNull
            private static final IntFunction<Type> BY_ID;
            @NotNull
            private static final List<Type> REEF_VARIANTS;
            public static final /* enum */ Type BRITTLESTAR;
            public static final /* enum */ Type CROWN_OF_THORNS;
            public static final /* enum */ Type SMALL;
            public static final /* enum */ Type MEDIUM;
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Type(int id, String key) {
                this.id = id;
                this.key = key;
            }

            public final int getId() {
                return this.id;
            }

            @NotNull
            public String m_7912_() {
                return this.key;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            private static final Type[] CODEC$lambda$0() {
                Collection $this$toTypedArray$iv = (Collection)Type.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new Type[0]);
            }

            private static final int BY_ID$lambda$1(Type obj) {
                Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
                return obj.id;
            }

            static {
                BRITTLESTAR = new Type(0, "brittlestar");
                CROWN_OF_THORNS = new Type(1, "crown_of_thorns");
                SMALL = new Type(2, "small");
                MEDIUM = new Type(3, "medium");
                $VALUES = typeArray = new Type[]{Type.BRITTLESTAR, Type.CROWN_OF_THORNS, Type.SMALL, Type.MEDIUM};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                StringRepresentable.EnumCodec enumCodec = StringRepresentable.m_216439_(Type::CODEC$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
                CODEC = enumCodec;
                Collection $this$toTypedArray$iv = (Collection)Type.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IntFunction intFunction = ByIdMap.m_262839_(Type::BY_ID$lambda$1, (Object[])thisCollection$iv.toArray(new Type[0]), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
                Intrinsics.checkNotNullExpressionValue((Object)intFunction, (String)"continuous(...)");
                BY_ID = intFunction;
                Type[] typeArray = new Type[]{CROWN_OF_THORNS, SMALL, MEDIUM};
                REEF_VARIANTS = CollectionsKt.listOf((Object[])typeArray);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$Type$Companion;", "", "<init>", "()V", "CODEC", "Lnet/minecraft/util/StringRepresentable$EnumCodec;", "Ldev/hybridlabs/aquatic/entity/critter/StarfishEntity$Companion$Type;", "getCODEC", "()Lnet/minecraft/util/StringRepresentable$EnumCodec;", "BY_ID", "Ljava/util/function/IntFunction;", "byName", "name", "", "fromId", "id", "", "REEF_VARIANTS", "", "fromBiome", "biome", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "random", "Lkotlin/random/Random$Default;", "hybrid-aquatic-forge-1.20.1"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final StringRepresentable.EnumCodec<Type> getCODEC() {
                    return CODEC;
                }

                @NotNull
                public final Type byName(@Nullable String name) {
                    Enum enum_ = this.getCODEC().m_262792_(name, (Enum)SMALL);
                    Intrinsics.checkNotNull((Object)enum_, (String)"null cannot be cast to non-null type dev.hybridlabs.aquatic.entity.critter.StarfishEntity.Companion.Type");
                    return (Type)enum_;
                }

                @NotNull
                public final Type fromId(int id) {
                    Object r = BY_ID.apply(id);
                    Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type dev.hybridlabs.aquatic.entity.critter.StarfishEntity.Companion.Type");
                    return (Type)((Object)r);
                }

                @NotNull
                public final Type fromBiome(@NotNull Holder<Biome> biome, @NotNull Random.Default random) {
                    Intrinsics.checkNotNullParameter(biome, (String)"biome");
                    Intrinsics.checkNotNullParameter((Object)random, (String)"random");
                    return biome.m_203656_(BiomeTags.f_207602_) ? BRITTLESTAR : (biome.m_203656_(HybridAquaticBiomeTags.INSTANCE.getREEF()) ? (Type)((Object)REEF_VARIANTS.get(random.nextInt(REEF_VARIANTS.size()))) : Companion.fromId(random.nextInt(2, 4)));
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.Type.values().length];
            try {
                nArray[Companion.Type.CROWN_OF_THORNS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.Type.BRITTLESTAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.Type.SMALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.Type.MEDIUM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

