/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.fish;

import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\fH\u0014J\u0014\u0010\u0012\u001a\u00020\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0014J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001bH\u0016\u00a8\u0006%"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/OarfishEntity;", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "aiStep", "", "tick", "getDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "getStandingEyeHeight", "", "dimensions", "onSyncedDataUpdated", "key", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "defineSynchedData", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "isFeeding", "", "setFeeding", "vertical", "getMaxSpawnClusterSize", "", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/core/animation/AnimatableManager$ControllerRegistrar;", "shouldFlopOnLand", "Companion", "hybrid-aquatic-forge-1.20.1"})
public final class OarfishEntity
extends HybridAquaticFishEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDataAccessor<Boolean> FEEDING;

    public OarfishEntity(@NotNull EntityType<? extends OarfishEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world, CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getNONE()), CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getSHARK()));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_21515_()) {
            if (!this.m_20069_()) {
                if (this.isFeeding()) {
                    this.m_20256_(this.m_20184_().m_82492_(0.0, 0.01, 0.0));
                    this.m_146926_(0.0f);
                }
            } else {
                this.setFeeding(false);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.getHunger() < 600 && this.m_20069_()) {
                this.setFeeding(true);
            }
            if (this.isFeeding()) {
                this.setHunger(this.getHunger() + 2);
                if (this.getHunger() >= 2400) {
                    this.setHunger(2400);
                    this.setFeeding(false);
                }
            }
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        EntityDimensions entityDimensions;
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        if (this.isFeeding()) {
            EntityDimensions entityDimensions2 = EntityDimensions.m_20395_((float)0.5f, (float)5.0f);
            Intrinsics.checkNotNull((Object)entityDimensions2);
            entityDimensions = entityDimensions2;
        } else {
            EntityDimensions entityDimensions3 = super.m_6972_(pose);
            Intrinsics.checkNotNull((Object)entityDimensions3);
            entityDimensions = entityDimensions3;
        }
        return entityDimensions;
    }

    @Override
    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        return this.isFeeding() ? dimensions.f_20378_ * 0.95f : dimensions.f_20378_ * 0.5f;
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        super.m_7350_(key);
        if (Intrinsics.areEqual(key, FEEDING)) {
            this.m_6210_();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FEEDING, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7380_(nbt);
        nbt.m_128379_("Feeding", this.isFeeding());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7378_(nbt);
        this.setFeeding(nbt.m_128471_("Feeding"));
        this.m_6210_();
    }

    private final boolean isFeeding() {
        Object object = this.f_19804_.m_135370_(FEEDING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setFeeding(boolean vertical) {
        this.f_19804_.m_135381_(FEEDING, (Object)vertical);
    }

    public int m_5792_() {
        return 2;
    }

    @Override
    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        AnimationController[] animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "Flop/Idle/Swim/Feed", 5, arg_0 -> OarfishEntity.registerControllers$lambda$0(this, arg_0))};
        controllers.add(animationControllerArray);
    }

    @Override
    public boolean shouldFlopOnLand() {
        return false;
    }

    private static final PlayState registerControllers$lambda$0(OarfishEntity this$0, AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this$0.isFeeding() ? state.setAndContinue(DefaultAnimations.SIT) : (state.isMoving() && this$0.m_5842_() ? state.setAndContinue(DefaultAnimations.SWIM) : (!this$0.m_5842_() && !this$0.m_6069_() && this$0.getMoistness() < 595 ? state.setAndContinue(HybridAquaticFishEntity.Companion.getFLOP_ANIMATION()) : state.setAndContinue(DefaultAnimations.IDLE)));
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(OarfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        FEEDING = entityDataAccessor;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ6\u0010\u000b\u001a\u00020\u00062\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/OarfishEntity$Companion;", "", "<init>", "()V", "FEEDING", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getFEEDING", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "canSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Ldev/hybridlabs/aquatic/entity/fish/OarfishEntity;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getFEEDING() {
            return FEEDING;
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.m_21183_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22277_, 16.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public final boolean canSpawn(@NotNull EntityType<? extends OarfishEntity> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            IntRange shallowSpawn = new IntRange(world.m_5736_() - 12, world.m_5736_() - 2);
            IntRange deepSpawn = new IntRange(world.m_5736_() - 128, world.m_5736_() - 48);
            IntRange spawnY = world.m_6018_().m_46470_() ? shallowSpawn : deepSpawn;
            int n = spawnY.getFirst();
            int n2 = spawnY.getLast();
            int n3 = pos.m_123342_();
            return (n <= n3 ? n3 <= n2 : false) && world.m_46801_(pos);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

