/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.miniboss;

import dev.hybridlabs.aquatic.entity.ai.goal.MinionAttackGoal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 82\u00020\u00012\u00020\u0002:\u000289B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0014J\b\u0010\u001b\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u001c\u001a\u00020\u00142\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0016J6\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010$2\b\u0010,\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010-\u001a\u00020\u0014H\u0016J\b\u0010.\u001a\u00020\u000fH\u0016J\u0010\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u0014H\u0016J\b\u00103\u001a\u00020\u000fH\u0016J\u0010\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\nH\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinionEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "type", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "factory", "Lsoftware/bernie/geckolib/core/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "owner", "Lnet/minecraft/world/entity/Mob;", "hasLimitedLife", "", "limitedLifeTicks", "", "attackTick", "tick", "", "defineSynchedData", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "registerGoals", "getOwner", "setOwner", "setLimitedLife", "getMobType", "Lnet/minecraft/world/entity/MobType;", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/core/animation/AnimatableManager$ControllerRegistrar;", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "level", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "dataTag", "aiStep", "isPushedByFluid", "removeWhenFarAway", "distanceSquared", "", "checkDespawn", "canBreatheUnderwater", "isPreventingPlayerRest", "player", "Lnet/minecraft/world/entity/player/Player;", "getAnimatableInstanceCache", "Companion", "MinionCopyOwnerTargetGoal", "hybrid-aquatic-forge-1.20.1"})
public abstract class HybridAquaticMinionEntity
extends Monster
implements GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final AnimatableInstanceCache factory;
    @Nullable
    private Mob owner;
    private boolean hasLimitedLife;
    private int limitedLifeTicks;
    private int attackTick;
    @NotNull
    private static final EntityDataAccessor<Boolean> ATTEMPT_ATTACK;

    public HybridAquaticMinionEntity(@NotNull EntityType<? extends Monster> type, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(type, world);
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasLimitedLife) {
            this.limitedLifeTicks += -1;
            if (this.limitedLifeTicks <= 0) {
                this.limitedLifeTicks = 20;
                this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTEMPT_ATTACK, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7380_(nbt);
        nbt.m_128405_("AttackTick", this.attackTick);
        if (this.hasLimitedLife) {
            nbt.m_128405_("LifeTicks", this.limitedLifeTicks);
        }
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7378_(nbt);
        this.attackTick = nbt.m_128451_("AttackTick");
        if (nbt.m_128441_("LifeTicks")) {
            this.setLimitedLife(nbt.m_128451_("LifeTicks"));
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MinionAttackGoal(this, 0.5, true));
        this.f_21346_.m_25352_(0, (Goal)new MinionCopyOwnerTargetGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.2, 16.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, null));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 10, true, true, null));
        super.m_8099_();
    }

    @Nullable
    public final Mob getOwner() {
        return this.owner;
    }

    public final void setOwner(@Nullable Mob owner) {
        this.owner = owner;
    }

    public final void setLimitedLife(int limitedLifeTicks) {
        this.hasLimitedLife = true;
        this.limitedLifeTicks = limitedLifeTicks;
    }

    @NotNull
    public MobType m_6336_() {
        MobType mobType = MobType.f_21644_;
        Intrinsics.checkNotNullExpressionValue((Object)mobType, (String)"WATER");
        return mobType;
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        AnimationController[] animationControllerArray = new AnimationController[]{DefaultAnimations.genericWalkRunIdleController((Entity)((Entity)this))};
        controllers.add(animationControllerArray);
        animationControllerArray = new AnimationController[]{DefaultAnimations.genericAttackAnimation((LivingEntity)((LivingEntity)this), (RawAnimation)DefaultAnimations.ATTACK_SWING)};
        controllers.add(animationControllerArray);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        RandomSource randomsource = level.m_213780_();
        this.m_213945_(randomsource, difficulty);
        this.m_213946_(randomsource, difficulty);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6785_(double distanceSquared) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6935_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(HybridAquaticMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        ATTEMPT_ATTACK = entityDataAccessor;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\t\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinionEntity$Companion;", "", "<init>", "()V", "ATTEMPT_ATTACK", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getATTEMPT_ATTACK", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "canSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/monster/Monster;", "world", "Lnet/minecraft/world/level/LevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getATTEMPT_ATTACK() {
            return ATTEMPT_ATTACK;
        }

        public final boolean canSpawn(@NotNull EntityType<? extends Monster> type, @NotNull LevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            return world.m_46801_(pos);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinionEntity$MinionCopyOwnerTargetGoal;", "Lnet/minecraft/world/entity/ai/goal/target/TargetGoal;", "minion", "Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinionEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinionEntity;)V", "copyOwnerTargeting", "Lnet/minecraft/world/entity/ai/targeting/TargetingConditions;", "canUse", "", "start", "", "hybrid-aquatic-forge-1.20.1"})
    public static final class MinionCopyOwnerTargetGoal
    extends TargetGoal {
        @NotNull
        private final HybridAquaticMinionEntity minion;
        @NotNull
        private final TargetingConditions copyOwnerTargeting;

        public MinionCopyOwnerTargetGoal(@NotNull HybridAquaticMinionEntity minion) {
            Intrinsics.checkNotNullParameter((Object)((Object)minion), (String)"minion");
            super((Mob)minion, false);
            this.minion = minion;
            TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_148355_().m_26893_();
            Intrinsics.checkNotNullExpressionValue((Object)targetingConditions, (String)"ignoreInvisibilityTesting(...)");
            this.copyOwnerTargeting = targetingConditions;
        }

        public boolean m_8036_() {
            Mob mob = this.minion.getOwner();
            if (mob == null) {
                return false;
            }
            Mob owner = mob;
            LivingEntity livingEntity = owner.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            LivingEntity ownerTarget = livingEntity;
            return this.m_26150_(ownerTarget, this.copyOwnerTargeting);
        }

        public void m_8056_() {
            Mob mob = this.minion.getOwner();
            if (mob == null) {
                return;
            }
            Mob owner = mob;
            LivingEntity livingEntity = owner.m_5448_();
            if (livingEntity == null) {
                return;
            }
            LivingEntity ownerTarget = livingEntity;
            this.f_26135_.m_6710_(ownerTarget);
            super.m_8056_();
        }
    }
}

