/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.platform.services;

import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.block.HybridAquaticBlocks;
import dev.hybridlabs.aquatic.item.AnemoneBlockItem;
import dev.hybridlabs.aquatic.item.GiantGreenAnemoneBlockItem;
import dev.hybridlabs.aquatic.item.MessageInABottleItem;
import dev.hybridlabs.aquatic.item.StrawberryAnemoneBlockItem;
import dev.hybridlabs.aquatic.network.HybridAquaticNetworking;
import dev.hybridlabs.aquatic.platform.registration.RegistryObject;
import dev.hybridlabs.aquatic.platform.services.PlatformHelper;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.KotlinModContainer;

public class ForgePlatformHelper
implements PlatformHelper {
    public static IEventBus getEventBus() {
        ModContainer cont = (ModContainer)ModList.get().getModContainerById("hybrid_aquatic").orElseThrow();
        if (cont instanceof FMLModContainer) {
            FMLModContainer fmlModContainer = (FMLModContainer)cont;
            return fmlModContainer.getEventBus();
        }
        if (cont instanceof KotlinModContainer) {
            KotlinModContainer kotlinModContainer = (KotlinModContainer)cont;
            return kotlinModContainer.getEventBus$kfflang();
        }
        throw new ClassCastException("The container of the mod hybrid_aquatic is not a FML one!");
    }

    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public <T extends Mob> Supplier<SpawnEggItem> registerSpawnEggItem(@NotNull String name, Supplier<EntityType<T>> entityType, int backgroundColor, int highlightColor) {
        return CommonClass.ITEMS.register(name, () -> new ForgeSpawnEggItem(entityType, backgroundColor, highlightColor, new Item.Properties()));
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public <T extends Mob> void registerSpawnPlacement(RegistryObject<EntityType<T>> entityType, SpawnPlacements.Type decoratorType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<T> decoratorPredicate) {
        SpawnPlacementRegistrationHandler<T> handler = new SpawnPlacementRegistrationHandler<T>(entityType, decoratorType, heightMapType, decoratorPredicate);
        ForgePlatformHelper.getEventBus().addListener(handler::handleEvent);
    }

    @Override
    public <T extends LivingEntity> void registerAttributes(@NotNull String id, EntityType<T> entityType, Callable<AttributeSupplier.Builder> attributeContainer) {
        AttributeRegistrationHandler handler = new AttributeRegistrationHandler(id, entityType, attributeContainer);
        ForgePlatformHelper.getEventBus().addListener(handler::handleEvent);
    }

    @Override
    public Attribute getReachAttribute() {
        return (Attribute)ForgeMod.BLOCK_REACH.get();
    }

    @Override
    public MobCategory getMobCategoryByName(String name) {
        return MobCategory.byName((String)name);
    }

    @Override
    public Item createBlockItem(Block block, Item.Properties properties) {
        if (block.equals(HybridAquaticBlocks.INSTANCE.getANEMONE().get())) {
            return new AnemoneBlockItem(block, properties);
        }
        if (block.equals(HybridAquaticBlocks.INSTANCE.getSTRAWBERRY_ANEMONE().get())) {
            return new StrawberryAnemoneBlockItem(block, properties);
        }
        if (block.equals(HybridAquaticBlocks.INSTANCE.getGIANT_GREEN_ANEMONE().get())) {
            return new GiantGreenAnemoneBlockItem(block, properties);
        }
        return new BlockItem(block, properties);
    }

    @Override
    public Item createMessageInABottleItem(Item.Properties properties) {
        return new MessageInABottleItem(properties);
    }

    @Override
    public void sendHookToServer(int entityId, ItemStack entityData) {
        HybridAquaticNetworking.INSTANCE.sendHookPacket(entityId, entityData);
    }

    private record SpawnPlacementRegistrationHandler<T extends LivingEntity>(RegistryObject<EntityType<T>> type, SpawnPlacements.Type decoratorType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<T> decoratorPredicate) {
        private void handleEvent(SpawnPlacementRegisterEvent event) {
            event.register(this.type.get(), this.decoratorType, this.heightMapType, this.decoratorPredicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
        }
    }

    private record AttributeRegistrationHandler(String id, EntityType<? extends LivingEntity> type, Callable<AttributeSupplier.Builder> supplier) {
        private void handleEvent(EntityAttributeCreationEvent event) {
            try {
                event.put(this.type, this.supplier.call().m_22265_());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

