/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block;

import com.mojang.serialization.MapCodec;
import dev.hybridlabs.aquatic.block.HybridAquaticBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J2\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010$H\u0014\u00a8\u0006&"}, d2={"Ldev/hybridlabs/aquatic/block/BullKelpBlock;", "Lnet/minecraft/world/level/block/GrowingPlantHeadBlock;", "Lnet/minecraft/world/level/block/LiquidBlockContainer;", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "canGrowInto", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getBodyBlock", "Lnet/minecraft/world/level/block/Block;", "canAttachTo", "canPlaceLiquid", "p0", "Lnet/minecraft/world/entity/player/Player;", "p1", "Lnet/minecraft/world/level/BlockGetter;", "p2", "Lnet/minecraft/core/BlockPos;", "p3", "p4", "Lnet/minecraft/world/level/material/Fluid;", "placeLiquid", "Lnet/minecraft/world/level/LevelAccessor;", "Lnet/minecraft/world/level/material/FluidState;", "getBlocksToGrowWhenBonemealed", "", "random", "Lnet/minecraft/util/RandomSource;", "getStateForPlacement", "ctx", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getFluidState", "codec", "Lcom/mojang/serialization/MapCodec;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class BullKelpBlock
extends GrowingPlantHeadBlock
implements LiquidBlockContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<BullKelpBlock> CODEC;
    @NotNull
    private static final VoxelShape SHAPE;

    public BullKelpBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, Direction.UP, SHAPE, true, 0.14);
    }

    protected boolean canGrowInto(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.is(Blocks.WATER);
    }

    @NotNull
    protected Block getBodyBlock() {
        Block block = HybridAquaticBlocks.INSTANCE.getBULL_KELP_PLANT().get();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"get(...)");
        return block;
    }

    protected boolean canAttachTo(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !state.is(Blocks.MAGMA_BLOCK);
    }

    public boolean canPlaceLiquid(@Nullable Player p0, @NotNull BlockGetter p1, @NotNull BlockPos p2, @NotNull BlockState p3, @NotNull Fluid p4) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
        Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
        return false;
    }

    public boolean placeLiquid(@NotNull LevelAccessor p0, @NotNull BlockPos p1, @NotNull BlockState p2, @NotNull FluidState p3) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
        return false;
    }

    protected int getBlocksToGrowWhenBonemealed(@NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return 1;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8 ? super.getStateForPlacement(ctx) : null;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        FluidState fluidState = Fluids.WATER.getSource(false);
        Intrinsics.checkNotNullExpressionValue((Object)fluidState, (String)"getSource(...)");
        return fluidState;
    }

    @NotNull
    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return CODEC;
    }

    static {
        MapCodec mapCodec = GrowingPlantHeadBlock.simpleCodec(BullKelpBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
        VoxelShape voxelShape = GrowingPlantHeadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/hybridlabs/aquatic/block/BullKelpBlock$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/hybridlabs/aquatic/block/BullKelpBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<BullKelpBlock> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

