/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block;

import com.mojang.serialization.MapCodec;
import dev.hybridlabs.aquatic.block.HybridAquaticBlocks;
import dev.hybridlabs.aquatic.block.entity.MessageInABottleBlockEntity;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u00012\u00020\u0002:\u000256B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J8\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000eH\u0014J(\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0014J\u001c\u0010+\u001a\u00020\u00132\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u000e0-H\u0014J\u0012\u0010/\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000100H\u0014J\u0010\u00101\u001a\u0002022\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u00103\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u00067"}, d2={"Ldev/hybridlabs/aquatic/block/MessageInABottleBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getCloneItemStack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/LevelReader;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "canSurvive", "", "world", "setPlacedBy", "", "Lnet/minecraft/world/level/Level;", "placer", "Lnet/minecraft/world/entity/LivingEntity;", "stack", "getStateForPlacement", "ctx", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "isPathfindable", "type", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "codec", "Lcom/mojang/serialization/MapCodec;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Variant", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class MessageInABottleBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape SHAPE;
    @NotNull
    private static final VoxelShape WATER_SHAPE;

    public MessageInABottleBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof MessageInABottleBlockEntity)) {
            ItemStack itemStack = super.getCloneItemStack(level, pos, state);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getCloneItemStack(...)");
            return itemStack;
        }
        return Companion.createItemStack((MessageInABottleBlockEntity)blockEntity);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        FluidState fluidStateAbove = world.getFluidState(pos.above());
        if (!fluidStateAbove.is(Fluids.EMPTY)) {
            return false;
        }
        BlockState stateBelow = world.getBlockState(pos.below());
        if (Intrinsics.areEqual((Object)stateBelow.getBlock(), (Object)((Object)this))) {
            return false;
        }
        FluidState fluidState = world.getFluidState(pos);
        return fluidState.is((Fluid)Fluids.WATER) || BaseEntityBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (customData == null) break block3;
            CustomData component = customData;
            boolean bl = false;
            Tag tag = component.copyTag().get("message");
            if (tag != null) {
                Tag it = tag;
                boolean bl2 = false;
                RegistryAccess registryManager = world.registryAccess();
                Registry registry = registryManager.registryOrThrow(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE());
                Optional optional = registry.getRandom(world.random);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRandom(...)");
                Holder.Reference reference = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
                if (reference == null || (reference = reference.key()) == null) {
                    return;
                }
                Holder.Reference messageKey = reference;
                BlockEntity blockEntity = world.getBlockEntity(pos);
                MessageInABottleBlockEntity messageInABottleBlockEntity = blockEntity instanceof MessageInABottleBlockEntity ? (MessageInABottleBlockEntity)blockEntity : null;
                if (messageInABottleBlockEntity == null) {
                    return;
                }
                MessageInABottleBlockEntity blockEntity2 = messageInABottleBlockEntity;
                blockEntity2.setMessageId(messageKey.location());
            }
        }
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        boolean waterlogged = Intrinsics.areEqual((Object)ctx.getLevel().getFluidState(ctx.getClickedPos()), (Object)Fluids.WATER.getSource(false));
        Object object = this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            BlockState blockState = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            return blockState;
        }
        BlockState blockState = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            fluidState = fluidState2;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState2, (String)"getSource(...)");
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? WATER_SHAPE : SHAPE;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.WATERLOGGED};
        builder.add(propertyArray);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new MessageInABottleBlockEntity(pos, state);
    }

    static {
        VoxelShape voxelShape = BaseEntityBlock.box((double)2.0, (double)0.0, (double)2.0, (double)13.0, (double)6.0, (double)14.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
        VoxelShape voxelShape2 = BaseEntityBlock.box((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        WATER_SHAPE = voxelShape2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Ldev/hybridlabs/aquatic/block/MessageInABottleBlock$Companion;", "", "<init>", "()V", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "WATER_SHAPE", "getWATER_SHAPE", "createItemStack", "Lnet/minecraft/world/item/ItemStack;", "blockEntity", "Ldev/hybridlabs/aquatic/block/entity/MessageInABottleBlockEntity;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VoxelShape getSHAPE() {
            return SHAPE;
        }

        @NotNull
        public final VoxelShape getWATER_SHAPE() {
            return WATER_SHAPE;
        }

        @NotNull
        public final ItemStack createItemStack(@NotNull MessageInABottleBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            ItemStack stack = new ItemStack((ItemLike)HybridAquaticBlocks.INSTANCE.getMESSAGE_IN_A_BOTTLE().get());
            RegistryAccess.Frozen frozen = RegistryAccess.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)frozen, (String)"EMPTY");
            stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntity.getUpdateTag((HolderLookup.Provider)frozen)));
            return stack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \r2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\rB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u000e"}, d2={"Ldev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getId", "()Ljava/lang/String;", "BOTTLE", "JAR", "LONGNECK", "getSerializedName", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nMessageInABottleBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageInABottleBlock.kt\ndev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1208#2,2:184\n1236#2,4:186\n*S KotlinDebug\n*F\n+ 1 MessageInABottleBlock.kt\ndev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant\n*L\n160#1:184,2\n160#1:186,4\n*E\n"})
    public static final class Variant
    extends Enum<Variant>
    implements StringRepresentable {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String id;
        @NotNull
        private static final Map<String, Variant> BY_ID;
        public static final /* enum */ Variant BOTTLE;
        public static final /* enum */ Variant JAR;
        public static final /* enum */ Variant LONGNECK;
        private static final /* synthetic */ Variant[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Variant(String id) {
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.id;
        }

        public static Variant[] values() {
            return (Variant[])$VALUES.clone();
        }

        public static Variant valueOf(String value) {
            return Enum.valueOf(Variant.class, value);
        }

        @NotNull
        public static EnumEntries<Variant> getEntries() {
            return $ENTRIES;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            BOTTLE = new Variant("bottle");
            JAR = new Variant("jar");
            LONGNECK = new Variant("longneck");
            $VALUES = variantArray = new Variant[]{Variant.BOTTLE, Variant.JAR, Variant.LONGNECK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Iterable $this$associateBy$iv = (Iterable)Variant.getEntries();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void p0;
                Variant variant = (Variant)((Object)element$iv$iv);
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.id, element$iv$iv);
            }
            BY_ID = destination$iv$iv;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant$Companion;", "", "<init>", "()V", "BY_ID", "", "", "Ldev/hybridlabs/aquatic/block/MessageInABottleBlock$Variant;", "byId", "id", "hybrid-aquatic-neoforge-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Variant byId(@NotNull String id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Variant variant = (Variant)((Object)BY_ID.get(id));
                if (variant == null) {
                    variant = BOTTLE;
                }
                return variant;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

