/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block;

import dev.hybridlabs.aquatic.effect.HybridAquaticMobEffects;
import dev.hybridlabs.aquatic.entity.crustacean.YetiCrabEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J8\u0010\u0018\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0014J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0014H\u0002J \u0010&\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010'\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0016J(\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020,2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.H\u0014J \u0010/\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020,2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J(\u00100\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020,2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u00101\u001a\u0002022\u0006\u0010\f\u001a\u00020\rH\u0014J \u00103\u001a\u00020\u001f2\u0016\u00104\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\r05H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ldev/hybridlabs/aquatic/block/ThermalVentBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "emitsParticles", "", "fireDamage", "", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(ZILnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "isPathfindable", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "type", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "canSurvive", "world", "Lnet/minecraft/world/level/LevelReader;", "pos", "Lnet/minecraft/core/BlockPos;", "getStateForPlacement", "ctx", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "animateTick", "", "Lnet/minecraft/world/level/Level;", "random", "Lnet/minecraft/util/RandomSource;", "getThickness", "Lnet/minecraft/world/level/block/state/properties/DripstoneThickness;", "currentPos", "spawnSmokeParticle", "stepOn", "entity", "Lnet/minecraft/world/entity/Entity;", "getCollisionShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getOcclusionShape", "getShape", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class ThermalVentBlock
extends Block
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean emitsParticles;
    private final int fireDamage;
    @NotNull
    private static final EnumProperty<DripstoneThickness> THICKNESS;
    @NotNull
    private static final BooleanProperty WATERLOGGED;
    private static final VoxelShape TIP_COLLISION_SHAPE;
    private static final VoxelShape MIDDLE_COLLISION_SHAPE;
    private static final VoxelShape BASE_COLLISION_SHAPE;
    private static final VoxelShape TIP_SHAPE;
    private static final VoxelShape MIDDLE_SHAPE;
    private static final VoxelShape BASE_SHAPE;

    public ThermalVentBlock(boolean emitsParticles, int fireDamage, @NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.emitsParticles = emitsParticles;
        this.fireDamage = fireDamage;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)THICKNESS, (Comparable)DripstoneThickness.TIP));
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos supportingPos = pos.below();
        BlockState supportingState = world.getBlockState(supportingPos);
        return supportingState.is((Block)this) || supportingState.isFaceSturdy((BlockGetter)world, supportingPos, Direction.UP);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState blockState = this.defaultBlockState();
        Property property = (Property)THICKNESS;
        Intrinsics.checkNotNull((Object)world);
        LevelReader levelReader = (LevelReader)world;
        Intrinsics.checkNotNull((Object)pos);
        return (BlockState)((BlockState)blockState.setValue(property, (Comparable)this.getThickness(levelReader, pos))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).is((Fluid)Fluids.WATER)));
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
            return blockState2;
        }
        if (direction != Direction.DOWN && direction != Direction.UP) {
            blockState = state;
        } else {
            Object object = state.setValue((Property)THICKNESS, (Comparable)this.getThickness((LevelReader)world, pos));
            Intrinsics.checkNotNull((Object)object);
            blockState = (BlockState)object;
        }
        return blockState;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (state.getValue((Property)THICKNESS) == DripstoneThickness.TIP && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            this.spawnSmokeParticle(world, pos, random);
        }
    }

    private final DripstoneThickness getThickness(LevelReader world, BlockPos currentPos) {
        BlockState blockBelow;
        BlockState blockAbove = world.getBlockState(currentPos.relative(Direction.UP));
        return blockAbove.is((Block)this) ? ((blockBelow = world.getBlockState(currentPos.relative(Direction.DOWN))).is((Block)this) ? DripstoneThickness.MIDDLE : DripstoneThickness.BASE) : DripstoneThickness.TIP;
    }

    private final void spawnSmokeParticle(Level world, BlockPos pos, RandomSource random) {
        world.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)pos.getX() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.01, 0.0);
    }

    public void stepOn(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (world.isClientSide) {
            return;
        }
        if (state.getValue((Property)THICKNESS) == DripstoneThickness.TIP && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && !(entity instanceof YetiCrabEntity) && !entity.isSteppingCarefully() && entity instanceof LivingEntity && EnchantmentHelper.getEnchantmentLevel((Holder)((Holder)((Registry)world.registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(Enchantments.FROST_WALKER).get()), (LivingEntity)((LivingEntity)entity)) < 1) {
            ((LivingEntity)entity).hurt(world.damageSources().hotFloor(), (float)this.fireDamage);
            ((LivingEntity)entity).addEffect(new MobEffectInstance(HybridAquaticMobEffects.INSTANCE.getCORROSION().asHolder(), 200, 0));
        }
        super.stepOn(world, pos, state, entity);
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Comparable comparable = state.getValue((Property)THICKNESS);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.properties.DripstoneThickness");
        DripstoneThickness thickness = (DripstoneThickness)comparable;
        VoxelShape voxelShape = switch (WhenMappings.$EnumSwitchMapping$0[thickness.ordinal()]) {
            case 1 -> TIP_COLLISION_SHAPE;
            case 2 -> MIDDLE_COLLISION_SHAPE;
            case 3 -> BASE_COLLISION_SHAPE;
            default -> throw new IllegalStateException("Unexpected thickness: " + thickness);
        };
        Vec3 vec3d = state.getOffset(world, pos);
        VoxelShape voxelShape2 = voxelShape.move(vec3d.x, 0.0, vec3d.z);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"move(...)");
        return voxelShape2;
    }

    @NotNull
    protected VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        VoxelShape voxelShape = Shapes.empty();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
        return voxelShape;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Comparable comparable = state.getValue((Property)THICKNESS);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.properties.DripstoneThickness");
        DripstoneThickness thickness = (DripstoneThickness)comparable;
        VoxelShape voxelShape = switch (WhenMappings.$EnumSwitchMapping$0[thickness.ordinal()]) {
            case 1 -> TIP_SHAPE;
            case 2 -> MIDDLE_SHAPE;
            case 3 -> BASE_SHAPE;
            default -> throw new IllegalStateException("Unexpected thickness: " + thickness);
        };
        Vec3 modelOffset = state.getOffset(world, pos);
        VoxelShape voxelShape2 = voxelShape.move(modelOffset.x, 0.0, modelOffset.z);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"move(...)");
        return voxelShape2;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            Intrinsics.checkNotNull((Object)fluidState2);
            fluidState = fluidState2;
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            Intrinsics.checkNotNull((Object)fluidState3);
            fluidState = fluidState3;
        }
        return fluidState;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{THICKNESS, WATERLOGGED};
        builder.add(propertyArray);
    }

    static {
        DripstoneThickness[] dripstoneThicknessArray = new DripstoneThickness[]{DripstoneThickness.TIP, DripstoneThickness.MIDDLE, DripstoneThickness.BASE};
        EnumProperty enumProperty = EnumProperty.create((String)"thickness", DripstoneThickness.class, (Enum[])((Enum[])dripstoneThicknessArray));
        Intrinsics.checkNotNullExpressionValue((Object)enumProperty, (String)"create(...)");
        THICKNESS = enumProperty;
        BooleanProperty booleanProperty = BlockStateProperties.WATERLOGGED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"WATERLOGGED");
        WATERLOGGED = booleanProperty;
        TIP_COLLISION_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
        MIDDLE_COLLISION_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        BASE_COLLISION_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        TIP_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
        MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        BASE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/hybridlabs/aquatic/block/ThermalVentBlock$Companion;", "", "<init>", "()V", "THICKNESS", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/world/level/block/state/properties/DripstoneThickness;", "getTHICKNESS", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "WATERLOGGED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getWATERLOGGED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "TIP_COLLISION_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "MIDDLE_COLLISION_SHAPE", "BASE_COLLISION_SHAPE", "TIP_SHAPE", "MIDDLE_SHAPE", "BASE_SHAPE", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnumProperty<DripstoneThickness> getTHICKNESS() {
            return THICKNESS;
        }

        @NotNull
        public final BooleanProperty getWATERLOGGED() {
            return WATERLOGGED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DripstoneThickness.values().length];
            try {
                nArray[DripstoneThickness.TIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DripstoneThickness.MIDDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DripstoneThickness.BASE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

