/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.client.model.entity.fish;

import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.client.model.entity.fish.HybridAquaticFishEntityModel;
import dev.hybridlabs.aquatic.entity.fish.BlowfishEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Ldev/hybridlabs/aquatic/client/model/entity/fish/BlowfishEntityModel;", "Ldev/hybridlabs/aquatic/client/model/entity/fish/HybridAquaticFishEntityModel;", "Ldev/hybridlabs/aquatic/entity/fish/BlowfishEntity;", "<init>", "()V", "getRenderType", "Lnet/minecraft/client/renderer/RenderType;", "animatable", "texture", "Lnet/minecraft/resources/ResourceLocation;", "getTextureResource", "getModelResource", "hybrid-aquatic-neoforge-1.21.1"})
public final class BlowfishEntityModel
extends HybridAquaticFishEntityModel<BlowfishEntity> {
    public BlowfishEntityModel() {
        super("blowfish");
    }

    @NotNull
    public RenderType getRenderType(@NotNull BlowfishEntity animatable, @NotNull ResourceLocation texture) {
        Intrinsics.checkNotNullParameter((Object)((Object)animatable), (String)"animatable");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        RenderType renderType = RenderType.entityTranslucent((ResourceLocation)texture);
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"entityTranslucent(...)");
        return renderType;
    }

    @Override
    @NotNull
    public ResourceLocation getTextureResource(@NotNull BlowfishEntity animatable) {
        Intrinsics.checkNotNullParameter((Object)((Object)animatable), (String)"animatable");
        int puffState = animatable.getPuffState();
        String texturePath = switch (puffState) {
            case 0 -> "textures/entity/fish/blowfish/blowfish_small.png";
            case 1 -> "textures/entity/fish/blowfish/blowfish_medium.png";
            default -> "textures/entity/fish/blowfish/blowfish_large.png";
        };
        ResourceLocation resourceLocation = CommonClass.locate(texturePath);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"locate(...)");
        return resourceLocation;
    }

    @Override
    @NotNull
    public ResourceLocation getModelResource(@NotNull BlowfishEntity animatable) {
        Intrinsics.checkNotNullParameter((Object)((Object)animatable), (String)"animatable");
        int puffState = animatable.getPuffState();
        String texturePath = switch (puffState) {
            case 0 -> "geo/fish/blowfish/blowfish_small.geo.json";
            case 1 -> "geo/fish/blowfish/blowfish_medium.geo.json";
            default -> "geo/fish/blowfish/blowfish_large.geo.json";
        };
        ResourceLocation resourceLocation = CommonClass.locate(texturePath);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"locate(...)");
        return resourceLocation;
    }
}

