/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal;

import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0014J\b\u0010$\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\"H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/FishAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "fish", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "speedMultiplier", "", "followingTargetEvenIfNotSeen", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;DZ)V", "getFish", "()Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "path", "Lnet/minecraft/world/level/pathfinder/Path;", "pathedTargetX", "pathedTargetY", "pathedTargetZ", "ticksUntilNextPathRecalculation", "", "ticksUntilNextAttack", "lastCanUseCheck", "", "speedModifier", "getSpeedModifier", "()D", "canUse", "canContinueToUse", "start", "", "stop", "requiresUpdateEveryTick", "tick", "checkAndPerformAttack", "enemy", "Lnet/minecraft/world/entity/LivingEntity;", "distToEnemySqr", "resetAttackCooldown", "getAttackReachSqr", "attackTarget", "hybrid-aquatic-neoforge-1.21.1"})
public class FishAttackGoal
extends Goal {
    @NotNull
    private final HybridAquaticFishEntity fish;
    private final double speedMultiplier;
    private final boolean followingTargetEvenIfNotSeen;
    @Nullable
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;

    public FishAttackGoal(@NotNull HybridAquaticFishEntity fish, double speedMultiplier, boolean followingTargetEvenIfNotSeen) {
        Intrinsics.checkNotNullParameter((Object)((Object)fish), (String)"fish");
        this.fish = fish;
        this.speedMultiplier = speedMultiplier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
    }

    public /* synthetic */ FishAttackGoal(HybridAquaticFishEntity hybridAquaticFishEntity, double d, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(hybridAquaticFishEntity, d, bl);
    }

    @NotNull
    protected final HybridAquaticFishEntity getFish() {
        return this.fish;
    }

    private final double getSpeedModifier() {
        return this.fish.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedMultiplier;
    }

    public boolean canUse() {
        if (this.fish.getFromFishingNet()) {
            return false;
        }
        long i = this.fish.level().getGameTime();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingEntity = this.fish.getTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.isAlive()) {
            return false;
        }
        this.path = this.fish.getNavigation().createPath((Entity)livingEntity, 3);
        return this.path != null ? true : this.getAttackReachSqr(livingEntity) >= this.fish.distanceToSqr(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
    }

    public boolean canContinueToUse() {
        LivingEntity livingEntity = this.fish.getTarget();
        return livingEntity == null ? false : (!livingEntity.isAlive() ? false : (!this.followingTargetEvenIfNotSeen ? !this.fish.getNavigation().isDone() : (!this.fish.isWithinRestriction(livingEntity.blockPosition()) ? false : !(livingEntity instanceof Player) || !((Player)livingEntity).isSpectator() && !((Player)livingEntity).isCreative())));
    }

    public void start() {
        this.fish.getNavigation().moveTo(this.path, this.getSpeedModifier());
        this.fish.setAggressive(true);
        this.fish.setSprinting(true);
        this.fish.swinging = false;
        this.fish.swingTime = 0;
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        LivingEntity livingEntity = this.fish.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingEntity)) {
            this.fish.setTarget(null);
        }
        this.fish.setSprinting(false);
        this.fish.setAggressive(false);
        this.fish.getNavigation().stop();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingEntity = this.fish.getTarget();
        if (livingEntity != null) {
            this.fish.getLookControl().setLookAt((Entity)livingEntity, 30.0f, 30.0f);
            double d0 = this.fish.distanceToSqr((Entity)livingEntity);
            this.ticksUntilNextPathRecalculation = (int)Math.max((double)(this.ticksUntilNextPathRecalculation - 1), 0.0);
            if ((this.followingTargetEvenIfNotSeen || this.fish.getSensing().hasLineOfSight((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.fish.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingEntity.getX();
                this.pathedTargetY = livingEntity.getY();
                this.pathedTargetZ = livingEntity.getZ();
                this.ticksUntilNextPathRecalculation = 4 + this.fish.getRandom().nextInt(7);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.fish.getNavigation().moveTo((Entity)livingEntity, this.getSpeedModifier())) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = (int)Math.max((double)(this.ticksUntilNextAttack - 1), 0.0);
            this.checkAndPerformAttack(livingEntity, d0);
        }
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity enemy, double distToEnemySqr) {
        Intrinsics.checkNotNullParameter((Object)enemy, (String)"enemy");
        double d0 = this.getAttackReachSqr(enemy);
        if (distToEnemySqr <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.fish.swing(InteractionHand.MAIN_HAND);
            this.fish.doHurtTarget((Entity)enemy);
            if (enemy.getHealth() <= 0.0f) {
                this.fish.setHunger(2400);
            }
            this.fish.setHealth(this.fish.getMaxHealth());
        }
    }

    private final void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected double getAttackReachSqr(@NotNull LivingEntity attackTarget) {
        Intrinsics.checkNotNullParameter((Object)attackTarget, (String)"attackTarget");
        return this.fish.getBbWidth() * 1.75f * this.fish.getBbWidth() * 1.75f + attackTarget.getBbWidth();
    }
}

