/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal;

import dev.hybridlabs.aquatic.entity.miniboss.HybridAquaticMinionEntity;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0014J\b\u0010\"\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020 H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/MinionAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "minion", "Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinionEntity;", "speedMultiplier", "", "followingTargetEvenIfNotSeen", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinionEntity;DZ)V", "path", "Lnet/minecraft/world/level/pathfinder/Path;", "pathedTargetX", "pathedTargetY", "pathedTargetZ", "ticksUntilNextPathRecalculation", "", "ticksUntilNextAttack", "lastCanUseCheck", "", "speedModifier", "getSpeedModifier", "()D", "canUse", "canContinueToUse", "start", "", "stop", "requiresUpdateEveryTick", "tick", "checkAndPerformAttack", "enemy", "Lnet/minecraft/world/entity/LivingEntity;", "distToEnemySqr", "resetAttackCooldown", "getAttackReachSqr", "attackTarget", "hybrid-aquatic-neoforge-1.21.1"})
public class MinionAttackGoal
extends Goal {
    @NotNull
    private final HybridAquaticMinionEntity minion;
    private final double speedMultiplier;
    private final boolean followingTargetEvenIfNotSeen;
    @Nullable
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;

    public MinionAttackGoal(@NotNull HybridAquaticMinionEntity minion, double speedMultiplier, boolean followingTargetEvenIfNotSeen) {
        Intrinsics.checkNotNullParameter((Object)((Object)minion), (String)"minion");
        this.minion = minion;
        this.speedMultiplier = speedMultiplier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
    }

    public /* synthetic */ MinionAttackGoal(HybridAquaticMinionEntity hybridAquaticMinionEntity, double d, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(hybridAquaticMinionEntity, d, bl);
    }

    private final double getSpeedModifier() {
        return this.minion.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedMultiplier;
    }

    public boolean canUse() {
        long i = this.minion.level().getGameTime();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingEntity = this.minion.getTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.isAlive()) {
            return false;
        }
        this.path = this.minion.getNavigation().createPath((Entity)livingEntity, 3);
        return this.path != null ? true : this.getAttackReachSqr(livingEntity) >= this.minion.distanceToSqr(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
    }

    public boolean canContinueToUse() {
        LivingEntity livingEntity = this.minion.getTarget();
        return livingEntity == null ? false : (!livingEntity.isAlive() ? false : (!this.followingTargetEvenIfNotSeen ? !this.minion.getNavigation().isDone() : (!this.minion.isWithinRestriction(livingEntity.blockPosition()) ? false : !(livingEntity instanceof Player) || !((Player)livingEntity).isSpectator() && !((Player)livingEntity).isCreative())));
    }

    public void start() {
        this.minion.getNavigation().moveTo(this.path, this.getSpeedModifier());
        this.minion.setAggressive(true);
        this.minion.setSprinting(true);
        this.minion.swinging = false;
        this.minion.swingTime = 0;
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        LivingEntity livingEntity = this.minion.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingEntity)) {
            this.minion.setTarget(null);
        }
        this.minion.setSprinting(false);
        this.minion.setAggressive(false);
        this.minion.getNavigation().stop();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingEntity = this.minion.getTarget();
        if (livingEntity != null) {
            this.minion.getLookControl().setLookAt((Entity)livingEntity, 30.0f, 30.0f);
            double d0 = this.minion.distanceToSqr((Entity)livingEntity);
            this.ticksUntilNextPathRecalculation = (int)Math.max((double)(this.ticksUntilNextPathRecalculation - 1), 0.0);
            if ((this.followingTargetEvenIfNotSeen || this.minion.getSensing().hasLineOfSight((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.minion.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingEntity.getX();
                this.pathedTargetY = livingEntity.getY();
                this.pathedTargetZ = livingEntity.getZ();
                this.ticksUntilNextPathRecalculation = 4 + this.minion.getRandom().nextInt(7);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.minion.getNavigation().moveTo((Entity)livingEntity, this.getSpeedModifier())) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = (int)Math.max((double)(this.ticksUntilNextAttack - 1), 0.0);
            this.checkAndPerformAttack(livingEntity, d0);
        }
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity enemy, double distToEnemySqr) {
        Intrinsics.checkNotNullParameter((Object)enemy, (String)"enemy");
        double d0 = this.getAttackReachSqr(enemy);
        if (distToEnemySqr <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.minion.swing(InteractionHand.MAIN_HAND);
            this.minion.doHurtTarget((Entity)enemy);
        }
    }

    private final void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(10);
    }

    protected double getAttackReachSqr(@NotNull LivingEntity attackTarget) {
        Intrinsics.checkNotNullParameter((Object)attackTarget, (String)"attackTarget");
        return this.minion.getBbWidth() * 1.75f * this.minion.getBbWidth() * 1.75f + attackTarget.getBbWidth();
    }
}

