/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.cephalopod;

import dev.hybridlabs.aquatic.entity.cephalopod.HybridAquaticCephalopodEntity;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.entity.mammal.HybridAquaticMammalEntity;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 i2\u00020\u00012\u00020\u0002:\u0003ijkBK\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\b\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u0006\u0010\u001f\u001a\u00020\u000bJ\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u000bH\u0002J\b\u0010\"\u001a\u00020\u000bH\u0016J\b\u0010#\u001a\u00020\u001bH\u0014J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0014J,\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0005\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010(H\u0016J\b\u0010/\u001a\u00020\u000bH\u0016J\b\u00100\u001a\u00020\u001bH\u0016J\b\u00101\u001a\u00020\u0019H\u0016J\b\u00102\u001a\u00020\u0019H\u0016J\u0006\u00103\u001a\u00020\u0019J\u0010\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u0019H\u0002J\u0006\u00106\u001a\u00020\u0019J\u000e\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u0019J\b\u00109\u001a\u00020\u001bH\u0002J\u0018\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020\u001bH\u0002J\b\u0010@\u001a\u00020AH\u0014J\u0010\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010F\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020\u0019H\u0014J\b\u0010K\u001a\u00020\u0019H\u0002J\u0018\u0010L\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020<2\u0006\u0010M\u001a\u00020\u000bH\u0014J\b\u0010N\u001a\u00020\u0019H\u0016J\b\u0010O\u001a\u00020PH\u0014J\u0010\u0010Q\u001a\u00020P2\u0006\u0010;\u001a\u00020<H\u0014J\b\u0010R\u001a\u00020PH\u0014J\b\u0010S\u001a\u00020PH\u0002J\b\u0010b\u001a\u00020\u0019H\u0014J\b\u0010c\u001a\u00020\u0019H\u0014J\u0010\u0010e\u001a\u00020\u001b2\u0006\u0010f\u001a\u00020gH\u0016J\b\u0010h\u001a\u00020\u0016H\u0016R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010T\u001a\u00020\u00192\u0006\u0010T\u001a\u00020\u00198B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR$\u0010Y\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bZ\u0010V\"\u0004\b[\u0010XR$\u0010\\\u001a\u00020\u00192\u0006\u0010\\\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b]\u0010V\"\u0004\b^\u0010XR$\u0010_\u001a\u00020\u000b2\u0006\u0010_\u001a\u00020\u000b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b`\u0010\u0012\"\u0004\ba\u0010\u0014R\u000e\u0010d\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticOctopusEntity;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "type", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "prey", "Lnet/minecraft/tags/TagKey;", "predator", "hasInk", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/tags/TagKey;Lnet/minecraft/tags/TagKey;Z)V", "getPrey", "()Lnet/minecraft/tags/TagKey;", "getPredator", "getHasInk", "()Z", "setHasInk", "(Z)V", "factory", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "sittingTimer", "", "travel", "", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "aiStep", "isSitting", "setSitting", "sitting", "isVisuallySwimming", "registerGoals", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "isPushedByFluid", "tick", "getMaxHeadXRot", "getMaxHeadYRot", "getTargetColor", "setTargetColor", "targetColor", "getCurrentColor", "setCurrentColor", "currentColor", "determineTargetColor", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "squirt", "getInkParticle", "Lnet/minecraft/core/particles/SimpleParticleType;", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "removeWhenFarAway", "distanceSquared", "", "handleAirSupply", "air", "getMaxMoistness", "dropFromLootTable", "causedByPlayer", "getMaxSpawnClusterSize", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "getDeathSound", "getSquirtSound", "moistness", "getMoistness", "()I", "setMoistness", "(I)V", "size", "getSize", "setSize", "hunger", "getHunger", "setHunger", "attemptAttack", "getAttemptAttack", "setAttemptAttack", "getMinSize", "getMaxSize", "fromFishingNet", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "Companion", "OctopusSwimmingGoal", "OctopusMoveControl", "hybrid-aquatic-neoforge-1.21.1"})
public class HybridAquaticOctopusEntity
extends WaterAnimal
implements GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TagKey<EntityType<?>> prey;
    @NotNull
    private final TagKey<EntityType<?>> predator;
    private boolean hasInk;
    private final AnimatableInstanceCache factory;
    private int sittingTimer;
    private boolean fromFishingNet;
    @NotNull
    private static final EntityDataAccessor<Boolean> SITTING;
    @NotNull
    private static final EntityDataAccessor<Integer> MOISTNESS;
    @NotNull
    private static final EntityDataAccessor<Integer> OCTOPUS_SIZE;
    @NotNull
    private static final EntityDataAccessor<Integer> HUNGER;
    @NotNull
    private static final EntityDataAccessor<Boolean> ATTEMPT_ATTACK;
    @NotNull
    private static final EntityDataAccessor<Integer> CURRENT_COLOR;
    @NotNull
    private static final EntityDataAccessor<Integer> TARGET_COLOR;
    public static final int MAX_HUNGER = 2400;
    @NotNull
    public static final String HUNGER_KEY = "Hunger";
    @NotNull
    public static final String MOISTNESS_KEY = "Moistness";
    @NotNull
    public static final String OCTOPUS_SIZE_KEY = "OctopusSize";

    public HybridAquaticOctopusEntity(@NotNull EntityType<? extends HybridAquaticOctopusEntity> type, @NotNull Level world, @NotNull TagKey<EntityType<?>> prey, @NotNull TagKey<EntityType<?>> predator, boolean hasInk) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(prey, (String)"prey");
        Intrinsics.checkNotNullParameter(predator, (String)"predator");
        super(type, world);
        this.prey = prey;
        this.predator = predator;
        this.hasInk = hasInk;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = (MoveControl)new OctopusMoveControl(this, 85, 10, 0.02f, 0.1f, false);
        this.lookControl = (LookControl)new SmoothSwimmingLookControl((Mob)this, 10);
        this.navigation = (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    @NotNull
    public TagKey<EntityType<?>> getPrey() {
        return this.prey;
    }

    @NotNull
    public TagKey<EntityType<?>> getPredator() {
        return this.predator;
    }

    public boolean getHasInk() {
        return this.hasInk;
    }

    public void setHasInk(boolean bl) {
        this.hasInk = bl;
    }

    public void travel(@NotNull Vec3 travelVector) {
        Intrinsics.checkNotNullParameter((Object)travelVector, (String)"travelVector");
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && this.isEffectiveAi()) {
            if (this.isInWater()) {
                if (this.isSitting()) {
                    this.sittingTimer += -1;
                    if (this.sittingTimer <= 0) {
                        this.setSitting(false);
                    } else {
                        this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.01, 0.0));
                    }
                } else if (this.random.nextFloat() <= 0.001f) {
                    this.sittingTimer = this.random.nextInt(200, 650);
                    this.setSitting(true);
                }
            } else {
                this.setSitting(false);
            }
        }
    }

    public final boolean isSitting() {
        Object object = this.entityData.get(SITTING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setSitting(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
    }

    public boolean isVisuallySwimming() {
        return this.isSwimming();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new OctopusSwimmingGoal(this, 1.0, 10));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(MOISTNESS, (Object)this.getMaxMoistness());
        builder.define(OCTOPUS_SIZE, (Object)0);
        builder.define(HUNGER, (Object)2400);
        builder.define(ATTEMPT_ATTACK, (Object)false);
        builder.define(SITTING, (Object)true);
        builder.define(TARGET_COLOR, (Object)12799593);
        builder.define(CURRENT_COLOR, (Object)12799593);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        this.setSize(this.random.nextIntBetweenInclusive(this.getMinSize(), this.getMaxSize()));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void tick() {
        super.tick();
        this.determineTargetColor();
        if (this.isInWater()) {
            this.setMoistness(this.getMaxMoistness());
        } else {
            this.setMoistness(this.getMoistness() - 1);
            if (this.getMoistness() <= -20) {
                this.setMoistness(0);
                DamageSource damageSource = this.damageSources().dryOut();
                Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"dryOut(...)");
                this.hurt(damageSource, 2.0f);
                this.setXRot(0.0f);
                this.setYRot(0.0f);
                this.yHeadRot = 0.0f;
            }
        }
        if (this.isSitting()) {
            this.setXRot(0.0f);
            this.setYRot(0.0f);
            this.yHeadRot = 0.0f;
        }
        if (this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    public final int getTargetColor() {
        Object object = this.entityData.get(TARGET_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setTargetColor(int targetColor) {
        this.entityData.set(TARGET_COLOR, (Object)targetColor);
    }

    public final int getCurrentColor() {
        Object object = this.entityData.get(CURRENT_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setCurrentColor(int currentColor) {
        this.entityData.set(CURRENT_COLOR, (Object)currentColor);
    }

    private final void determineTargetColor() {
        BlockPos currentPos = this.blockPosition();
        BlockPos floorPos = this.getOnPos();
        BlockState sharedBlock = this.level().getBlockState(currentPos);
        BlockState floor = this.level().getBlockState(floorPos);
        if (!sharedBlock.isAir() && !sharedBlock.getFluidState().is(FluidTags.WATER)) {
            int sharedColor = sharedBlock.getMapColor((BlockGetter)((BlockGetter)this.level()), (BlockPos)currentPos).col;
            if (this.getTargetColor() != sharedColor && sharedColor != 0) {
                this.setTargetColor(sharedColor);
            }
        } else if (!floor.getFluidState().is(FluidTags.WATER)) {
            int floorColor = floor.getMapColor((BlockGetter)((BlockGetter)this.level()), (BlockPos)floorPos).col;
            if (this.getTargetColor() != floorColor && floorColor != 0) {
                this.setTargetColor(floorColor);
            }
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (super.hurt(source, amount) && this.getLastHurtByMob() != null) {
            if (!this.level().isClientSide) {
                Vec3 attackerPos;
                if (this.isSitting()) {
                    this.setSitting(false);
                }
                if (this.isUnderWater() && this.getHasInk()) {
                    this.squirt();
                }
                LivingEntity livingEntity = this.getLastHurtByMob();
                Object object = attackerPos = livingEntity != null ? livingEntity.position() : null;
                if (attackerPos != null) {
                    Vec3 directionAway = this.position().subtract(attackerPos).normalize().scale(10.0);
                    Vec3 targetPos = this.position().add(directionAway.x, 0.0, directionAway.z);
                    this.navigation.moveTo(targetPos.x, targetPos.y, targetPos.z, 1.5);
                }
            }
            return true;
        }
        return false;
    }

    private final void squirt() {
        this.playSound(this.getSquirtSound(), this.getSoundVolume(), this.getVoicePitch());
        Vec3 entityPosition = new Vec3(this.getX(), this.getY(), this.getZ());
        double radius = 3.0;
        List affectedEntities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(entityPosition.x - radius, entityPosition.y - radius, entityPosition.z - radius, entityPosition.x + radius, entityPosition.y + radius, entityPosition.z + radius), arg_0 -> HybridAquaticOctopusEntity.squirt$lambda$1(arg_0 -> HybridAquaticOctopusEntity.squirt$lambda$0(this, arg_0), arg_0));
        for (LivingEntity entity : affectedEntities) {
            entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0));
            entity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 100, 0));
        }
        for (int i = 0; i < 200; ++i) {
            double offsetX = (this.random.nextDouble() - 0.5) * 2.0;
            double offsetY = (this.random.nextDouble() - 0.5) * 2.0;
            double offsetZ = (this.random.nextDouble() - 0.5) * 2.0;
            double randomMultiplier = 0.5 + this.random.nextDouble() * 1.5;
            Vec3 velocity = new Vec3(offsetX, offsetY, offsetZ).normalize().scale(randomMultiplier);
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ((ServerLevel)level).sendParticles((ParticleOptions)this.getInkParticle(), entityPosition.x, entityPosition.y, entityPosition.z, 1, velocity.x * 0.25, velocity.y * 0.25, velocity.z * 0.25, 0.1);
        }
    }

    @NotNull
    protected SimpleParticleType getInkParticle() {
        SimpleParticleType simpleParticleType = ParticleTypes.SQUID_INK;
        Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SQUID_INK");
        return simpleParticleType;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.addAdditionalSaveData(nbt);
        nbt.putInt(MOISTNESS_KEY, this.getMoistness());
        nbt.putInt(OCTOPUS_SIZE_KEY, this.getSize());
        nbt.putInt(HUNGER_KEY, this.getHunger());
        nbt.putBoolean("FromFishingNet", this.fromFishingNet);
        nbt.putBoolean("Sitting", this.isSitting());
        nbt.putInt("targetColor", this.getTargetColor());
        nbt.putInt("currentColor", this.getCurrentColor());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readAdditionalSaveData(nbt);
        this.setMoistness(nbt.getInt(MOISTNESS_KEY));
        this.setSize(nbt.getInt(OCTOPUS_SIZE_KEY));
        this.setHunger(nbt.getInt(HUNGER_KEY));
        this.fromFishingNet = nbt.getBoolean("FromFishingNet");
        this.setTargetColor(nbt.getInt("targetColor"));
        this.setCurrentColor(nbt.getInt("currentColor"));
        this.setSitting(nbt.getBoolean("Sitting"));
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromFishingNet && !this.hasCustomName();
    }

    protected void handleAirSupply(int air) {
    }

    private final int getMaxMoistness() {
        return 1200;
    }

    protected void dropFromLootTable(@NotNull DamageSource source, boolean causedByPlayer) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Entity attacker = source.getDirectEntity();
        if (!(attacker instanceof HybridAquaticFishEntity || attacker instanceof HybridAquaticSharkEntity || attacker instanceof HybridAquaticCephalopodEntity || attacker instanceof HybridAquaticMammalEntity)) {
            super.dropFromLootTable(source, causedByPlayer);
        }
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        SoundEvent soundEvent = SoundEvents.SQUID_AMBIENT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_AMBIENT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.SQUID_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.SQUID_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_DEATH");
        return soundEvent;
    }

    private final SoundEvent getSquirtSound() {
        SoundEvent soundEvent = SoundEvents.SQUID_SQUIRT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_SQUIRT");
        return soundEvent;
    }

    private final int getMoistness() {
        Object object = this.entityData.get(MOISTNESS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setMoistness(int moistness) {
        this.entityData.set(MOISTNESS, (Object)moistness);
    }

    public final int getSize() {
        Object object = this.entityData.get(OCTOPUS_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setSize(int size) {
        this.entityData.set(OCTOPUS_SIZE, (Object)size);
    }

    public final int getHunger() {
        Object object = this.entityData.get(HUNGER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setHunger(int hunger) {
        this.entityData.set(HUNGER, (Object)hunger);
    }

    private final boolean getAttemptAttack() {
        Object object = this.entityData.get(ATTEMPT_ATTACK);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setAttemptAttack(boolean attemptAttack) {
        this.entityData.set(ATTEMPT_ATTACK, (Object)attemptAttack);
    }

    protected int getMinSize() {
        return 0;
    }

    protected int getMaxSize() {
        return 3;
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "Swim/Idle", 10, HybridAquaticOctopusEntity::registerControllers$lambda$0));
        controllers.add(new AnimationController((GeoAnimatable)this, "Sit", 10, arg_0 -> HybridAquaticOctopusEntity.registerControllers$lambda$1(this, arg_0)));
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    private static final boolean squirt$lambda$0(HybridAquaticOctopusEntity this$0, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it, (Object)((Object)this$0)) && it.isAlive();
    }

    private static final boolean squirt$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PlayState registerControllers$lambda$0(AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.setAndContinue(state.isMoving() ? DefaultAnimations.SWIM : DefaultAnimations.IDLE);
    }

    private static final PlayState registerControllers$lambda$1(HybridAquaticOctopusEntity this$0, AnimationState state) {
        PlayState playState;
        if (this$0.isSitting() || this$0.onGround()) {
            state.setAndContinue(DefaultAnimations.SIT);
            playState = PlayState.CONTINUE;
        } else {
            playState = PlayState.STOP;
        }
        return playState;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(HybridAquaticOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        SITTING = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(HybridAquaticOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        MOISTNESS = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(HybridAquaticOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        OCTOPUS_SIZE = entityDataAccessor3;
        EntityDataAccessor entityDataAccessor4 = SynchedEntityData.defineId(HybridAquaticOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor4, (String)"defineId(...)");
        HUNGER = entityDataAccessor4;
        EntityDataAccessor entityDataAccessor5 = SynchedEntityData.defineId(HybridAquaticOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor5, (String)"defineId(...)");
        ATTEMPT_ATTACK = entityDataAccessor5;
        EntityDataAccessor entityDataAccessor6 = SynchedEntityData.defineId(HybridAquaticOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor6, (String)"defineId(...)");
        CURRENT_COLOR = entityDataAccessor6;
        EntityDataAccessor entityDataAccessor7 = SynchedEntityData.defineId(HybridAquaticOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor7, (String)"defineId(...)");
        TARGET_COLOR = entityDataAccessor7;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0019\u001a\u00020\u00062\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticOctopusEntity$Companion;", "", "<init>", "()V", "SITTING", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getSITTING", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "MOISTNESS", "", "getMOISTNESS", "OCTOPUS_SIZE", "getOCTOPUS_SIZE", "HUNGER", "getHUNGER", "ATTEMPT_ATTACK", "getATTEMPT_ATTACK", "CURRENT_COLOR", "TARGET_COLOR", "MAX_HUNGER", "HUNGER_KEY", "", "MOISTNESS_KEY", "OCTOPUS_SIZE_KEY", "canSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "getScaleAdjustment", "", "octopus", "Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticOctopusEntity;", "adjustment", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getSITTING() {
            return SITTING;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getMOISTNESS() {
            return MOISTNESS;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getOCTOPUS_SIZE() {
            return OCTOPUS_SIZE;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getHUNGER() {
            return HUNGER;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getATTEMPT_ATTACK() {
            return ATTEMPT_ATTACK;
        }

        public final boolean canSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            return pos.getY() >= world.getSeaLevel() - 64 && world.getBlockState(pos.below()).isSolid();
        }

        public final float getScaleAdjustment(@NotNull HybridAquaticOctopusEntity octopus, float adjustment) {
            Intrinsics.checkNotNullParameter((Object)((Object)octopus), (String)"octopus");
            return 1.0f + (float)octopus.getSize() * adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticOctopusEntity$OctopusMoveControl;", "Lnet/minecraft/world/entity/ai/control/SmoothSwimmingMoveControl;", "octopus", "Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticOctopusEntity;", "maxTurnX", "", "maxTurnY", "inWaterSpeedModifier", "", "outsideWaterSpeedModifier", "applyGravity", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticOctopusEntity;IIFFZ)V", "tick", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OctopusMoveControl
    extends SmoothSwimmingMoveControl {
        @NotNull
        private final HybridAquaticOctopusEntity octopus;

        public OctopusMoveControl(@NotNull HybridAquaticOctopusEntity octopus, int maxTurnX, int maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
            Intrinsics.checkNotNullParameter((Object)((Object)octopus), (String)"octopus");
            super((Mob)octopus, maxTurnX, maxTurnY, inWaterSpeedModifier, outsideWaterSpeedModifier, applyGravity);
            this.octopus = octopus;
        }

        public void tick() {
            if (!this.octopus.isSitting()) {
                super.tick();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticOctopusEntity$OctopusSwimmingGoal;", "Lnet/minecraft/world/entity/ai/goal/RandomSwimmingGoal;", "octopus", "Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticOctopusEntity;", "speedModifier", "", "interval", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticOctopusEntity;DI)V", "canUse", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OctopusSwimmingGoal
    extends RandomSwimmingGoal {
        @NotNull
        private final HybridAquaticOctopusEntity octopus;

        public OctopusSwimmingGoal(@NotNull HybridAquaticOctopusEntity octopus, double speedModifier, int interval) {
            Intrinsics.checkNotNullParameter((Object)((Object)octopus), (String)"octopus");
            super((PathfinderMob)octopus, speedModifier, interval);
            this.octopus = octopus;
        }

        public boolean canUse() {
            return !this.octopus.isSitting() && super.canUse();
        }
    }
}

