/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.critter;

import dev.hybridlabs.aquatic.entity.ai.control.WallClimbNavigation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0001>B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0014J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\rH\u0002J,\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0005\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\"\u001a\u00020\rH\u0014J\b\u0010#\u001a\u00020\rH\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u000fH\u0014J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u000fH\u0014J\b\u0010.\u001a\u00020\u000fH\u0014J\u0010\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u000fH\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0014J\b\u00107\u001a\u000204H\u0014J\b\u00108\u001a\u00020\nH\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00109\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u00a8\u0006?"}, d2={"Ldev/hybridlabs/aquatic/entity/critter/HybridAquaticCritterEntity;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "type", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "factory", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "fromFishingNet", "", "climbingTicks", "", "isMoving", "tick", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "registerGoals", "onClimbable", "isClimbingWall", "setClimbingWall", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "isAffectedByFluids", "isPushedByFluid", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "handleAirSupply", "air", "registerControllers", "controllerRegistrar", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getMinSize", "getMaxSize", "removeWhenFarAway", "distanceSquared", "", "getMaxSpawnClusterSize", "getHurtSound", "Lnet/minecraft/sounds/SoundEvent;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "getAnimatableInstanceCache", "size", "getSize", "()I", "setSize", "(I)V", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public class HybridAquaticCritterEntity
extends WaterAnimal
implements GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final AnimatableInstanceCache factory;
    private boolean fromFishingNet;
    private int climbingTicks;
    @NotNull
    private static final EntityDataAccessor<Integer> CRITTER_SIZE;
    @NotNull
    private static final EntityDataAccessor<Byte> CRITTER_FLAGS;
    @NotNull
    private static final EntityDataAccessor<Boolean> CLIMBING;
    @NotNull
    public static final String CRITTER_SIZE_KEY = "CritterSize";

    public HybridAquaticCritterEntity(@NotNull EntityType<? extends HybridAquaticCritterEntity> type, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(type, world);
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.moveControl = new MoveControl((Mob)this);
        this.navigation = (PathNavigation)new WallClimbNavigation((Mob)this, world);
    }

    public final boolean isMoving() {
        return (this.onGround() || this.onClimbable()) && this.getDeltaMovement().lengthSqr() >= 1.0E-4;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setClimbingWall(this.horizontalCollision);
        }
        if (this.isClimbingWall()) {
            int n = this.climbingTicks;
            this.climbingTicks = n + 1;
        } else {
            this.climbingTicks = 0;
        }
        if (this.onClimbable()) {
            Vec3 velocity = this.getDeltaMovement();
            this.setDeltaMovement(velocity.x, velocity.y * 0.33, velocity.z);
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(CRITTER_SIZE, (Object)0);
        builder.define(CRITTER_FLAGS, (Object)0);
        builder.define(CLIMBING, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.3));
    }

    public boolean onClimbable() {
        return this.climbingTicks > 8 && this.isClimbingWall();
    }

    private final boolean isClimbingWall() {
        Object object = this.entityData.get(CLIMBING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setClimbingWall(boolean isClimbingWall) {
        this.entityData.set(CLIMBING, (Object)isClimbingWall);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        this.setSize(this.random.nextIntBetweenInclusive(this.getMinSize(), this.getMaxSize()));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    protected boolean isAffectedByFluids() {
        return !this.onGround();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.addAdditionalSaveData(nbt);
        nbt.putInt(CRITTER_SIZE_KEY, this.getSize());
        nbt.putBoolean("FromFishingNet", this.fromFishingNet);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readAdditionalSaveData(nbt);
        this.setSize(nbt.getInt(CRITTER_SIZE_KEY));
        this.fromFishingNet = nbt.getBoolean("FromFishingNet");
    }

    protected void handleAirSupply(int air) {
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllerRegistrar) {
        Intrinsics.checkNotNullParameter((Object)controllerRegistrar, (String)"controllerRegistrar");
        controllerRegistrar.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)((GeoAnimatable)this)));
    }

    protected int getMinSize() {
        return 0;
    }

    protected int getMaxSize() {
        return 0;
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromFishingNet && !this.hasCustomName();
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.SLIME_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SLIME_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.SLIME_DEATH_SMALL;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SLIME_DEATH_SMALL");
        return soundEvent;
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    public final int getSize() {
        Object object = this.entityData.get(CRITTER_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setSize(int size) {
        this.entityData.set(CRITTER_SIZE, (Object)size);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(HybridAquaticCritterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        CRITTER_SIZE = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(HybridAquaticCritterEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        CRITTER_FLAGS = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(HybridAquaticCritterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        CLIMBING = entityDataAccessor3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u000f\u001a\u00020\r2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u000e\u0010 \u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/hybridlabs/aquatic/entity/critter/HybridAquaticCritterEntity$Companion;", "", "<init>", "()V", "CRITTER_SIZE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getCRITTER_SIZE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "CRITTER_FLAGS", "", "getCRITTER_FLAGS", "CLIMBING", "", "getCLIMBING", "canSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "getScaleAdjustment", "", "critter", "Ldev/hybridlabs/aquatic/entity/critter/HybridAquaticCritterEntity;", "adjustment", "CRITTER_SIZE_KEY", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getCRITTER_SIZE() {
            return CRITTER_SIZE;
        }

        @NotNull
        public final EntityDataAccessor<Byte> getCRITTER_FLAGS() {
            return CRITTER_FLAGS;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getCLIMBING() {
            return CLIMBING;
        }

        public final boolean canSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel();
            int bottomY = world.getSeaLevel() - 128;
            int n = pos.getY();
            return (bottomY <= n ? n <= topY : false) && world.getBlockState(pos.below()).isSolid() && world.isWaterAt(pos);
        }

        public final float getScaleAdjustment(@NotNull HybridAquaticCritterEntity critter, float adjustment) {
            Intrinsics.checkNotNullParameter((Object)((Object)critter), (String)"critter");
            return 1.0f + (float)critter.getSize() * adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

