/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.fish;

import dev.hybridlabs.aquatic.entity.ai.goal.HybridAquaticJumpGoal;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0014J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0014J,\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0004\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020\rH\u0002J\b\u0010!\u001a\u00020\rH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/AfricanButterflyfishEntity;", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "isGliding", "", "getMaxSpawnClusterSize", "", "registerGoals", "", "tick", "handleAirSupply", "air", "getMaxAirSupply", "increaseAirSupply", "currentAir", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "startGliding", "stopGliding", "applyGlidingPhysics", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class AfricanButterflyfishEntity
extends HybridAquaticFishEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isGliding;

    public AfricanButterflyfishEntity(@NotNull EntityType<? extends AfricanButterflyfishEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Object[] objectArray = new TagKey[]{HybridAquaticEntityTags.INSTANCE.getMEDIUM_PREY(), HybridAquaticEntityTags.INSTANCE.getLARGE_PREY(), HybridAquaticEntityTags.INSTANCE.getSHARK()};
        super(entityType, world, CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getNONE()), CollectionsKt.listOf((Object[])objectArray));
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(5, (Goal)new HybridAquaticJumpGoal((PathfinderMob)this, 10));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isNoAi()) {
            this.setAirSupply(this.getMaxAirSupply());
        }
        if (!this.wasTouchingWater && !this.onGround()) {
            if (!this.isGliding) {
                this.startGliding();
            }
            this.applyGlidingPhysics();
        } else if (this.isGliding) {
            this.stopGliding();
        }
    }

    @Override
    protected void handleAirSupply(int air) {
        if (!this.isInWater() && !this.isNoAi()) {
            this.setAirSupply(this.getAirSupply() - 1);
        } else {
            this.setAirSupply(this.getMaxAirSupply());
        }
    }

    public int getMaxAirSupply() {
        return 900;
    }

    protected int increaseAirSupply(int currentAir) {
        return this.getMaxAirSupply();
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        this.setAirSupply(this.getMaxAirSupply());
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "Fly/Swim/Idle", 5, arg_0 -> AfricanButterflyfishEntity.registerControllers$lambda$0(this, arg_0)));
    }

    private final void startGliding() {
        this.isGliding = true;
    }

    private final void stopGliding() {
        this.isGliding = false;
    }

    private final void applyGlidingPhysics() {
        if (!this.isGliding) {
            return;
        }
        Vec3 motion = this.getDeltaMovement();
        Vec3 newMotion = new Vec3(motion.x * 1.1, RangesKt.coerceAtLeast((double)(motion.y * 0.95), (double)-0.1), motion.z * 1.1);
        this.setDeltaMovement(newMotion);
    }

    private static final PlayState registerControllers$lambda$0(AfricanButterflyfishEntity this$0, AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this$0.isGliding ? state.setAndContinue(DefaultAnimations.FLY) : (state.isMoving() ? state.setAndContinue(DefaultAnimations.SWIM) : state.setAndContinue(DefaultAnimations.IDLE));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/AfricanButterflyfishEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.createLivingAttributes().add(Attributes.MAX_HEALTH, 2.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FOLLOW_RANGE, 4.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

