/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.fish;

import dev.hybridlabs.aquatic.entity.ai.goal.boids.BoidGoal;
import dev.hybridlabs.aquatic.entity.ai.goal.boids.StayInWaterGoal;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticSchoolingFishEntity;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0014\u0010\u000f\u001a\u00020\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J,\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0004\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0014J\u0018\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016\u00a8\u00061"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/FlashlightFishEntity;", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "getMaxSpawnClusterSize", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "onSyncedDataUpdated", "key", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getFishCount", "setFishCount", "state", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "tick", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "getDefaultDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "canCollideWith", "", "entity", "Lnet/minecraft/world/entity/Entity;", "doPush", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class FlashlightFishEntity
extends HybridAquaticSchoolingFishEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDataAccessor<Integer> FISHCOUNT;
    public static final int ONE_FISH = 1;
    public static final int TWO_FISH = 2;
    public static final int THREE_FISH = 3;

    public FlashlightFishEntity(@NotNull EntityType<? extends FlashlightFishEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Object[] objectArray = new TagKey[]{HybridAquaticEntityTags.INSTANCE.getMEDIUM_PREY(), HybridAquaticEntityTags.INSTANCE.getLARGE_PREY(), HybridAquaticEntityTags.INSTANCE.getSHARK()};
        super(entityType, world, CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getNONE()), CollectionsKt.listOf((Object[])objectArray), null, 0, 48, null);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new BoidGoal((Mob)this, 0.25f, 0.5f, 0.4f, 0.05f));
        this.goalSelector.addGoal(3, (Goal)new StayInWaterGoal((Mob)this));
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 12;
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(FISHCOUNT, (Object)1);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        super.onSyncedDataUpdated(key);
        if (Intrinsics.areEqual(key, FISHCOUNT)) {
            this.refreshDimensions();
        }
    }

    public final int getFishCount() {
        Object object = this.entityData.get(FISHCOUNT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setFishCount(int state) {
        this.entityData.set(FISHCOUNT, (Object)state);
        this.refreshDimensions();
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.addAdditionalSaveData(nbt);
        nbt.putInt("FishCount", this.getFishCount());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readAdditionalSaveData(nbt);
        this.setFishCount(RangesKt.coerceAtMost((int)nbt.getInt("FishCount"), (int)3));
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            float maxHp = (float)this.getAttributeValue(Attributes.MAX_HEALTH);
            float fraction = this.getHealth() / maxHp;
            if (fraction > 0.6666667f) {
                this.setFishCount(3);
            } else if (fraction > 0.33333334f) {
                this.setFishCount(2);
            } else {
                this.setFishCount(1);
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        float maxHp = (float)this.getAttributeValue(Attributes.MAX_HEALTH);
        float startingFraction = this.random.nextFloat();
        float startingHealth = maxHp * RangesKt.coerceAtLeast((float)startingFraction, (float)0.34f);
        this.setHealth(startingHealth);
        float fraction = this.getHealth() / maxHp;
        if (fraction > 0.6666667f) {
            this.setFishCount(3);
        } else if (fraction > 0.33333334f) {
            this.setFishCount(2);
        } else {
            this.setFishCount(1);
        }
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @NotNull
    protected EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        float scale = switch (this.getFishCount()) {
            case 1 -> 1.0f;
            case 2 -> 2.0f;
            case 3 -> 3.0f;
            default -> 1.0f;
        };
        EntityDimensions entityDimensions = super.getDefaultDimensions(pose).scale(scale);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"scale(...)");
        return entityDimensions;
    }

    public boolean canCollideWith(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof FlashlightFishEntity) {
            return false;
        }
        return super.canCollideWith(entity);
    }

    protected void doPush(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof FlashlightFishEntity) {
            return;
        }
        super.doPush(entity);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        float maxHp = (float)this.getAttributeValue(Attributes.MAX_HEALTH);
        float oldFraction = this.getHealth() / maxHp;
        boolean result = super.hurt(source, amount);
        if (result && !this.level().isClientSide) {
            int newFishCount;
            float newFraction = this.getHealth() / maxHp;
            int oldFishCount = oldFraction > 0.6666667f ? 3 : (oldFraction > 0.33333334f ? 2 : 1);
            int n = newFraction > 0.6666667f ? 3 : (newFishCount = newFraction > 0.33333334f ? 2 : 1);
            boolean bl = 1 <= newFishCount ? newFishCount < oldFishCount : false;
            if (bl) {
                this.spawnAtLocation((ItemLike)HybridAquaticItems.INSTANCE.getFLASHLIGHT_FISH().get());
            }
        }
        return result;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(FlashlightFishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        FISHCOUNT = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J6\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/FlashlightFishEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "FISHCOUNT", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "ONE_FISH", "TWO_FISH", "THREE_FISH", "canSpawn", "", "type", "Lnet/minecraft/world/entity/EntityType;", "Ldev/hybridlabs/aquatic/entity/fish/FlashlightFishEntity;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.createLivingAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FOLLOW_RANGE, 4.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public final boolean canSpawn(@NotNull EntityType<? extends FlashlightFishEntity> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            IntRange nightSpawn = RangesKt.until((int)(world.getSeaLevel() - 16), (int)world.getSeaLevel());
            IntRange daySpawn = new IntRange(world.getSeaLevel() - 128, world.getSeaLevel() - 48);
            IntRange spawnY = !world.getLevel().isDay() ? nightSpawn : daySpawn;
            int n = spawnY.getFirst();
            int n2 = spawnY.getLast();
            int n3 = pos.getY();
            return (n <= n3 ? n3 <= n2 : false) && world.isWaterAt(pos);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

