/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.fish;

import dev.hybridlabs.aquatic.entity.ai.goal.boids.BoidGoal;
import dev.hybridlabs.aquatic.entity.ai.goal.boids.StayInWaterGoal;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticSchoolingFishEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticBiomeTags;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import java.util.Collection;
import java.util.function.IntFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 %2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001%B\u001f\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0003H\u0016\u00a8\u0006&"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/TetraEntity;", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;", "Lnet/minecraft/world/entity/VariantHolder;", "Ldev/hybridlabs/aquatic/entity/fish/TetraEntity$Companion$Type;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "canCollideWith", "", "entity", "Lnet/minecraft/world/entity/Entity;", "doPush", "getMaxSpawnClusterSize", "", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "getVariant", "setVariant", "type", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class TetraEntity
extends HybridAquaticSchoolingFishEntity
implements VariantHolder<Companion.Type> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDataAccessor<Integer> TYPE;

    public TetraEntity(@NotNull EntityType<? extends TetraEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Object[] objectArray = new TagKey[]{HybridAquaticEntityTags.INSTANCE.getMEDIUM_PREY(), HybridAquaticEntityTags.INSTANCE.getLARGE_PREY(), HybridAquaticEntityTags.INSTANCE.getSHARK()};
        super(entityType, world, CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getNONE()), CollectionsKt.listOf((Object[])objectArray), null, 0, 48, null);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new BoidGoal((Mob)this, 0.25f, 0.5f, 0.4f, 0.05f));
        this.goalSelector.addGoal(3, (Goal)new StayInWaterGoal((Mob)this));
    }

    public boolean canCollideWith(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof TetraEntity) {
            return false;
        }
        return super.canCollideWith(entity);
    }

    protected void doPush(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof TetraEntity) {
            return;
        }
        super.doPush(entity);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 3;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        Holder biome = world.getBiome(this.blockPosition());
        Intrinsics.checkNotNull((Object)biome);
        Companion.Type selectedType = Companion.Type.Companion.fromBiome((Holder<Biome>)biome);
        this.setVariant(selectedType);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(TYPE, (Object)0);
        super.defineSynchedData(builder);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.putString("Type", this.getVariant().getSerializedName());
        super.addAdditionalSaveData(nbt);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.setVariant(Companion.Type.Companion.byName(nbt.getString("Type")));
        super.readAdditionalSaveData(nbt);
    }

    @NotNull
    public Companion.Type getVariant() {
        Object object = this.entityData.get(TYPE);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        return Companion.Type.Companion.fromId((Integer)object);
    }

    public void setVariant(@NotNull Companion.Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.entityData.set(TYPE, (Object)type.getId());
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(TetraEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        TYPE = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/TetraEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "TYPE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getTYPE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "Type", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.createLivingAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FOLLOW_RANGE, 4.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getTYPE() {
            return TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000e2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u000eB\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000f"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/TetraEntity$Companion$Type;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "key", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getId", "()I", "NEON", "CAVE", "getSerializedName", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
        @SourceDebugExtension(value={"SMAP\nTetraEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TetraEntity.kt\ndev/hybridlabs/aquatic/entity/fish/TetraEntity$Companion$Type\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,147:1\n37#2,2:148\n37#2,2:150\n*S KotlinDebug\n*F\n+ 1 TetraEntity.kt\ndev/hybridlabs/aquatic/entity/fish/TetraEntity$Companion$Type\n*L\n95#1:148,2\n98#1:150,2\n*E\n"})
        public static final class Type
        extends Enum<Type>
        implements StringRepresentable {
            @NotNull
            public static final Companion Companion;
            private final int id;
            @NotNull
            private final String key;
            @NotNull
            private static final StringRepresentable.EnumCodec<Type> CODEC;
            @NotNull
            private static final IntFunction<Type> BY_ID;
            public static final /* enum */ Type NEON;
            public static final /* enum */ Type CAVE;
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Type(int id, String key) {
                this.id = id;
                this.key = key;
            }

            public final int getId() {
                return this.id;
            }

            @NotNull
            public String getSerializedName() {
                return this.key;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            private static final Type[] CODEC$lambda$0() {
                Collection $this$toTypedArray$iv = (Collection)Type.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new Type[0]);
            }

            private static final int BY_ID$lambda$0(Type obj) {
                Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
                return obj.id;
            }

            static {
                NEON = new Type(0, "neon");
                CAVE = new Type(1, "cave");
                $VALUES = typeArray = new Type[]{Type.NEON, Type.CAVE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                StringRepresentable.EnumCodec enumCodec = StringRepresentable.fromEnum(Type::CODEC$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
                CODEC = enumCodec;
                Collection $this$toTypedArray$iv = (Collection)Type.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IntFunction intFunction = ByIdMap.continuous(Type::BY_ID$lambda$0, (Object[])thisCollection$iv.toArray(new Type[0]), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
                Intrinsics.checkNotNullExpressionValue((Object)intFunction, (String)"continuous(...)");
                BY_ID = intFunction;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/TetraEntity$Companion$Type$Companion;", "", "<init>", "()V", "CODEC", "Lnet/minecraft/util/StringRepresentable$EnumCodec;", "Ldev/hybridlabs/aquatic/entity/fish/TetraEntity$Companion$Type;", "getCODEC", "()Lnet/minecraft/util/StringRepresentable$EnumCodec;", "BY_ID", "Ljava/util/function/IntFunction;", "byName", "name", "", "fromId", "id", "", "fromBiome", "biome", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "hybrid-aquatic-neoforge-1.21.1"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final StringRepresentable.EnumCodec<Type> getCODEC() {
                    return CODEC;
                }

                @NotNull
                public final Type byName(@Nullable String name) {
                    Enum enum_ = this.getCODEC().byName(name, (Enum)NEON);
                    Intrinsics.checkNotNull((Object)enum_, (String)"null cannot be cast to non-null type dev.hybridlabs.aquatic.entity.fish.TetraEntity.Companion.Type");
                    return (Type)enum_;
                }

                @NotNull
                public final Type fromId(int id) {
                    Object r = BY_ID.apply(id);
                    Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type dev.hybridlabs.aquatic.entity.fish.TetraEntity.Companion.Type");
                    return (Type)((Object)r);
                }

                @NotNull
                public final Type fromBiome(@NotNull Holder<Biome> biome) {
                    Intrinsics.checkNotNullParameter(biome, (String)"biome");
                    return biome.is(HybridAquaticBiomeTags.INSTANCE.getCAVES()) ? CAVE : NEON;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

