/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.jellyfish;

import dev.hybridlabs.aquatic.entity.ai.goal.boids.StayInWaterGoal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 c2\u00020\u00012\u00020\u0002:\u0002bcB/\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0014J\b\u0010.\u001a\u00020\bH\u0016J\b\u0010/\u001a\u00020\nH\u0016J\b\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u0002012\u0006\u00103\u001a\u000204H\u0014J\b\u00105\u001a\u000201H\u0014J\b\u00106\u001a\u00020\u0011H\u0014J\b\u00107\u001a\u00020*H\u0016J\u0010\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020*H\u0016J\u0018\u0010<\u001a\u00020\b2\u0006\u00103\u001a\u0002042\u0006\u0010=\u001a\u00020\u0011H\u0016J\u0010\u0010>\u001a\u00020*2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020*2\u0006\u0010E\u001a\u00020FH\u0016J\u001e\u0010G\u001a\u00020*2\u0006\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u0011J\u0006\u0010K\u001a\u00020\bJ\u0010\u0010T\u001a\u00020*2\u0006\u0010U\u001a\u00020VH\u0016J\b\u0010W\u001a\u00020\u000eH\u0016J\u0010\u0010X\u001a\u00020*2\u0006\u0010Y\u001a\u00020\nH\u0014J\b\u0010Z\u001a\u00020\nH\u0002J\b\u0010[\u001a\u00020\nH\u0014J\b\u0010\\\u001a\u00020\nH\u0014J\u0010\u0010]\u001a\u00020*2\u0006\u0010^\u001a\u00020_H\u0016J\u0010\u0010a\u001a\u00020*2\u0006\u0010^\u001a\u00020_H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u000e\u0010\u001f\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010L\u001a\u00020\n2\u0006\u0010L\u001a\u00020\n8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR$\u0010Q\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bR\u0010N\"\u0004\bS\u0010PR\u000e\u0010`\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Ldev/hybridlabs/aquatic/entity/jellyfish/HybridAquaticJellyfishEntity;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "type", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "isVenomous", "", "venomLevel", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;ZI)V", "factory", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "tiltAngle", "", "getTiltAngle", "()F", "setTiltAngle", "(F)V", "prevTiltAngle", "getPrevTiltAngle", "setPrevTiltAngle", "rollAngle", "getRollAngle", "setRollAngle", "prevRollAngle", "getPrevRollAngle", "setPrevRollAngle", "thrustTimer", "prevThrustTimer", "swimVelocityScale", "thrustTimerSpeed", "tentacleAngle", "prevTentacleAngle", "turningSpeed", "swimX", "swimY", "swimZ", "registerGoals", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "isPushedByFluid", "getMaxSpawnClusterSize", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "getSoundVolume", "tick", "removeWhenFarAway", "distanceSquared", "", "aiStep", "hurt", "amount", "playerTouch", "player", "Lnet/minecraft/world/entity/player/Player;", "travel", "movementInput", "Lnet/minecraft/world/phys/Vec3;", "handleEntityEvent", "status", "", "setSwimmingVector", "x", "y", "z", "hasSwimmingVector", "moistness", "getMoistness", "()I", "setMoistness", "(I)V", "size", "getSize", "setSize", "registerControllers", "controllerRegistrar", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "handleAirSupply", "air", "getMaxMoistness", "getMinSize", "getMaxSize", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "fromFishingNet", "readAdditionalSaveData", "SwimGoal", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public class HybridAquaticJellyfishEntity
extends WaterAnimal
implements GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVenomous;
    private final int venomLevel;
    private final AnimatableInstanceCache factory;
    private float tiltAngle;
    private float prevTiltAngle;
    private float rollAngle;
    private float prevRollAngle;
    private float thrustTimer;
    private float prevThrustTimer;
    private float swimVelocityScale;
    private float thrustTimerSpeed;
    private float tentacleAngle;
    private float prevTentacleAngle;
    private float turningSpeed;
    private float swimX;
    private float swimY;
    private float swimZ;
    private boolean fromFishingNet;
    @NotNull
    private static final EntityDataAccessor<Integer> MOISTNESS;
    @NotNull
    private static final EntityDataAccessor<Integer> JELLYFISH_SIZE;
    @NotNull
    public static final String MOISTNESS_KEY = "Moistness";
    @NotNull
    public static final String JELLYFISH_SIZE_KEY = "JellyfishSize";

    public HybridAquaticJellyfishEntity(@NotNull EntityType<? extends HybridAquaticJellyfishEntity> type, @NotNull Level world, boolean isVenomous, int venomLevel) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(type, world);
        this.isVenomous = isVenomous;
        this.venomLevel = venomLevel;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        this.random.setSeed((long)this.getId());
        this.thrustTimerSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = (MoveControl)new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.05f, 0.1f, true);
        this.lookControl = (LookControl)new SmoothSwimmingLookControl((Mob)this, 10);
        this.navigation = (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    public final float getTiltAngle() {
        return this.tiltAngle;
    }

    public final void setTiltAngle(float f) {
        this.tiltAngle = f;
    }

    public final float getPrevTiltAngle() {
        return this.prevTiltAngle;
    }

    public final void setPrevTiltAngle(float f) {
        this.prevTiltAngle = f;
    }

    public final float getRollAngle() {
        return this.rollAngle;
    }

    public final void setRollAngle(float f) {
        this.rollAngle = f;
    }

    public final float getPrevRollAngle() {
        return this.prevRollAngle;
    }

    public final void setPrevRollAngle(float f) {
        this.prevRollAngle = f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SwimGoal(this));
        this.goalSelector.addGoal(0, (Goal)new StayInWaterGoal((Mob)this));
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(MOISTNESS, (Object)this.getMaxMoistness());
        builder.define(JELLYFISH_SIZE, (Object)0);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        SoundEvent soundEvent = SoundEvents.SQUID_AMBIENT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_AMBIENT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.SLIME_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SLIME_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.SLIME_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SLIME_DEATH");
        return soundEvent;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public void tick() {
        super.tick();
        if (this.isInWaterRainOrBubble()) {
            this.setMoistness(this.getMaxMoistness());
        } else {
            this.setMoistness(this.getMoistness() - 1);
            if (this.getMoistness() <= -20) {
                this.setMoistness(0);
                DamageSource damageSource = this.damageSources().dryOut();
                Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"dryOut(...)");
                this.hurt(damageSource, 1.0f);
            }
        }
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromFishingNet && !this.hasCustomName();
    }

    public void aiStep() {
        super.aiStep();
        this.prevTiltAngle = this.tiltAngle;
        this.prevRollAngle = this.rollAngle;
        this.prevThrustTimer = this.thrustTimer;
        this.prevTentacleAngle = this.tentacleAngle;
        this.thrustTimer += this.thrustTimerSpeed;
        if ((double)this.thrustTimer > Math.PI * 2) {
            if (this.level().isClientSide) {
                this.thrustTimer = (float)Math.PI * 2;
            } else {
                this.thrustTimer -= (float)Math.PI * 2;
                if (this.random.nextInt(10) == 0) {
                    this.thrustTimerSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)19);
            }
        }
        if (this.isInWaterOrBubble()) {
            if (this.thrustTimer < (float)Math.PI) {
                float f = this.thrustTimer / (float)Math.PI;
                this.tentacleAngle = Mth.sin((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.swimVelocityScale = 0.5f;
                    this.turningSpeed = 0.5f;
                } else {
                    this.turningSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.swimVelocityScale *= 0.9f;
                this.turningSpeed *= 0.99f;
            }
            if (!this.level().isClientSide) {
                this.setDeltaMovement(this.swimX * this.swimVelocityScale, this.swimY * this.swimVelocityScale, this.swimZ * this.swimVelocityScale);
            }
            Vec3 vec3d = this.getDeltaMovement();
            double d = vec3d.horizontalDistance();
            float targetYaw = -((float)Mth.atan2((double)vec3d.x, (double)vec3d.z)) * 57.295776f;
            float deltaYaw = Mth.wrapDegrees((float)(targetYaw - this.yBodyRot));
            this.yBodyRot += deltaYaw * 0.1f;
            this.yHeadRot = this.yBodyRot;
            this.setYRot(this.yBodyRot);
            this.rollAngle += (float)Math.PI * this.turningSpeed * 1.5f;
            this.tiltAngle += (-((float)Mth.atan2((double)d, (double)vec3d.y)) * 57.295776f - this.tiltAngle) * 0.1f;
        } else {
            this.tentacleAngle = Mth.abs((float)Mth.sin((float)this.thrustTimer)) * (float)Math.PI * 0.25f;
            if (!this.level().isClientSide) {
                double e = this.getDeltaMovement().y;
                if (this.hasEffect(MobEffects.LEVITATION)) {
                    MobEffectInstance mobEffectInstance = this.getEffect(MobEffects.LEVITATION);
                    Intrinsics.checkNotNull((Object)mobEffectInstance);
                    e = 0.05 * (double)(mobEffectInstance.getAmplifier() + 1);
                } else if (!this.isNoGravity()) {
                    e -= 0.08;
                }
                this.setDeltaMovement(0.0, e * (double)0.98f, 0.0);
            }
            this.tiltAngle += (-90.0f - this.tiltAngle) * 0.02f;
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (super.hurt(source, amount)) {
            Entity attacker = source.getDirectEntity();
            if (attacker instanceof Player && this.isVenomous && ((Player)attacker).getMainHandItem().isEmpty()) {
                ((Player)attacker).addEffect(new MobEffectInstance(MobEffects.POISON, 200, this.venomLevel));
                this.playSound(SoundEvents.PUFFER_FISH_STING, 0.5f, 0.5f);
            }
            return true;
        }
        return false;
    }

    public void playerTouch(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.playerTouch(player);
        if (player instanceof ServerPlayer && this.isVenomous && !((ServerPlayer)player).isPassenger()) {
            ((ServerPlayer)player).hurt(this.damageSources().mobAttack((LivingEntity)this), 1.0f);
            player.addEffect(new MobEffectInstance(MobEffects.POISON, 100, this.venomLevel), (Entity)this);
        }
    }

    public void travel(@NotNull Vec3 movementInput) {
        Intrinsics.checkNotNullParameter((Object)movementInput, (String)"movementInput");
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void handleEntityEvent(byte status) {
        if (status == 19) {
            this.thrustTimer = 0.0f;
        } else {
            super.handleEntityEvent(status);
        }
    }

    public final void setSwimmingVector(float x, float y, float z) {
        this.swimX = x;
        this.swimY = y;
        this.swimZ = z;
    }

    public final boolean hasSwimmingVector() {
        return !(this.swimX == 0.0f) || !(this.swimY == 0.0f) || !(this.swimZ == 0.0f);
    }

    private final int getMoistness() {
        Object object = this.entityData.get(MOISTNESS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setMoistness(int moistness) {
        this.entityData.set(MOISTNESS, (Object)moistness);
    }

    public final int getSize() {
        Object object = this.entityData.get(JELLYFISH_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setSize(int size) {
        this.entityData.set(JELLYFISH_SIZE, (Object)size);
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllerRegistrar) {
        Intrinsics.checkNotNullParameter((Object)controllerRegistrar, (String)"controllerRegistrar");
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "Swim/Idle", 20, HybridAquaticJellyfishEntity::registerControllers$lambda$0).setOverrideEasingType(EasingType.EASE_IN_OUT_SINE));
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    protected void handleAirSupply(int air) {
    }

    private final int getMaxMoistness() {
        return 300;
    }

    protected int getMinSize() {
        return -3;
    }

    protected int getMaxSize() {
        return 3;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.addAdditionalSaveData(nbt);
        nbt.putInt(MOISTNESS_KEY, this.getMoistness());
        nbt.putInt(JELLYFISH_SIZE_KEY, this.getSize());
        nbt.putBoolean("FromFishingNet", this.fromFishingNet);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readAdditionalSaveData(nbt);
        this.setMoistness(nbt.getInt(MOISTNESS_KEY));
        this.setSize(nbt.getInt(JELLYFISH_SIZE_KEY));
        this.fromFishingNet = nbt.getBoolean("FromFishingNet");
    }

    private static final PlayState registerControllers$lambda$0(AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.isMoving() ? state.setAndContinue(DefaultAnimations.SWIM) : state.setAndContinue(DefaultAnimations.SWIM);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(HybridAquaticJellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        MOISTNESS = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(HybridAquaticJellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        JELLYFISH_SIZE = entityDataAccessor2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J6\u0010\u0018\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u001e\u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/hybridlabs/aquatic/entity/jellyfish/HybridAquaticJellyfishEntity$Companion;", "", "<init>", "()V", "MOISTNESS", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getMOISTNESS", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "JELLYFISH_SIZE", "getJELLYFISH_SIZE", "canSpawn", "", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "canDeepSpawn", "getScaleAdjustment", "", "jellyfish", "Ldev/hybridlabs/aquatic/entity/jellyfish/HybridAquaticJellyfishEntity;", "adjustment", "MOISTNESS_KEY", "", "JELLYFISH_SIZE_KEY", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getMOISTNESS() {
            return MOISTNESS;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getJELLYFISH_SIZE() {
            return JELLYFISH_SIZE;
        }

        public final boolean canSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel() - 4;
            int bottomY = world.getSeaLevel() - 24;
            int n = pos.getY();
            return (bottomY <= n ? n <= topY : false) && world.isWaterAt(pos) && world.canSeeSkyFromBelowWater(pos);
        }

        public final boolean canDeepSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel() - 48;
            int bottomY = world.getSeaLevel() - 128;
            int n = pos.getY();
            return (bottomY <= n ? n <= topY : false) && world.isWaterAt(pos);
        }

        public final float getScaleAdjustment(@NotNull HybridAquaticJellyfishEntity jellyfish, float adjustment) {
            Intrinsics.checkNotNullParameter((Object)((Object)jellyfish), (String)"jellyfish");
            return 1.0f + (float)jellyfish.getSize() * adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/hybridlabs/aquatic/entity/jellyfish/HybridAquaticJellyfishEntity$SwimGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "jellyfish", "Ldev/hybridlabs/aquatic/entity/jellyfish/HybridAquaticJellyfishEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/jellyfish/HybridAquaticJellyfishEntity;)V", "canUse", "", "tick", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class SwimGoal
    extends Goal {
        @NotNull
        private final HybridAquaticJellyfishEntity jellyfish;

        public SwimGoal(@NotNull HybridAquaticJellyfishEntity jellyfish) {
            Intrinsics.checkNotNullParameter((Object)((Object)jellyfish), (String)"jellyfish");
            this.jellyfish = jellyfish;
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            int i = this.jellyfish.noActionTime;
            if (i > 100) {
                this.jellyfish.setSwimmingVector(0.0f, 0.0f, 0.0f);
            } else if (this.jellyfish.random.nextInt(Goal.reducedTickDelay((int)50)) == 0 || !this.jellyfish.wasTouchingWater || !this.jellyfish.hasSwimmingVector()) {
                float f = this.jellyfish.random.nextFloat() * ((float)Math.PI * 2);
                float g = Mth.cos((float)f) * 0.2f;
                float h = -0.1f + this.jellyfish.random.nextFloat() * 0.2f;
                float j = Mth.sin((float)f) * 0.2f;
                this.jellyfish.setSwimmingVector(g, h, j);
            }
        }
    }
}

