/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.miniboss;

import dev.hybridlabs.aquatic.entity.miniboss.HybridAquaticMinionEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016\u00a8\u0006\u0016"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarcinogenEntity;", "Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinionEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "getHurtSound", "Lnet/minecraft/sounds/SoundEvent;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "maxUpStep", "", "isAffectedByFluids", "", "isPushedByFluid", "tick", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class KarcinogenEntity
extends HybridAquaticMinionEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KarcinogenEntity(@NotNull EntityType<? extends HybridAquaticMinionEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this);
        this.lookControl = new LookControl((Mob)this);
        this.navigation = (PathNavigation)new GroundPathNavigation((Mob)this, world);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        super.registerGoals();
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.TURTLE_EGG_CRACK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_CRACK");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.TURTLE_EGG_BREAK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_BREAK");
        return soundEvent;
    }

    public float maxUpStep() {
        return 1.0f;
    }

    protected boolean isAffectedByFluids() {
        return false;
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isInWater() && !this.onGround()) {
            this.setSwimming(false);
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.1, 0.0));
            this.navigation.stop();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarcinogenEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = Monster.createLivingAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.6).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FOLLOW_RANGE, 16.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

