/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.miniboss;

import dev.hybridlabs.aquatic.entity.HybridAquaticEntityTypes;
import dev.hybridlabs.aquatic.entity.ai.goal.KarkinosMeleeAttackGoal;
import dev.hybridlabs.aquatic.entity.ai.goal.KarkinosSummonGoal;
import dev.hybridlabs.aquatic.entity.miniboss.HybridAquaticMinibossEntity;
import dev.hybridlabs.aquatic.entity.miniboss.KarcinogenEntity;
import dev.hybridlabs.aquatic.entity.miniboss.KarcinomaEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 C2\u00020\u0001:\u0002CDB\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0014J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0016J\u0006\u0010#\u001a\u00020\u0014J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0006\u0010&\u001a\u00020\u0014J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0014H\u0002J\u0006\u0010)\u001a\u00020\u0019J\u0006\u0010*\u001a\u00020\u0019J\b\u0010+\u001a\u00020\u0019H\u0002J\b\u0010,\u001a\u00020\u0019H\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0014J\u0010\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0016J\b\u00104\u001a\u00020\u0019H\u0016J\b\u00105\u001a\u00020\u0019H\u0016J\u0018\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0012H\u0016J\u0012\u0010:\u001a\u00020\u00192\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0010\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u00107\u001a\u000208H\u0014J\b\u0010B\u001a\u00020AH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity;", "Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinibossEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "flippedTimer", "", "flippedCooldown", "summonTimer", "summonCooldown", "getSummonCooldown", "()I", "setSummonCooldown", "(I)V", "maxUpStep", "", "isAffectedByFluids", "", "isPushedByFluid", "bossBar", "Lnet/minecraft/server/level/ServerBossEvent;", "registerGoals", "", "getHandSwingDuration", "updateSwingTime", "getAttackAnim", "tickDelta", "startSeenByPlayer", "player", "Lnet/minecraft/server/level/ServerPlayer;", "stopSeenByPlayer", "checkDespawn", "isFlipped", "setFlipped", "flipped", "isSummoning", "setSummoning", "summon", "startSummoning", "stopSummoning", "summonKarcinogens", "summonKarcinomas", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "tick", "aiStep", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "setCustomName", "name", "Lnet/minecraft/network/chat/Component;", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getHurtSound", "Lnet/minecraft/sounds/SoundEvent;", "getDeathSound", "Companion", "KarkinosMoveControl", "hybrid-aquatic-neoforge-1.21.1"})
public final class KarkinosEntity
extends HybridAquaticMinibossEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int flippedTimer;
    private int flippedCooldown;
    private int summonTimer;
    private int summonCooldown;
    @NotNull
    private ServerBossEvent bossBar;
    @NotNull
    private static final RawAnimation FLIP_ANIMATION;
    @NotNull
    private static final RawAnimation SUMMON_ANIMATION;
    @NotNull
    private static final EntityDataAccessor<Boolean> FLIPPED;
    @NotNull
    private static final EntityDataAccessor<Boolean> SUMMONING;

    public KarkinosEntity(@NotNull EntityType<? extends HybridAquaticMinibossEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new KarkinosMoveControl(this);
        this.navigation = (PathNavigation)new GroundPathNavigation((Mob)this, world);
        this.lookControl = new LookControl((Mob)this);
        Component component = this.getDisplayName();
        Intrinsics.checkNotNull((Object)component);
        this.bossBar = new ServerBossEvent(component, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20);
    }

    public final int getSummonCooldown() {
        return this.summonCooldown;
    }

    public final void setSummonCooldown(int n) {
        this.summonCooldown = n;
    }

    public float maxUpStep() {
        return 1.5f;
    }

    protected boolean isAffectedByFluids() {
        return false;
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new KarkinosSummonGoal(this));
        this.goalSelector.addGoal(2, (Goal)new KarkinosMeleeAttackGoal(this, 0.5, true));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, null));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 10, true, true, null));
    }

    private final int getHandSwingDuration() {
        return 40;
    }

    protected void updateSwingTime() {
        int i = this.getHandSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= i) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)i;
    }

    public float getAttackAnim(float tickDelta) {
        float f = this.attackAnim - this.oAttackAnim;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.oAttackAnim + f * tickDelta;
    }

    public void startSeenByPlayer(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.startSeenByPlayer(player);
        this.bossBar.addPlayer(player);
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.stopSeenByPlayer(player);
        this.bossBar.removePlayer(player);
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        } else {
            this.noActionTime = 0;
        }
    }

    public final boolean isFlipped() {
        Object object = this.entityData.get(FLIPPED);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setFlipped(boolean flipped) {
        if (flipped && this.getHealth() <= this.getMaxHealth() / 2.0f) {
            return;
        }
        this.entityData.set(FLIPPED, (Object)flipped);
    }

    public final boolean isSummoning() {
        Object object = this.entityData.get(SUMMONING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setSummoning(boolean summon) {
        this.entityData.set(SUMMONING, (Object)summon);
    }

    public final void startSummoning() {
        this.setSummoning(true);
        this.playSound(SoundEvents.EVOKER_PREPARE_ATTACK, 1.0f, 1.0f);
        this.summonTimer = 30;
        this.summonCooldown = 240;
        this.navigation.stop();
    }

    public final void stopSummoning() {
        this.setSummoning(false);
        this.summonTimer = 0;
        this.summonCooldown = 300;
    }

    private final void summonKarcinogens() {
        RandomSource random = this.random;
        int count = 3;
        for (int i = 0; i < count; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 6.0;
            double offsetZ = (random.nextDouble() - 0.5) * 6.0;
            BlockPos spawnPos = this.blockPosition().offset((int)offsetX, 0, (int)offsetZ);
            KarcinogenEntity karcinogen = (KarcinogenEntity)HybridAquaticEntityTypes.INSTANCE.getKARCINOGEN().get().create(this.level());
            if (karcinogen == null) continue;
            karcinogen.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            karcinogen.setOwner((Mob)this);
            karcinogen.setLimitedLife(200);
            this.level().addFreshEntity((Entity)karcinogen);
        }
    }

    private final void summonKarcinomas() {
        RandomSource random = this.random;
        int count = 3;
        for (int i = 0; i < count; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 6.0;
            double offsetZ = (random.nextDouble() - 0.5) * 6.0;
            BlockPos spawnPos = this.blockPosition().offset((int)offsetX, 0, (int)offsetZ);
            KarcinomaEntity karcinoma = (KarcinomaEntity)HybridAquaticEntityTypes.INSTANCE.getKARCINOMA().get().create(this.level());
            if (karcinoma == null) continue;
            karcinoma.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            karcinoma.setOwner((Mob)this);
            karcinoma.setLimitedLife(400);
            this.level().addFreshEntity((Entity)karcinoma);
        }
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(FLIPPED, (Object)false);
        builder.define(SUMMONING, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.putBoolean("Flipped", this.isFlipped());
        nbt.putBoolean("Summoning", this.isSummoning());
        nbt.putInt("SummonTimer", this.summonTimer);
        nbt.putInt("SummonCooldown", this.summonCooldown);
        super.addAdditionalSaveData(nbt);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (this.hasCustomName()) {
            Component component = this.getDisplayName();
            Intrinsics.checkNotNull((Object)component);
            this.bossBar.setName(component);
        }
        this.setFlipped(nbt.getBoolean("Flipped"));
        this.setSummoning(nbt.getBoolean("Summoning"));
        this.summonTimer = nbt.getInt("SummonTimer");
        this.summonCooldown = nbt.getInt("SummonCooldown");
        super.readAdditionalSaveData(nbt);
    }

    public void tick() {
        super.tick();
        if (this.isInWater() && !this.onGround()) {
            this.setSwimming(false);
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.1, 0.0));
            this.navigation.stop();
        }
    }

    @Override
    public void aiStep() {
        int n;
        if (!this.level().isClientSide && this.isEffectiveAi()) {
            if (this.isFlipped()) {
                this.flippedTimer += -1;
                if (this.flippedTimer <= 0) {
                    this.setFlipped(false);
                } else {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 0.0, 0.0));
                    this.yHeadRot = 0.0f;
                }
            }
            if (this.flippedCooldown > 0) {
                n = this.flippedCooldown;
                this.flippedCooldown = n + -1;
            }
        }
        if (this.summonCooldown > 0) {
            n = this.summonCooldown;
            this.summonCooldown = n + -1;
        }
        if (this.isSummoning()) {
            n = this.summonTimer;
            this.summonTimer = n + -1;
            if (this.summonTimer == 0) {
                if (this.isUnderWater()) {
                    this.summonKarcinomas();
                    this.summonKarcinogens();
                } else {
                    this.summonKarcinogens();
                }
                this.stopSummoning();
            }
        }
        this.bossBar.setProgress(this.getHealth() / this.getMaxHealth());
        super.aiStep();
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean result = super.hurt(source, amount);
        if (result && !this.level().isClientSide && source.getDirectEntity() instanceof Player && !this.isFlipped() && this.flippedCooldown <= 0 && this.getHealth() > this.getMaxHealth() / 2.0f) {
            boolean hasFlipEnchant;
            Entity entity = source.getDirectEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            ItemStack weapon = player.getMainHandItem();
            boolean bl = hasFlipEnchant = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)((Registry)this.level().registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(Enchantments.BANE_OF_ARTHROPODS).get()), (ItemStack)weapon) > 1 || EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)((Registry)this.level().registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(Enchantments.RIPTIDE).get()), (ItemStack)weapon) > 1;
            if (hasFlipEnchant) {
                this.flippedTimer = this.random.nextInt(60, 100);
                this.flippedCooldown = 200;
                this.setFlipped(true);
            }
        }
        return result;
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        Component component = this.getDisplayName();
        Intrinsics.checkNotNull((Object)component);
        this.bossBar.setName(component);
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "flip_controller", 8, arg_0 -> KarkinosEntity.registerControllers$lambda$0(this, arg_0)));
        controllers.add(new AnimationController((GeoAnimatable)this, "summon_controller", 4, arg_0 -> KarkinosEntity.registerControllers$lambda$1(this, arg_0)));
        controllers.add(DefaultAnimations.genericWalkRunIdleController((Entity)((Entity)this)));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)((LivingEntity)this), (RawAnimation)DefaultAnimations.ATTACK_SWING));
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.TURTLE_EGG_CRACK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_CRACK");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.TURTLE_EGG_BREAK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_BREAK");
        return soundEvent;
    }

    private static final PlayState registerControllers$lambda$0(KarkinosEntity this$0, AnimationState state) {
        PlayState playState;
        if (this$0.isFlipped()) {
            state.setAndContinue(FLIP_ANIMATION);
            playState = PlayState.CONTINUE;
        } else {
            playState = PlayState.STOP;
        }
        return playState;
    }

    private static final PlayState registerControllers$lambda$1(KarkinosEntity this$0, AnimationState state) {
        PlayState playState;
        if (this$0.isSummoning()) {
            state.setAndContinue(SUMMON_ANIMATION);
            playState = PlayState.CONTINUE;
        } else {
            playState = PlayState.STOP;
        }
        return playState;
    }

    static {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.flip");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        FLIP_ANIMATION = rawAnimation;
        RawAnimation rawAnimation2 = RawAnimation.begin().thenPlay("misc.summon");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation2, (String)"thenPlay(...)");
        SUMMON_ANIMATION = rawAnimation2;
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(KarkinosEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        FLIPPED = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(KarkinosEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        SUMMONING = entityDataAccessor2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity$Companion;", "", "<init>", "()V", "FLIP_ANIMATION", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getFLIP_ANIMATION", "()Lsoftware/bernie/geckolib/animation/RawAnimation;", "SUMMON_ANIMATION", "getSUMMON_ANIMATION", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "FLIPPED", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getFLIPPED", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "SUMMONING", "getSUMMONING", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RawAnimation getFLIP_ANIMATION() {
            return FLIP_ANIMATION;
        }

        @NotNull
        public final RawAnimation getSUMMON_ANIMATION() {
            return SUMMON_ANIMATION;
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = Monster.createLivingAttributes().add(Attributes.MAX_HEALTH, 400.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getFLIPPED() {
            return FLIPPED;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getSUMMONING() {
            return SUMMONING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity$KarkinosMoveControl;", "Lnet/minecraft/world/entity/ai/control/MoveControl;", "karkinos", "Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity;)V", "tick", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class KarkinosMoveControl
    extends MoveControl {
        @NotNull
        private final KarkinosEntity karkinos;

        public KarkinosMoveControl(@NotNull KarkinosEntity karkinos) {
            Intrinsics.checkNotNullParameter((Object)((Object)karkinos), (String)"karkinos");
            super((Mob)karkinos);
            this.karkinos = karkinos;
        }

        public void tick() {
            if (!this.karkinos.isFlipped() && !this.karkinos.isSummoning()) {
                super.tick();
            }
        }
    }
}

