/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.shark;

import dev.hybridlabs.aquatic.effect.HybridAquaticMobEffects;
import dev.hybridlabs.aquatic.entity.ai.goal.SharkAttackGoal;
import dev.hybridlabs.aquatic.entity.ai.goal.boids.StayInWaterGoal;
import dev.hybridlabs.aquatic.entity.cephalopod.HybridAquaticCephalopodEntity;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.entity.mammal.HybridAquaticMammalEntity;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 o2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001oBG\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0007H\u0014J\b\u00100\u001a\u000201H\u0014J,\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u0006\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u000103H\u0016J\b\u0010:\u001a\u00020\fH\u0016J\b\u0010;\u001a\u000201H\u0016J\u0010\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020\u001dH\u0016J\u0010\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u0002012\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010D\u001a\u0002012\u0006\u0010E\u001a\u00020FH\u0014J\u0010\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u000201H\u0016J\b\u0010K\u001a\u00020\u001dH\u0016J\b\u0010L\u001a\u00020\u001dH\u0016J\b\u0010P\u001a\u00020\u001dH\u0014J\b\u0010Q\u001a\u00020\u001dH\u0014J\u0010\u0010R\u001a\u0002012\u0006\u0010S\u001a\u00020\u001dH\u0014J\b\u0010T\u001a\u00020\u001dH\u0002J\u0010\u0010U\u001a\u0002012\u0006\u0010V\u001a\u00020WH\u0016J\b\u0010X\u001a\u00020\u001aH\u0016J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0014J\b\u0010]\u001a\u00020ZH\u0014J\b\u0010^\u001a\u00020\u001dH\u0016J\u0010\u0010_\u001a\u0002012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010`\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010a\u001a\u0002012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010b\u001a\u000201H\u0016J\u0010\u0010c\u001a\u00020\f2\u0006\u0010d\u001a\u00020eH\u0002J\u0018\u0010f\u001a\u0002012\u0006\u0010[\u001a\u00020\\2\u0006\u0010g\u001a\u00020\fH\u0014J\b\u0010h\u001a\u00020\u001dH\u0002J\b\u0010i\u001a\u000201H\u0014J\u0010\u0010j\u001a\u00020\u00112\u0006\u0010k\u001a\u00020\u0011H\u0016J\u0010\u0010l\u001a\u00020\f2\u0006\u0010m\u001a\u00020nH\u0016R\u001e\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R$\u0010%\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010*\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001d8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R$\u0010M\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bN\u0010'\"\u0004\bO\u0010)\u00a8\u0006p"}, d2={"Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "Lnet/minecraft/world/entity/NeutralMob;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "prey", "", "Lnet/minecraft/tags/TagKey;", "isPassive", "", "closePlayerAttack", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Ljava/util/List;ZZ)V", "prevRoll", "", "getPrevRoll", "()F", "setPrevRoll", "(F)V", "currentRoll", "getCurrentRoll", "setCurrentRoll", "factory", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "angerTime", "", "angryAt", "Ljava/util/UUID;", "fromFishingNet", "getFromFishingNet", "()Z", "setFromFishingNet", "(Z)V", "hunger", "getHunger", "()I", "setHunger", "(I)V", "moistness", "getMoistness", "setMoistness", "createNavigation", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "level", "registerGoals", "", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "isPushedByFluid", "tick", "removeWhenFarAway", "distanceSquared", "", "getMaxSpawnClusterSize", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "travel", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "aiStep", "getMaxHeadXRot", "getMaxHeadYRot", "size", "getSize", "setSize", "getMinSize", "getMaxSize", "handleAirSupply", "air", "getMaxMoistness", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "getHurtSound", "Lnet/minecraft/sounds/SoundEvent;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "getRemainingPersistentAngerTime", "setRemainingPersistentAngerTime", "getPersistentAngerTarget", "setPersistentAngerTarget", "startPersistentAngerTimer", "shouldProximityAttack", "player", "Lnet/minecraft/world/entity/player/Player;", "dropFromLootTable", "causedByPlayer", "getHandSwingDuration", "updateSwingTime", "getAttackAnim", "tickDelta", "doHurtTarget", "entity", "Lnet/minecraft/world/entity/Entity;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nHybridAquaticSharkEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquaticSharkEntity.kt\ndev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,412:1\n1761#2,3:413\n*S KotlinDebug\n*F\n+ 1 HybridAquaticSharkEntity.kt\ndev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity\n*L\n94#1:413,3\n*E\n"})
public class HybridAquaticSharkEntity
extends WaterAnimal
implements NeutralMob,
GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TagKey<EntityType<?>>> prey;
    private final boolean isPassive;
    private final boolean closePlayerAttack;
    private float prevRoll;
    private float currentRoll;
    private final AnimatableInstanceCache factory;
    private int angerTime;
    @Nullable
    private UUID angryAt;
    private boolean fromFishingNet;
    @NotNull
    public static final String MOISTNESS_KEY = "Moistness";
    @NotNull
    public static final String SHARK_SIZE_KEY = "SharkSize";
    public static final int MAX_HUNGER = 2400;
    @NotNull
    public static final String HUNGER_KEY = "Hunger";
    @NotNull
    private static final EntityDataAccessor<Integer> SHARK_SIZE;
    @NotNull
    private static final EntityDataAccessor<Integer> MOISTNESS;
    @NotNull
    private static final EntityDataAccessor<Integer> HUNGER;
    @NotNull
    private static final EntityDataAccessor<Boolean> ATTEMPT_ATTACK;
    @NotNull
    private static final UniformInt ANGER_TIME_RANGE;
    @NotNull
    private static final RawAnimation BEACHED_ANIMATION;

    public HybridAquaticSharkEntity(@NotNull EntityType<? extends HybridAquaticSharkEntity> entityType, @NotNull Level world, @NotNull List<TagKey<EntityType<?>>> prey, boolean isPassive, boolean closePlayerAttack) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(prey, (String)"prey");
        super(entityType, world);
        this.prey = prey;
        this.isPassive = isPassive;
        this.closePlayerAttack = closePlayerAttack;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.moveControl = (MoveControl)new SmoothSwimmingMoveControl((Mob)this, 45, 3, 0.02f, 0.1f, false);
        this.lookControl = (LookControl)new SmoothSwimmingLookControl((Mob)this, 15);
        this.navigation = (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    public final float getPrevRoll() {
        return this.prevRoll;
    }

    public final void setPrevRoll(float f) {
        this.prevRoll = f;
    }

    public final float getCurrentRoll() {
        return this.currentRoll;
    }

    public final void setCurrentRoll(float f) {
        this.currentRoll = f;
    }

    public final boolean getFromFishingNet() {
        return this.fromFishingNet;
    }

    public final void setFromFishingNet(boolean bl) {
        this.fromFishingNet = bl;
    }

    public final int getHunger() {
        Object object = this.entityData.get(HUNGER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setHunger(int hunger) {
        this.entityData.set(HUNGER, (Object)hunger);
    }

    private final int getMoistness() {
        Object object = this.entityData.get(MOISTNESS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setMoistness(int moistness) {
        this.entityData.set(MOISTNESS, (Object)moistness);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return (PathNavigation)new WaterBoundPathNavigation((Mob)this, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new StayInWaterGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 2));
        this.goalSelector.addGoal(0, (Goal)new SharkAttackGoal(this, 1.1, true));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, arg_0 -> HybridAquaticSharkEntity.registerGoals$lambda$0(this, arg_0)));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, arg_0 -> HybridAquaticSharkEntity.registerGoals$lambda$1(this, arg_0)));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, arg_0 -> HybridAquaticSharkEntity.registerGoals$lambda$2(this, arg_0)));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        this.setSize(this.random.nextIntBetweenInclusive(this.getMinSize(), this.getMaxSize()));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void tick() {
        super.tick();
        this.prevRoll = this.currentRoll;
        if (this.isUnderWater()) {
            this.setMoistness(this.getMaxMoistness());
        } else {
            this.setMoistness(this.getMoistness() - 1);
            if (this.getMoistness() <= -20) {
                this.setMoistness(0);
                this.hurt(this.damageSources().dryOut(), 2.0f);
                this.setXRot(0.0f);
                this.setYRot(0.0f);
            }
        }
        if (this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromFishingNet && !this.hasCustomName();
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.addAdditionalSaveData(nbt);
        this.addPersistentAngerSaveData(nbt);
        nbt.putInt(MOISTNESS_KEY, this.getMoistness());
        nbt.putInt(HUNGER_KEY, this.getHunger());
        nbt.putInt(SHARK_SIZE_KEY, this.getSize());
        nbt.putBoolean("FromFishingNet", this.fromFishingNet);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readAdditionalSaveData(nbt);
        this.readPersistentAngerSaveData(this.level(), nbt);
        this.setMoistness(nbt.getInt(MOISTNESS_KEY));
        this.setHunger(nbt.getInt(HUNGER_KEY));
        this.setSize(nbt.getInt(SHARK_SIZE_KEY));
        this.fromFishingNet = nbt.getBoolean("FromFishingNet");
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(MOISTNESS, (Object)this.getMaxMoistness());
        builder.define(SHARK_SIZE, (Object)0);
        builder.define(HUNGER, (Object)2400);
        builder.define(ATTEMPT_ATTACK, (Object)false);
    }

    public void travel(@NotNull Vec3 travelVector) {
        Intrinsics.checkNotNullParameter((Object)travelVector, (String)"travelVector");
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    public void aiStep() {
        this.updateSwingTime();
        this.prevRoll = this.currentRoll;
        float targetRoll = RangesKt.coerceIn((float)((this.getYRot() - this.yRotO) * 0.1f), (float)-0.45f, (float)0.45f);
        targetRoll = -targetRoll;
        this.currentRoll += (targetRoll - this.currentRoll) * 0.05f;
        super.aiStep();
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    public final int getSize() {
        Object object = this.entityData.get(SHARK_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setSize(int size) {
        this.entityData.set(SHARK_SIZE, (Object)size);
    }

    protected int getMinSize() {
        return -3;
    }

    protected int getMaxSize() {
        return 0;
    }

    protected void handleAirSupply(int air) {
    }

    private final int getMaxMoistness() {
        return 1200;
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "Shark Controller", 8, arg_0 -> HybridAquaticSharkEntity.registerControllers$lambda$0(this, arg_0)));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)((LivingEntity)this), (RawAnimation)DefaultAnimations.ATTACK_BITE));
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.COD_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"COD_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.COD_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"COD_DEATH");
        return soundEvent;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    public void setPersistentAngerTarget(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    private final boolean shouldProximityAttack(Player player) {
        Component component = this.getCustomName();
        if (Intrinsics.areEqual((Object)(component != null ? component.getString() : null), (Object)"friend")) {
            return false;
        }
        return this.closePlayerAttack && player.distanceToSqr((Entity)this) <= 8.0 && !player.isCreative();
    }

    protected void dropFromLootTable(@NotNull DamageSource source, boolean causedByPlayer) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Entity attacker = source.getDirectEntity();
        if (!(attacker instanceof HybridAquaticFishEntity || attacker instanceof HybridAquaticSharkEntity || attacker instanceof HybridAquaticCephalopodEntity || attacker instanceof HybridAquaticMammalEntity)) {
            super.dropFromLootTable(source, causedByPlayer);
        }
    }

    private final int getHandSwingDuration() {
        return 40;
    }

    protected void updateSwingTime() {
        int i = this.getHandSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= i) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)i;
    }

    public float getAttackAnim(float tickDelta) {
        float f = this.attackAnim - this.oAttackAnim;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.oAttackAnim + f * tickDelta;
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        LivingEntity livingEntity = this.getTarget();
        Intrinsics.checkNotNull((Object)livingEntity);
        if (super.doHurtTarget((Entity)livingEntity)) {
            this.playSound(SoundEvents.FOX_BITE, 1.0f, 0.0f);
            return true;
        }
        return false;
    }

    private static final boolean registerGoals$lambda$0(HybridAquaticSharkEntity this$0, LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this$0.isAngryAt(entity) || this$0.shouldProximityAttack((Player)entity) && !this$0.isPassive;
    }

    private static final boolean registerGoals$lambda$1(HybridAquaticSharkEntity this$0, LivingEntity it) {
        return it.hasEffect(HybridAquaticMobEffects.INSTANCE.getBLEEDING().asHolder()) && !(it instanceof HybridAquaticSharkEntity) && !this$0.isPassive;
    }

    private static final boolean registerGoals$lambda$2(HybridAquaticSharkEntity this$0, LivingEntity entity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Iterable $this$any$iv = this$0.prey;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey preyType = (TagKey)element$iv;
                    boolean bl2 = false;
                    if (!entity.getType().is(preyType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && this$0.getHunger() < 600;
    }

    private static final PlayState registerControllers$lambda$0(HybridAquaticSharkEntity this$0, AnimationState state) {
        return this$0.isInWater() ? state.setAndContinue(this$0.isSprinting() && state.isMoving() ? DefaultAnimations.RUN : DefaultAnimations.SWIM) : (this$0.onGround() ? state.setAndContinue(BEACHED_ANIMATION) : state.setAndContinue(DefaultAnimations.SWIM));
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(HybridAquaticSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        SHARK_SIZE = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(HybridAquaticSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        MOISTNESS = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(HybridAquaticSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        HUNGER = entityDataAccessor3;
        EntityDataAccessor entityDataAccessor4 = SynchedEntityData.defineId(HybridAquaticSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor4, (String)"defineId(...)");
        ATTEMPT_ATTACK = entityDataAccessor4;
        UniformInt uniformInt = TimeUtil.rangeOfSeconds((int)10, (int)30);
        Intrinsics.checkNotNullExpressionValue((Object)uniformInt, (String)"rangeOfSeconds(...)");
        ANGER_TIME_RANGE = uniformInt;
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.beached");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        BEACHED_ANIMATION = rawAnimation;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u001d\u001a\u00020\u00132\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J6\u0010)\u001a\u00020\u00132\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J6\u0010*\u001a\u00020\u00132\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020,R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00060"}, d2={"Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity$Companion;", "", "<init>", "()V", "MOISTNESS_KEY", "", "SHARK_SIZE_KEY", "MAX_HUNGER", "", "HUNGER_KEY", "SHARK_SIZE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getSHARK_SIZE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "MOISTNESS", "getMOISTNESS", "HUNGER", "getHUNGER", "ATTEMPT_ATTACK", "", "getATTEMPT_ATTACK", "ANGER_TIME_RANGE", "Lnet/minecraft/util/valueproviders/UniformInt;", "getANGER_TIME_RANGE", "()Lnet/minecraft/util/valueproviders/UniformInt;", "BEACHED_ANIMATION", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getBEACHED_ANIMATION", "()Lsoftware/bernie/geckolib/animation/RawAnimation;", "canShallowSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "canSpawn", "canDeepSpawn", "getScaleAdjustment", "", "shark", "Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;", "adjustment", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getSHARK_SIZE() {
            return SHARK_SIZE;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getMOISTNESS() {
            return MOISTNESS;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getHUNGER() {
            return HUNGER;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getATTEMPT_ATTACK() {
            return ATTEMPT_ATTACK;
        }

        @NotNull
        public final UniformInt getANGER_TIME_RANGE() {
            return ANGER_TIME_RANGE;
        }

        @NotNull
        public final RawAnimation getBEACHED_ANIMATION() {
            return BEACHED_ANIMATION;
        }

        public final boolean canShallowSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel() - 2;
            int bottomY = world.getSeaLevel() - 6;
            int n = pos.getY();
            return (bottomY <= n ? n <= topY : false) && world.isWaterAt(pos) && world.canSeeSkyFromBelowWater(pos);
        }

        public final boolean canSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel() - 8;
            int bottomY = world.getSeaLevel() - 24;
            int n = pos.getY();
            return (bottomY <= n ? n <= topY : false) && world.isWaterAt(pos);
        }

        public final boolean canDeepSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel() - 48;
            int bottomY = world.getSeaLevel() - 128;
            int n = pos.getY();
            return (bottomY <= n ? n <= topY : false) && world.isWaterAt(pos) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
        }

        public final float getScaleAdjustment(@NotNull HybridAquaticSharkEntity shark, float adjustment) {
            Intrinsics.checkNotNullParameter((Object)((Object)shark), (String)"shark");
            return 1.0f + (float)shark.getSize() * adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

