/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.shark;

import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/hybridlabs/aquatic/entity/shark/TigerSharkEntity;", "Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "burpTimer", "", "burpPending", "", "tick", "", "dropBurpItem", "killedEntity", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/world/entity/LivingEntity;", "registerGoals", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class TigerSharkEntity
extends HybridAquaticSharkEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int burpTimer;
    private boolean burpPending;

    public TigerSharkEntity(@NotNull EntityType<? extends TigerSharkEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Object[] objectArray = new TagKey[]{HybridAquaticEntityTags.INSTANCE.getCEPHALOPOD(), HybridAquaticEntityTags.INSTANCE.getCRUSTACEAN(), HybridAquaticEntityTags.INSTANCE.getMEDIUM_PREY()};
        super(entityType, world, CollectionsKt.listOf((Object[])objectArray), false, false);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.burpPending && this.burpTimer > 0) {
            int n = this.burpTimer;
            this.burpTimer = n + -1;
            if (this.burpTimer == 0) {
                this.dropBurpItem();
                this.burpPending = false;
            }
        }
    }

    private final void dropBurpItem() {
        if (!this.level().isClientSide) {
            Object[] objectArray = new ItemStack[]{new ItemStack((ItemLike)Items.LEATHER_BOOTS), new ItemStack((ItemLike)Items.GLASS_BOTTLE), new ItemStack((ItemLike)Items.TURTLE_SCUTE), new ItemStack((ItemLike)Items.NAUTILUS_SHELL), new ItemStack((ItemLike)Items.SKELETON_SKULL), new ItemStack((ItemLike)Items.BONE), new ItemStack((ItemLike)Items.PRISMARINE_CRYSTALS), new ItemStack((ItemLike)Items.PRISMARINE_SHARD), new ItemStack((ItemLike)Items.BRUSH), new ItemStack((ItemLike)Items.NAME_TAG), new ItemStack((ItemLike)Items.COMPASS), new ItemStack((ItemLike)Items.CLOCK), new ItemStack((ItemLike)Items.SPYGLASS), new ItemStack((ItemLike)Items.SADDLE), new ItemStack((ItemLike)HybridAquaticItems.INSTANCE.getSHARK_TOOTH().get()), new ItemStack((ItemLike)HybridAquaticItems.INSTANCE.getCUTTLEBONE().get()), new ItemStack((ItemLike)HybridAquaticItems.INSTANCE.getGLOWING_HOOK().get()), new ItemStack((ItemLike)HybridAquaticItems.INSTANCE.getBARBED_HOOK().get())};
            List itemsToDrop = CollectionsKt.listOf((Object[])objectArray);
            ItemStack randomItem = (ItemStack)CollectionsKt.random((Collection)itemsToDrop, (Random)((Random)Random.Default));
            this.spawnAtLocation(randomItem);
            this.playSound(SoundEvents.PLAYER_BURP, 1.0f, 1.0f);
        }
    }

    public boolean killedEntity(@NotNull ServerLevel world, @NotNull LivingEntity killedEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)killedEntity, (String)"killedEntity");
        boolean result = super.killedEntity(world, killedEntity);
        this.burpTimer = 60;
        this.burpPending = true;
        return result;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/hybridlabs/aquatic/entity/shark/TigerSharkEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.createLivingAttributes().add(Attributes.MAX_HEALTH, 54.0).add(Attributes.MOVEMENT_SPEED, 0.75).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FOLLOW_RANGE, 16.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

