/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.loot.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hybridlabs.aquatic.block.MessageInABottleBlock;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import dev.hybridlabs.aquatic.loot.entry.HybridAquaticLootPoolEntryTypes;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Ldev/hybridlabs/aquatic/loot/entry/MessageInABottleItemEntry;", "Lnet/minecraft/world/level/storage/loot/entries/LootPoolSingletonContainer;", "weight", "", "quality", "conditions", "", "Lnet/minecraft/world/level/storage/loot/predicates/LootItemCondition;", "functions", "Lnet/minecraft/world/level/storage/loot/functions/LootItemFunction;", "<init>", "(IILjava/util/List;Ljava/util/List;)V", "getType", "Lnet/minecraft/world/level/storage/loot/entries/LootPoolEntryType;", "createItemStack", "", "consumer", "Ljava/util/function/Consumer;", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/level/storage/loot/LootContext;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class MessageInABottleItemEntry
extends LootPoolSingletonContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<MessageInABottleItemEntry> CODEC;

    public MessageInABottleItemEntry(int weight, int quality, @NotNull List<? extends LootItemCondition> conditions, @NotNull List<? extends LootItemFunction> functions) {
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        super(weight, quality, conditions, functions);
    }

    @NotNull
    public LootPoolEntryType getType() {
        LootPoolEntryType lootPoolEntryType = HybridAquaticLootPoolEntryTypes.INSTANCE.getMESSAGE_IN_A_BOTTLE().get();
        Intrinsics.checkNotNullExpressionValue((Object)lootPoolEntryType, (String)"get(...)");
        return lootPoolEntryType;
    }

    public void createItemStack(@NotNull Consumer<ItemStack> consumer, @NotNull LootContext context) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ServerLevel world = context.getLevel();
        RandomSource random = context.getRandom();
        RegistryAccess registryManager = world.registryAccess();
        Registry registry = registryManager.registryOrThrow(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE());
        registry.getRandom(random).ifPresent(arg_0 -> MessageInABottleItemEntry.createItemStack$lambda$1(arg_0 -> MessageInABottleItemEntry.createItemStack$lambda$0(consumer, random, arg_0), arg_0));
    }

    private static final Unit createItemStack$lambda$0(Consumer $consumer, RandomSource $random, Holder.Reference messageEntry) {
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)messageEntry, (String)"messageEntry");
        ItemStack stack = new ItemStack((ItemLike)HybridAquaticItems.INSTANCE.getMESSAGE_IN_A_BOTTLE().get());
        CompoundTag $this$createItemStack_u24lambda_u240_u240 = compoundTag = new CompoundTag();
        boolean bl = false;
        EnumEntries<MessageInABottleBlock.Variant> variants = MessageInABottleBlock.Variant.getEntries();
        $this$createItemStack_u24lambda_u240_u240.putString("variant", ((MessageInABottleBlock.Variant)((Object)variants.get($random.nextInt(variants.size())))).getId());
        $this$createItemStack_u24lambda_u240_u240.putString("message", messageEntry.key().location().toString());
        CompoundTag stuff = compoundTag;
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stuff));
        $consumer.accept(stack);
        return Unit.INSTANCE;
    }

    private static final void createItemStack$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance inst) {
        return LootPoolSingletonContainer.singletonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, MessageInABottleItemEntry::new);
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(MessageInABottleItemEntry::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Ldev/hybridlabs/aquatic/loot/entry/MessageInABottleItemEntry$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/hybridlabs/aquatic/loot/entry/MessageInABottleItemEntry;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "builder", "Lnet/minecraft/world/level/storage/loot/entries/LootPoolSingletonContainer$Builder;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<MessageInABottleItemEntry> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final LootPoolSingletonContainer.Builder<?> builder() {
            LootPoolSingletonContainer.Builder builder = LootPoolSingletonContainer.simpleBuilder(MessageInABottleItemEntry::new);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"simpleBuilder(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

