/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.mixin;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.hybridlabs.aquatic.access.CustomFishingBobberEntityData;
import dev.hybridlabs.aquatic.entity.HybridAquaticEntityTypes;
import dev.hybridlabs.aquatic.entity.miniboss.KarkinosEntity;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public abstract class FishingBobberEntityMixin
extends Entity
implements CustomFishingBobberEntityData {
    @Shadow
    private int timeUntilLured;
    @Unique
    private ItemStack lureItemStack = Items.AIR.getDefaultInstance();

    @Shadow
    public abstract Player getPlayerOwner();

    private FishingBobberEntityMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        this.hybrid_aquatic$setLureItem(ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)nbt.getCompound("lureItem")));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        CompoundTag itemStack = new CompoundTag();
        this.hybrid_aquatic$getLureItem().save((HolderLookup.Provider)this.level().registryAccess(), (Tag)itemStack);
        nbt.put("lureItem", (Tag)itemStack);
    }

    @Override
    public ItemStack hybrid_aquatic$getLureItem() {
        return this.lureItemStack;
    }

    @Override
    public void hybrid_aquatic$setLureItem(ItemStack item) {
        this.lureItemStack = item == null ? Items.AIR.getDefaultInstance() : item;
    }

    @Inject(method={"catchingFish"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I", ordinal=2, shift=At.Shift.AFTER)})
    private void reduceCooldownTime(BlockPos pos, CallbackInfo ci) {
        Item lureItem = this.lureItemStack.getItem();
        if (lureItem.equals(HybridAquaticItems.INSTANCE.getBARBED_HOOK().get()) && this.level().isDay()) {
            this.timeUntilLured -= 75;
        } else if (lureItem.equals(HybridAquaticItems.INSTANCE.getGLOWING_HOOK().get()) && this.level().isNight()) {
            this.timeUntilLured -= 75;
        }
    }

    @WrapOperation(method={"retrieve"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getLuck()F")})
    private float increaseLuck(Player player, Operation<Float> original) {
        if (this.lureItemStack.getItem().equals(HybridAquaticItems.INSTANCE.getMAGNETIC_HOOK().get())) {
            return player.getLuck() + 27.0f;
        }
        return ((Float)original.call(new Object[]{player})).floatValue();
    }

    @ModifyReceiver(method={"retrieve"}, slice={@Slice(from=@At(value="NEW", target="Lnet/minecraft/world/level/storage/loot/LootParams$Builder;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootTable;getRandomItems(Lnet/minecraft/world/level/storage/loot/LootParams;)Lit/unimi/dsi/fastutil/objects/ObjectArrayList;")})
    private LootTable onHookReelEntity(LootTable instance, LootParams parameters) {
        if (!this.lureItemStack.isEmpty()) {
            if (this.lureItemStack.is(HybridAquaticItems.INSTANCE.getOMINOUS_HOOK().get())) {
                EntityType<KarkinosEntity> karkinosType = HybridAquaticEntityTypes.INSTANCE.getKARKINOS().get();
                this.hybrid_aquatic$createAndLaunchEntityAtPlayer(karkinosType);
                instance = LootTable.EMPTY;
            } else if (this.lureItemStack.is(HybridAquaticItems.INSTANCE.getCREEPERMAGNET_HOOK().get())) {
                EntityType creeperType = EntityType.CREEPER;
                this.hybrid_aquatic$createAndLaunchEntityAtPlayer(creeperType);
                instance = LootTable.EMPTY;
            }
            this.lureItemStack.hurtAndBreak(1, (LivingEntity)this.getPlayerOwner(), EquipmentSlot.MAINHAND);
        }
        return instance;
    }

    @Unique
    private void hybrid_aquatic$createAndLaunchEntityAtPlayer(EntityType<?> entityType) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            Entity entity = entityType.spawn(serverWorld, this.blockPosition(), MobSpawnType.MOB_SUMMONED);
            if (entity == null) {
                return;
            }
            double modifier = 0.15;
            Vec3 vecBetween = this.getPlayerOwner().position().subtract(this.position());
            Vec3 vecBetweenMod = vecBetween.scale(modifier);
            double yOffset = Math.sqrt(Math.sqrt(Math.pow(vecBetween.x, 2.0) + Math.pow(vecBetween.y, 2.0) + Math.pow(vecBetween.z, 2.0))) * 0.08;
            entity.setDeltaMovement(vecBetweenMod.x, vecBetweenMod.y + yOffset, vecBetweenMod.z);
        }
    }

    @Inject(method={"retrieve"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")})
    private void retrieveLureOnSuccess(ItemStack usedItem, CallbackInfoReturnable<Integer> cir) {
        this.retrieveLure(this.getPlayerOwner());
    }

    @Inject(method={"shouldStopFishing"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")})
    private void retrieveLureIfInvalid(Player player, CallbackInfoReturnable<Boolean> cir) {
        this.retrieveLure(player);
    }

    @Unique
    private void retrieveLure(Player player) {
        if (!this.lureItemStack.isEmpty()) {
            Vec3 pos;
            if (player == null || player.isRemoved() || !player.isAlive()) {
                pos = this.position();
            } else {
                if (player.getItemBySlot(EquipmentSlot.OFFHAND).isEmpty()) {
                    player.setItemSlot(EquipmentSlot.OFFHAND, this.lureItemStack);
                    if (player.getItemBySlot(EquipmentSlot.OFFHAND) == this.lureItemStack) {
                        return;
                    }
                }
                if (player.getInventory().add(this.lureItemStack)) {
                    return;
                }
                pos = player.position();
            }
            ItemEntity itemEntity = new ItemEntity(this.level(), pos.x, pos.y, pos.z, this.lureItemStack);
            itemEntity.setDeltaMovement(Vec3.ZERO);
            this.level().addFreshEntity((Entity)itemEntity);
        }
    }
}

