/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.network;

import dev.hybridlabs.aquatic.access.CustomFishingBobberEntityData;
import dev.hybridlabs.aquatic.network.FishingBobberPayload;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0012"}, d2={"Ldev/hybridlabs/aquatic/network/HybridAquaticNetworkingForge;", "", "<init>", "()V", "register", "", "event", "Lnet/neoforged/neoforge/network/event/RegisterPayloadHandlersEvent;", "sendHookPacket", "entityId", "", "entityData", "Lnet/minecraft/world/item/ItemStack;", "sendClientHookPacket", "player", "Lnet/minecraft/server/level/ServerPlayer;", "ClientPayloadHandler", "ServerPayloadHandler", "hybrid-aquatic-neoforge-1.21.1"})
public final class HybridAquaticNetworkingForge {
    @NotNull
    public static final HybridAquaticNetworkingForge INSTANCE = new HybridAquaticNetworkingForge();

    private HybridAquaticNetworkingForge() {
    }

    @SubscribeEvent
    public final void register(@NotNull RegisterPayloadHandlersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playBidirectional(FishingBobberPayload.Companion.getType(), FishingBobberPayload.Companion.getCODEC(), (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandler.INSTANCE::handleDataOnMain, ServerPayloadHandler.INSTANCE::handleDataOnMain));
    }

    public final void sendHookPacket(int entityId, @NotNull ItemStack entityData) {
        Intrinsics.checkNotNullParameter((Object)entityData, (String)"entityData");
        PacketDistributor.sendToServer((CustomPacketPayload)new FishingBobberPayload(entityId, entityData), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendClientHookPacket(@NotNull ServerPlayer player, int entityId, @NotNull ItemStack entityData) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entityData, (String)"entityData");
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new FishingBobberPayload(entityId, entityData), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ldev/hybridlabs/aquatic/network/HybridAquaticNetworkingForge$ClientPayloadHandler;", "", "<init>", "()V", "handleDataOnMain", "", "data", "Ldev/hybridlabs/aquatic/network/FishingBobberPayload;", "context", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class ClientPayloadHandler {
        @NotNull
        public static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

        private ClientPayloadHandler() {
        }

        public final void handleDataOnMain(@NotNull FishingBobberPayload data, @NotNull IPayloadContext context) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Minecraft client = Minecraft.getInstance();
            ClientLevel clientLevel = client.level;
            Intrinsics.checkNotNull((Object)clientLevel);
            Entity foundEntity = clientLevel.getEntity(data.getId());
            ItemStack itemStack = data.getLure();
            if (foundEntity == null || !(foundEntity instanceof FishingHook)) {
                return;
            }
            CustomFishingBobberEntityData additionalBobberData = (CustomFishingBobberEntityData)foundEntity;
            additionalBobberData.hybrid_aquatic$setLureItem(itemStack);
            INSTANCE.sendHookPacket(data.getId(), itemStack);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ldev/hybridlabs/aquatic/network/HybridAquaticNetworkingForge$ServerPayloadHandler;", "", "<init>", "()V", "handleDataOnMain", "", "data", "Ldev/hybridlabs/aquatic/network/FishingBobberPayload;", "context", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class ServerPayloadHandler {
        @NotNull
        public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

        private ServerPayloadHandler() {
        }

        public final void handleDataOnMain(@NotNull FishingBobberPayload data, @NotNull IPayloadContext context) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Player sender = context.player();
            if (!(sender instanceof ServerPlayer)) {
                return;
            }
            Entity foundEntity = ((ServerPlayer)sender).level().getEntity(data.getId());
            if (!(foundEntity instanceof FishingHook)) {
                return;
            }
            CustomFishingBobberEntityData additionalBobberData = (CustomFishingBobberEntityData)foundEntity;
            ItemStack itemStack = additionalBobberData.hybrid_aquatic$getLureItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"hybrid_aquatic$getLureItem(...)");
            ItemStack lureItem = itemStack;
            if (lureItem.isEmpty()) {
                return;
            }
            INSTANCE.sendClientHookPacket((ServerPlayer)sender, foundEntity.getId(), lureItem);
        }
    }
}

