/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.world.gen.feature;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.block.MessageInABottleBlock;
import dev.hybridlabs.aquatic.block.entity.MessageInABottleBlockEntity;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import dev.hybridlabs.aquatic.world.gen.feature.MessageInABottleFeatureConfig;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/hybridlabs/aquatic/world/gen/feature/MessageInABottleFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Ldev/hybridlabs/aquatic/world/gen/feature/MessageInABottleFeatureConfig;", "codec", "Lcom/mojang/serialization/Codec;", "<init>", "(Lcom/mojang/serialization/Codec;)V", "place", "", "context", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "hybrid-aquatic-neoforge-1.21.1"})
public final class MessageInABottleFeature
extends Feature<MessageInABottleFeatureConfig> {
    public MessageInABottleFeature(@NotNull Codec<MessageInABottleFeatureConfig> codec) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<MessageInABottleFeatureConfig> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        MessageInABottleFeatureConfig config = (MessageInABottleFeatureConfig)context.config();
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BlockState state = config.getToPlace().getState(random, origin);
        if (!(state.getBlock() instanceof MessageInABottleBlock)) {
            return false;
        }
        BlockPos.MutableBlockPos pos = context.origin().mutable();
        if (!state.canSurvive((LevelReader)world, (BlockPos)pos)) {
            if (state.canSurvive((LevelReader)world, pos.below())) {
                pos.move(Direction.DOWN);
            } else {
                return false;
            }
        }
        world.setBlock((BlockPos)pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.isWaterAt((BlockPos)pos))), 2);
        BlockEntity blockEntity = world.getBlockEntity((BlockPos)pos);
        if (!(blockEntity instanceof MessageInABottleBlockEntity)) {
            return false;
        }
        EnumEntries<MessageInABottleBlock.Variant> entries = MessageInABottleBlock.Variant.getEntries();
        ((MessageInABottleBlockEntity)blockEntity).setVariant((MessageInABottleBlock.Variant)((Object)entries.get(random.nextInt(entries.size()))));
        RegistryAccess registryManager = world.registryAccess();
        Registry registry = registryManager.registryOrThrow(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE());
        registry.getRandom(random).ifPresent(arg_0 -> MessageInABottleFeature.place$lambda$1(arg_0 -> MessageInABottleFeature.place$lambda$0(blockEntity, arg_0), arg_0));
        return true;
    }

    private static final Unit place$lambda$0(BlockEntity $blockEntity, Holder.Reference messageEntry) {
        Intrinsics.checkNotNullParameter((Object)messageEntry, (String)"messageEntry");
        ((MessageInABottleBlockEntity)$blockEntity).setMessageId(messageEntry.key().location());
        return Unit.INSTANCE;
    }

    private static final void place$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

