/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.Constants;
import dev.hybridlabs.aquatic.block.PlushieBlock;
import dev.hybridlabs.aquatic.block.SeaMessage;
import dev.hybridlabs.aquatic.block.wood.HybridAquaticPlatformBlocks;
import dev.hybridlabs.aquatic.config.ConfigHelper;
import dev.hybridlabs.aquatic.config.EntitySpawnConfig;
import dev.hybridlabs.aquatic.config.HybridAquaticConfig;
import dev.hybridlabs.aquatic.config.HybridAquaticConfigHandler;
import dev.hybridlabs.aquatic.entity.SpawnRestrictionRegistry;
import dev.hybridlabs.aquatic.loot.LootTableModifications;
import dev.hybridlabs.aquatic.network.HybridAquaticFabricNetworking;
import dev.hybridlabs.aquatic.platform.registration.RegistryObject;
import dev.hybridlabs.aquatic.potions.HybridAquaticPotions;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import dev.hybridlabs.aquatic.utils.HybridAquaticCustomTrades;
import dev.hybridlabs.aquatic.world.gen.feature.DunegrassFeature;
import dev.hybridlabs.aquatic.world.gen.feature.FeatureBiomeModifications;
import dev.hybridlabs.aquatic.world.gen.feature.HybridAquaticFeatures;
import dev.hybridlabs.aquatic.world.gen.structure.FabricSpawnModifiers;
import dev.hybridlabs.aquatic.world.gen.structure.SpawnModifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1311;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1845;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3133;
import net.minecraft.class_3853;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003R#\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Ldev/hybridlabs/aquatic/HybridAquatic;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "registerDynamicRegistries", "registerWanderingTraderTrades", "Lnet/fabricmc/fabric/api/registry/FlammableBlockRegistry;", "registry", "registerFlammables", "(Lnet/fabricmc/fabric/api/registry/FlammableBlockRegistry;)V", "registerStrippables", "Ldev/hybridlabs/aquatic/config/HybridAquaticConfig;", "config", "registerBiomeModifications", "(Ldev/hybridlabs/aquatic/config/HybridAquaticConfig;)V", "registerBrewingRecipes", "Ldev/hybridlabs/aquatic/platform/registration/RegistryObject;", "Lnet/minecraft/class_3031;", "Lnet/minecraft/class_3037;", "DUNEGRASS_PATCH", "Ldev/hybridlabs/aquatic/platform/registration/RegistryObject;", "getDUNEGRASS_PATCH", "()Ldev/hybridlabs/aquatic/platform/registration/RegistryObject;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "hybrid-aquatic-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nHybridAquatic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquatic.kt\ndev/hybridlabs/aquatic/HybridAquatic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n774#2:165\n865#2,2:166\n1869#2,2:168\n1869#2,2:170\n*S KotlinDebug\n*F\n+ 1 HybridAquatic.kt\ndev/hybridlabs/aquatic/HybridAquatic\n*L\n105#1:165\n105#1:166,2\n106#1:168,2\n139#1:170,2\n*E\n"})
public final class HybridAquatic
implements ModInitializer {
    @NotNull
    public static final HybridAquatic INSTANCE = new HybridAquatic();
    @NotNull
    private static final RegistryObject<class_3031<class_3037>> DUNEGRASS_PATCH;
    private static final Logger logger;

    private HybridAquatic() {
    }

    @NotNull
    public final RegistryObject<class_3031<class_3037>> getDUNEGRASS_PATCH() {
        return DUNEGRASS_PATCH;
    }

    public void onInitialize() {
        logger.info("Initializing Hybrid Aquatic");
        CommonClass.init();
        this.registerBrewingRecipes();
        HybridAquaticFabricNetworking.INSTANCE.registerNetworking();
        LootTableModifications.INSTANCE.registerLootModifications();
        FeatureBiomeModifications.INSTANCE.registerBiomeModifications();
        SpawnRestrictionRegistry.INSTANCE.registerSpawnRestrictions();
        this.registerDynamicRegistries();
        this.registerWanderingTraderTrades();
        HybridAquaticCustomTrades.registerCustomTrades();
        FlammableBlockRegistry flammableBlockRegistry = FlammableBlockRegistry.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)flammableBlockRegistry, (String)"getDefaultInstance(...)");
        this.registerFlammables(flammableBlockRegistry);
        this.registerStrippables();
        Path path = CommonClass.CONFIG_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"CONFIG_FILE");
        HybridAquaticConfigHandler configHandler = ConfigHelper.INSTANCE.initializeConfig(path);
        this.registerBiomeModifications(configHandler.getConfig());
        ServerLifecycleEvents.SERVER_STARTING.register(HybridAquatic::onInitialize$lambda$0);
    }

    private final void registerDynamicRegistries() {
        DynamicRegistries.registerSynced(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE(), SeaMessage.Companion.getCODEC(), (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.register(HybridAquaticRegistryKeys.INSTANCE.getSTRUCTURE_SPAWN_MODIFIER(), SpawnModifier.Companion.getCODEC());
    }

    /*
     * WARNING - void declaration
     */
    private final void registerWanderingTraderTrades() {
        void $this$filterTo$iv$iv;
        class_7922 class_79222 = class_7923.field_41178;
        Intrinsics.checkNotNullExpressionValue((Object)class_79222, (String)"ITEM");
        Iterable $this$filter$iv = (Iterable)class_79222;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_1792 it = (class_1792)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof class_1747 && ((class_1747)it).method_7711() instanceof PlushieBlock)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_1792 block = (class_1792)element$iv;
            boolean bl = false;
            TradeOfferHelper.registerWanderingTraderOffers((int)2, arg_0 -> HybridAquatic.registerWanderingTraderTrades$lambda$1$0(block, arg_0));
        }
    }

    private final void registerFlammables(FlammableBlockRegistry registry) {
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getDUNEGRASS().get(), 5, 5);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getTALL_DUNEGRASS().get(), 5, 5);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getCATTAIL().get(), 5, 5);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getDRIFTWOOD_LOG().get(), 5, 5);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getSTRIPPED_DRIFTWOOD_LOG().get(), 5, 5);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getDRIFTWOOD_WOOD().get(), 5, 5);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getSTRIPPED_DRIFTWOOD_WOOD().get(), 5, 5);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getDRIFTWOOD_PLANKS().get(), 5, 20);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getDRIFTWOOD_SLAB().get(), 5, 20);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getDRIFTWOOD_FENCE().get(), 5, 20);
        registry.add(HybridAquaticPlatformBlocks.INSTANCE.getDRIFTWOOD_FENCE_GATE().get(), 5, 20);
    }

    private final void registerStrippables() {
        StrippableBlockRegistry.register((class_2248)HybridAquaticPlatformBlocks.INSTANCE.getDRIFTWOOD_LOG().get(), (class_2248)HybridAquaticPlatformBlocks.INSTANCE.getSTRIPPED_DRIFTWOOD_LOG().get());
        StrippableBlockRegistry.register((class_2248)HybridAquaticPlatformBlocks.INSTANCE.getDRIFTWOOD_WOOD().get(), (class_2248)HybridAquaticPlatformBlocks.INSTANCE.getSTRIPPED_DRIFTWOOD_WOOD().get());
    }

    private final void registerBiomeModifications(HybridAquaticConfig config) {
        Iterable $this$forEach$iv = config.getEntitySpawnConfig();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntitySpawnConfig config2 = (EntitySpawnConfig)element$iv;
            boolean bl = false;
            BiomeModifications.addSpawn((Predicate)BiomeSelectors.tag(config2.getBiomes()), (class_1311)config2.getGroup(), config2.getType(), (int)config2.getWeight(), (int)config2.getMinGroupSize(), (int)config2.getMaxGroupSize());
        }
    }

    private final void registerBrewingRecipes() {
        FabricBrewingRecipeRegistryBuilder.BUILD.register(HybridAquatic::registerBrewingRecipes$lambda$0);
    }

    private static final void onInitialize$lambda$0(MinecraftServer server) {
        Intrinsics.checkNotNull((Object)server);
        FabricSpawnModifiers.INSTANCE.load(server);
    }

    private static final void registerWanderingTraderTrades$lambda$1$0(class_1792 $block, List list) {
        list.add(new class_3853.class_4165($block, 8, 1, 2, 2));
    }

    private static final void registerBrewingRecipes$lambda$0(class_1845.class_9665 builder) {
        for (HybridAquaticPotions.PotionRecipe recipe : HybridAquaticPotions.INSTANCE.getRecipes().get()) {
            class_1935[] class_1935Array = new class_1935[]{recipe.getAddition()};
            builder.registerPotionRecipe(recipe.getInputPotion(), class_1856.method_8091((class_1935[])class_1935Array), recipe.getOutputPotion());
        }
    }

    static {
        Codec codec = class_3133.field_24899;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
        DUNEGRASS_PATCH = HybridAquaticFeatures.INSTANCE.register("dunegrass_patch", (class_3031)new DunegrassFeature((Codec<class_3133>)codec));
        logger = Constants.LOG;
    }
}

