/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.platform.services;

import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.block.HybridAquaticBlocks;
import dev.hybridlabs.aquatic.item.AnemoneBlockItem;
import dev.hybridlabs.aquatic.item.GiantGreenAnemoneBlockItem;
import dev.hybridlabs.aquatic.item.MessageInABottleItem;
import dev.hybridlabs.aquatic.item.StrawberryAnemoneBlockItem;
import dev.hybridlabs.aquatic.network.FishingBobberPayload;
import dev.hybridlabs.aquatic.platform.registration.RegistryObject;
import dev.hybridlabs.aquatic.platform.services.PlatformHelper;
import dev.hybridlabs.aquatic.utils.HybridAquaticSpawnGroup;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2248;
import net.minecraft.class_2902;
import net.minecraft.class_5132;
import net.minecraft.class_8710;
import net.minecraft.class_9168;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricPlatformHelper
implements PlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public <T extends class_1308> Supplier<class_1826> registerSpawnEggItem(@NotNull String name, Supplier<class_1299<T>> entityType, int backgroundColor, int highlightColor) {
        return CommonClass.ITEMS.register(name, () -> new class_1826((class_1299)entityType.get(), backgroundColor, highlightColor, new class_1792.class_1793()));
    }

    @Override
    public Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public <T extends class_1308> void registerSpawnPlacement(RegistryObject<class_1299<T>> entityType, class_9168 decoratorType, class_2902.class_2903 heightMapType, class_1317.class_4306<T> decoratorPredicate) {
        class_1317.method_20637(entityType.get(), (class_9168)decoratorType, (class_2902.class_2903)heightMapType, decoratorPredicate);
    }

    @Override
    public <T extends class_1309> void registerAttributes(@NotNull String id, class_1299<T> entityType, Callable<class_5132.class_5133> attributeContainer) {
        try {
            FabricDefaultAttributeRegistry.register(entityType, (class_5132.class_5133)attributeContainer.call());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public class_1311 getMobCategoryByName(String name) {
        return HybridAquaticSpawnGroup.byName(name);
    }

    @Override
    public class_1792 createBlockItem(class_2248 block, class_1792.class_1793 properties) {
        if (block.equals(HybridAquaticBlocks.INSTANCE.getANEMONE().get())) {
            return new AnemoneBlockItem(block, properties);
        }
        if (block.equals(HybridAquaticBlocks.INSTANCE.getSTRAWBERRY_ANEMONE().get())) {
            return new StrawberryAnemoneBlockItem(block, properties);
        }
        if (block.equals(HybridAquaticBlocks.INSTANCE.getGIANT_GREEN_ANEMONE().get())) {
            return new GiantGreenAnemoneBlockItem(block, properties);
        }
        return new class_1747(block, properties);
    }

    @Override
    public class_1792 createMessageInABottleItem(class_1792.class_1793 properties) {
        return new MessageInABottleItem(properties);
    }

    @Override
    public void sendHookToServer(int entityId, class_1799 entityData) {
        if (ClientPlayNetworking.canSend(FishingBobberPayload.Companion.getType())) {
            ClientPlayNetworking.send((class_8710)new FishingBobberPayload(entityId, entityData));
        }
    }
}

