/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.world.gen.structure;

import dev.hybridlabs.aquatic.Constants;
import dev.hybridlabs.aquatic.platform.Services;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import dev.hybridlabs.aquatic.world.gen.structure.SpawnModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.class_7061;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u001e\u0010\u000b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ldev/hybridlabs/aquatic/world/gen/structure/FabricSpawnModifiers;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "Lnet/minecraft/class_5321;", "Lnet/minecraft/class_3195;", "Ljava/util/function/Supplier;", "Ldev/hybridlabs/aquatic/world/gen/structure/SpawnModifier;", "modifiers", "", "register", "(Lnet/minecraft/server/MinecraftServer;Ljava/util/Map;)V", "load", "(Lnet/minecraft/server/MinecraftServer;)V", "structure", "modifier", "modify", "(Lnet/minecraft/class_3195;Ldev/hybridlabs/aquatic/world/gen/structure/SpawnModifier;)V", "hybrid-aquatic-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nFabricSpawnModifiers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FabricSpawnModifiers.kt\ndev/hybridlabs/aquatic/world/gen/structure/FabricSpawnModifiers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,59:1\n1869#2,2:60\n216#3,2:62\n*S KotlinDebug\n*F\n+ 1 FabricSpawnModifiers.kt\ndev/hybridlabs/aquatic/world/gen/structure/FabricSpawnModifiers\n*L\n28#1:60,2\n40#1:62,2\n*E\n"})
public final class FabricSpawnModifiers {
    @NotNull
    public static final FabricSpawnModifiers INSTANCE = new FabricSpawnModifiers();

    private FabricSpawnModifiers() {
    }

    public final void register(@NotNull MinecraftServer server, @NotNull Map<class_5321<class_3195>, ? extends Supplier<SpawnModifier>> modifiers) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        class_2378 registry = server.method_30611().method_30530(class_7924.field_41246);
        for (Map.Entry<class_5321<class_3195>, ? extends Supplier<SpawnModifier>> entry : modifiers.entrySet()) {
            class_5321<class_3195> structureKey = entry.getKey();
            Supplier<SpawnModifier> modifier = entry.getValue();
            class_3195 structure = (class_3195)registry.method_31140(structureKey);
            Intrinsics.checkNotNull((Object)structure);
            SpawnModifier spawnModifier = modifier.get();
            Intrinsics.checkNotNullExpressionValue((Object)spawnModifier, (String)"get(...)");
            this.modify(structure, spawnModifier);
        }
    }

    public final void load(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_2378 modifierRegistry = server.method_30611().method_30530(HybridAquaticRegistryKeys.INSTANCE.getSTRUCTURE_SPAWN_MODIFIER());
        class_2378 structureRegistry = server.method_30611().method_30530(class_7924.field_41246);
        Intrinsics.checkNotNull((Object)modifierRegistry);
        Iterable $this$forEach$iv = (Iterable)modifierRegistry;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpawnModifier it = (SpawnModifier)element$iv;
            boolean bl = false;
            structureRegistry.method_40264(it.getStructure()).ifPresent(arg_0 -> FabricSpawnModifiers.load$lambda$0$1(arg_0 -> FabricSpawnModifiers.load$lambda$0$0(it, arg_0), arg_0));
        }
    }

    public final void modify(@NotNull class_3195 structure, @NotNull SpawnModifier modifier) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        class_3195.class_7302 settings = structure.field_38429;
        Map map = structure.method_41615();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"spawnOverrides(...)");
        Map overrides = MapsKt.toMutableMap((Map)map);
        Map<String, List<class_5483.class_1964>> $this$forEach$iv = modifier.getSpawns();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<class_5483.class_1964>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            class_7061 class_70612;
            List oSpawns;
            Collection collection;
            Map.Entry<String, List<class_5483.class_1964>> element$iv;
            Map.Entry<String, List<class_5483.class_1964>> entry = element$iv = iterator.next();
            boolean bl = false;
            String categoryName = entry.getKey();
            List<class_5483.class_1964> spawns = entry.getValue();
            class_1311 category = Services.PLATFORM.getMobCategoryByName(categoryName);
            if (category == null || !((collection = (Collection)(oSpawns = (class_70612 = (class_7061)overrides.get(category)) != null && (class_70612 = class_70612.comp_515()) != null ? class_70612.method_34994() : null)) == null || collection.isEmpty())) continue;
            oSpawns = new ArrayList();
            oSpawns.addAll((Collection)spawns);
            overrides.put(category, new class_7061(modifier.getBoundingBoxType(), class_6012.method_34988(spawns)));
        }
        structure.field_38429 = new class_3195.class_7302(settings.comp_686(), overrides, settings.comp_688(), settings.comp_689());
    }

    private static final Unit load$lambda$0$0(SpawnModifier $it, class_6880.class_6883 structure) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Constants.LOG.info("Loaded structure spawn modifier for: {}", $it.getStructure());
        Object object = structure.comp_349();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        class_3195 class_31952 = (class_3195)object;
        Intrinsics.checkNotNull((Object)$it);
        INSTANCE.modify(class_31952, $it);
        return Unit.INSTANCE;
    }

    private static final void load$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

