/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.platform.services;

import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.platform.registration.RegistrationProvider;
import dev.hybridlabs.aquatic.platform.registration.RegistryObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class FabricRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(class_5321<? extends class_2378<T>> resourceKey, String modId) {
        return new Provider(modId, resourceKey);
    }

    @Override
    public <T> RegistrationProvider<T> create(class_2378<T> registry, String modId) {
        return new Provider<T>(modId, registry);
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        private final String modId;
        private final class_2378<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, class_5321<? extends class_2378<T>> key) {
            this.modId = modId;
            class_2378 reg = (class_2378)class_7923.field_41167.method_10223(key.method_29177());
            if (reg == null) {
                throw new RuntimeException("Registry with name " + key.method_29177() + " was not found!");
            }
            this.registry = reg;
        }

        private Provider(String modId, class_2378<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final class_2960 rl = CommonClass.locate(name);
            final Object obj = class_2378.method_10230(this.registry, (class_2960)rl, supplier.get());
            RegistryObject ro = new RegistryObject<I>(){
                final class_5321<I> key;
                {
                    this.key = class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)rl);
                }

                @Override
                public class_5321<I> getResourceKey() {
                    return this.key;
                }

                @Override
                public class_2960 getId() {
                    return rl;
                }

                @Override
                public I get() {
                    return obj;
                }

                @Override
                public class_6880<I> asHolder() {
                    return (class_6880)registry.method_40264(this.key).orElseThrow();
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}

