/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.mixin;

import com.google.common.collect.ImmutableList;
import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.access.CustomPlayerEntityData;
import dev.hybridlabs.aquatic.effect.HybridAquaticMobEffects;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import dev.hybridlabs.aquatic.item.HybridAquaticToolMaterials;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_3486;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1297
implements CustomPlayerEntityData {
    @Unique
    private boolean isWearingDivingBoots;
    @Unique
    int coralRepairTick = 0;

    public PlayerEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean method_5681();

    @Inject(method={"isAffectedByFluids"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideShouldSwimInFluids(CallbackInfoReturnable<Boolean> ci) {
        if (this.isWearingDivingBoots && !this.method_5681() && this.method_5869()) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void updateEquipment(CallbackInfo ci) {
        this.updateDivingHelmet();
        this.updateDivingBoots();
        this.updateTurtleChestplate();
        this.repairCoralTools();
    }

    @Unique
    private void updateDivingHelmet() {
        class_1657 player = (class_1657)this;
        class_1799 itemStack = player.method_6118(class_1304.field_6169);
        if (itemStack.method_31574(HybridAquaticItems.INSTANCE.getDIVING_HELMET().get())) {
            if (!player.method_5777(class_3486.field_15517)) {
                player.method_6092(new class_1293(class_1294.field_5923, 600, 0, false, false, false));
            } else {
                player.method_6092(new class_1293(HybridAquaticMobEffects.INSTANCE.getCLARITY().asHolder(), 600, 0, false, false, false));
            }
        }
    }

    @Unique
    private void updateDivingBoots() {
        class_1657 player = (class_1657)this;
        class_1799 itemStack = player.method_6118(class_1304.field_6166);
        this.isWearingDivingBoots = itemStack.method_31574(HybridAquaticItems.INSTANCE.getDIVING_BOOTS().get());
        this.updateStepHeight();
    }

    @Unique
    private void updateTurtleChestplate() {
        class_1657 player = (class_1657)this;
        class_1799 itemStack = player.method_6118(class_1304.field_6174);
        if (itemStack.method_31574(HybridAquaticItems.INSTANCE.getTURTLE_CHESTPLATE().get())) {
            player.method_6092(new class_1293(class_1294.field_5907, 200, 0, false, false, true));
            player.method_6092(new class_1293(class_1294.field_5909, 200, 0, false, false, true));
        }
    }

    @Unique
    private void repairCoralTools() {
        class_1657 player = (class_1657)this;
        class_1661 inventory = player.method_31548();
        if (player.method_5777(class_3486.field_15517)) {
            if (this.coralRepairTick > 5) {
                ImmutableList combinedInventory = ImmutableList.of((Object)inventory.field_7547, (Object)inventory.field_7544);
                ArrayList<class_1799> coralItems = new ArrayList<class_1799>();
                for (List list : combinedInventory) {
                    for (class_1799 itemStack : list) {
                        class_1831 tool;
                        class_1792 class_17922 = itemStack.method_7909();
                        if (!(class_17922 instanceof class_1831) || (tool = (class_1831)class_17922).method_8022() != HybridAquaticToolMaterials.CORAL || !itemStack.method_7986()) continue;
                        coralItems.add(itemStack);
                    }
                }
                if (!coralItems.isEmpty()) {
                    class_1799 item = (class_1799)coralItems.get(player.method_59922().method_43048(coralItems.size()));
                    item.method_7974(item.method_7919() - 1);
                    inventory.method_5431();
                }
                this.coralRepairTick = 0;
            }
            ++this.coralRepairTick;
        }
    }

    @Unique
    private void updateStepHeight() {
        class_1657 player;
        class_1324 stepHeight;
        class_1309 entity = (class_1309)this;
        if (entity instanceof class_1657 && (stepHeight = (player = (class_1657)entity).method_5996(class_5134.field_47761)) != null) {
            if (this.isWearingDivingBoots && player.method_5869()) {
                stepHeight.method_55696(CommonClass.DIVING_BOOTS_STEP_MODIFIER);
            } else {
                stepHeight.method_6202(CommonClass.DIVING_BOOTS_STEP_MODIFIER);
            }
        }
    }
}

