/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.config;

import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.Constants;
import dev.hybridlabs.aquatic.config.HybridAquaticConfig;
import dev.hybridlabs.aquatic.config.HybridAquaticConfigHandler;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/hybridlabs/aquatic/config/ConfigHelper;", "", "<init>", "()V", "initializeConfig", "Ldev/hybridlabs/aquatic/config/HybridAquaticConfigHandler;", "configFile", "Ljava/nio/file/Path;", "hybrid-aquatic-forge-1.20.1"})
public final class ConfigHelper {
    @NotNull
    public static final ConfigHelper INSTANCE = new ConfigHelper();

    private ConfigHelper() {
    }

    @NotNull
    public final HybridAquaticConfigHandler initializeConfig(@NotNull Path configFile) {
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        Logger logger = Constants.LOG;
        File file = configFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        HybridAquaticConfigHandler configHandler = new HybridAquaticConfigHandler(file, null, 2, null);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.info("Hybrid Aquatic config file did not exist, creating one");
            configHandler.save();
        } else {
            logger.info("Loading Hybrid Aquatic config file");
            configHandler.load();
            HybridAquaticConfig defaultConfig = configHandler.getDefaultConfig();
            HybridAquaticConfig config = configHandler.getConfig();
            if (config.getDataVersion() < defaultConfig.getDataVersion()) {
                logger.info("Old Hybrid Aquatic config file found, upgrading");
                configHandler.backup();
                configHandler.setConfig(defaultConfig);
                configHandler.save();
                logger.info("Hybrid Aquatic config reset, the old config has been backed up to \"" + configHandler.getBackupFile() + "\"");
            }
        }
        return configHandler;
    }

    public static /* synthetic */ HybridAquaticConfigHandler initializeConfig$default(ConfigHelper configHelper, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = CommonClass.CONFIG_FILE;
        }
        return configHelper.initializeConfig(path);
    }
}

