/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal;

import com.mojang.datafixers.DataFixUtils;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticSchoolingFishEntity;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/FishFollowGroupLeaderGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "fish", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;)V", "getFish", "()Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;", "minSearchDelay", "", "moveDelay", "checkSurroundingDelay", "getSurroundingSearchDelay", "canUse", "", "canContinueToUse", "start", "", "stop", "tick", "hybrid-aquatic-forge-1.20.1"})
public final class FishFollowGroupLeaderGoal
extends Goal {
    @NotNull
    private final HybridAquaticSchoolingFishEntity fish;
    private final int minSearchDelay;
    private int moveDelay;
    private int checkSurroundingDelay;

    public FishFollowGroupLeaderGoal(@NotNull HybridAquaticSchoolingFishEntity fish) {
        Intrinsics.checkNotNullParameter((Object)((Object)fish), (String)"fish");
        this.fish = fish;
        this.minSearchDelay = 200;
        this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.fish);
    }

    @NotNull
    public final HybridAquaticSchoolingFishEntity getFish() {
        return this.fish;
    }

    private final int getSurroundingSearchDelay(HybridAquaticSchoolingFishEntity fish) {
        HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity = fish;
        Intrinsics.checkNotNull((Object)((Object)hybridAquaticSchoolingFishEntity));
        return Goal.m_186073_((int)(this.minSearchDelay + hybridAquaticSchoolingFishEntity.m_217043_().m_188503_(this.minSearchDelay) % 20));
    }

    public boolean m_8036_() {
        boolean bl;
        if (this.fish.hasOtherFishInGroup()) {
            bl = false;
        } else if (this.fish.hasLeader()) {
            bl = true;
        } else if (this.checkSurroundingDelay > 0) {
            this.checkSurroundingDelay += -1;
            bl = false;
        } else {
            HybridAquaticSchoolingFishEntity schoolingFishEntity;
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.fish);
            Predicate<HybridAquaticSchoolingFishEntity> predicate = FishFollowGroupLeaderGoal::canUse$lambda$0;
            List list = this.fish.m_9236_().m_6443_(((Object)((Object)this.fish)).getClass(), this.fish.m_20191_().m_82377_(8.0, 8.0, 8.0), predicate);
            HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity = schoolingFishEntity = (HybridAquaticSchoolingFishEntity)((Object)DataFixUtils.orElse(list.stream().filter(arg_0 -> FishFollowGroupLeaderGoal.canUse$lambda$2(FishFollowGroupLeaderGoal::canUse$lambda$1, arg_0)).findAny(), (Object)((Object)this.fish)));
            Intrinsics.checkNotNull((Object)((Object)hybridAquaticSchoolingFishEntity));
            Stream<Object> stream = list.stream().filter(arg_0 -> FishFollowGroupLeaderGoal.canUse$lambda$4(FishFollowGroupLeaderGoal::canUse$lambda$3, arg_0));
            Intrinsics.checkNotNullExpressionValue(stream, (String)"filter(...)");
            hybridAquaticSchoolingFishEntity.pullInOtherFish(stream);
            bl = this.fish.hasLeader();
        }
        return bl;
    }

    public boolean m_8045_() {
        return this.fish.hasLeader() && this.fish.isCloseEnoughToLeader();
    }

    public void m_8056_() {
        this.moveDelay = 0;
    }

    public void m_8041_() {
        this.fish.leaveGroup();
    }

    public void m_8037_() {
        this.moveDelay += -1;
        if (this.moveDelay <= 0) {
            this.moveDelay = this.m_183277_(10);
            this.fish.moveTowardLeader();
        }
    }

    private static final boolean canUse$lambda$0(HybridAquaticSchoolingFishEntity fish) {
        Intrinsics.checkNotNullParameter((Object)((Object)fish), (String)"fish");
        return fish.canHaveMoreFishInGroup() || !fish.hasLeader();
    }

    private static final boolean canUse$lambda$1(HybridAquaticSchoolingFishEntity obj) {
        HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity = obj;
        Intrinsics.checkNotNull((Object)((Object)hybridAquaticSchoolingFishEntity));
        return hybridAquaticSchoolingFishEntity.canHaveMoreFishInGroup();
    }

    private static final boolean canUse$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean canUse$lambda$3(HybridAquaticSchoolingFishEntity fish) {
        HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity = fish;
        Intrinsics.checkNotNull((Object)((Object)hybridAquaticSchoolingFishEntity));
        return !hybridAquaticSchoolingFishEntity.hasLeader();
    }

    private static final boolean canUse$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

